/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets;

import android.animation.IntEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.ahmadullahpk.alldocumentreader.R;
import java.util.List;

public class TooltipIndicator
extends RelativeLayout
implements ViewPager.OnPageChangeListener,
View.OnTouchListener {
    private static final String TAG = "ToolTipIndicator";
    private int lineWidth;
    private int lineWidthSelected;
    private int lineHeight;
    private int lineMargin;
    private int lineWidthWithMargin;
    private int lineWidthSelectedWithMargin;
    private int tooltipWidth;
    private int tooltipHeight;
    private int selectedLineDrawableResource;
    private int unselectedLineDrawableResource;
    private PagerAdapter adapter;
    private LinearLayout linesLayout;
    private RelativeLayout tooltipView;
    private AppCompatImageView tooltipViewImage;
    private int selectedPosition = -1;
    private ValueAnimator expandAnimator;
    private ValueAnimator collapseAnimator;
    private Drawable[] drawableList;

    public TooltipIndicator(Context context) {
        this(context, null);
    }

    public TooltipIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TooltipIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.setClickable(true);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TooltipIndicator);
        try {
            this.lineWidth = (int)typedArray.getDimension(R.styleable.TooltipIndicator_ti_lineWidth, (float)this.dpToPx(16));
            this.lineHeight = (int)typedArray.getDimension(R.styleable.TooltipIndicator_ti_lineHeight, (float)this.dpToPx(6));
            this.lineWidthSelected = (int)typedArray.getDimension(R.styleable.TooltipIndicator_ti_lineWidthSelected, (float)this.dpToPx(32));
            this.lineMargin = (int)typedArray.getDimension(R.styleable.TooltipIndicator_ti_lineMargin, (float)this.dpToPx(4));
            this.lineWidthWithMargin = this.lineWidth + this.lineMargin * 2;
            this.lineWidthSelectedWithMargin = this.lineWidthSelected + this.lineMargin * 2;
            this.tooltipWidth = (int)typedArray.getDimension(R.styleable.TooltipIndicator_ti_tooltipWidth, (float)this.dpToPx(100));
            this.tooltipHeight = (int)typedArray.getDimension(R.styleable.TooltipIndicator_ti_tooltipHeight, (float)this.dpToPx(180));
            this.selectedLineDrawableResource = typedArray.getResourceId(R.styleable.TooltipIndicator_ti_selectedLineDrawable, R.drawable.tooltip_indicator_rounded_line_selected);
            this.unselectedLineDrawableResource = typedArray.getResourceId(R.styleable.TooltipIndicator_ti_unselectedLineDrawable, R.drawable.tooltip_indicator_rounded_line_unselected);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setupViewPager(ViewPager viewPager) {
        this.adapter = viewPager.getAdapter();
        if (this.adapter == null) {
            throw new NullPointerException("ViewPager's adapter cannot be null.");
        }
        this.removeAllViews();
        this.initIndicatorLines();
        this.initToolTipView();
        this.selectPage(0);
        viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.setOnTouchListener(this);
    }

    public void setToolTipDrawables(List<Drawable> drawableList) {
        if (this.adapter == null) {
            throw new NullPointerException("ViewPager's adapter cannot be null.");
        }
        this.drawableList = drawableList.toArray(new Drawable[this.adapter.getCount()]);
    }

    private void initToolTipView() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.tooltipWidth, this.tooltipHeight);
        layoutParams.topMargin = -(layoutParams.height + this.dpToPx(8));
        this.tooltipView = new RelativeLayout(this.getContext());
        this.tooltipView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.tooltipView.setBackgroundResource(R.drawable.tooltip_indicator_rounded_line_selected);
        this.tooltipView.setPadding(this.dpToPx(4), this.dpToPx(4), this.dpToPx(4), this.dpToPx(4));
        this.tooltipViewImage = new AppCompatImageView(this.getContext());
        this.tooltipViewImage.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.tooltipView.setScaleX(0.0f);
        this.tooltipView.setScaleY(0.0f);
        this.tooltipView.setAlpha(0.0f);
        this.tooltipView.setTranslationY((float)(layoutParams.height / 2));
        this.tooltipView.addView((View)this.tooltipViewImage);
        this.addView((View)this.tooltipView);
    }

    private void initIndicatorLines() {
        this.linesLayout = new LinearLayout(this.getContext());
        this.linesLayout.setVerticalGravity(0);
        int linesCount = this.adapter.getCount();
        for (int i = 0; i < linesCount; ++i) {
            View lineView = new View(this.getContext());
            lineView.setBackgroundResource(this.unselectedLineDrawableResource);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.lineWidth, this.lineHeight);
            layoutParams.leftMargin = this.lineMargin;
            layoutParams.rightMargin = this.lineMargin;
            lineView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.linesLayout.addView(lineView);
        }
        this.addView((View)this.linesLayout);
    }

    public boolean onTouch(View v, MotionEvent event) {
        int x = (int)event.getX();
        if (this.drawableList == null || this.drawableList.length == 0) {
            return true;
        }
        int toolTipX = Math.max(0, x);
        toolTipX = Math.min(toolTipX, this.getMeasuredWidth());
        this.tooltipView.setX((float)(toolTipX - this.tooltipView.getMeasuredWidth() / 2));
        int totalWidthBefore = this.selectedPosition * this.lineWidthWithMargin;
        int pos = toolTipX >= totalWidthBefore + this.lineWidthSelectedWithMargin ? this.selectedPosition + 1 + (toolTipX - (totalWidthBefore + this.lineWidthSelectedWithMargin)) / this.lineWidthWithMargin : (toolTipX > totalWidthBefore ? this.selectedPosition : toolTipX / this.lineWidthWithMargin);
        pos = Math.min(pos, this.drawableList.length - 1);
        if (this.tooltipViewImage.getBackground() != this.drawableList[pos]) {
            this.tooltipViewImage.setBackgroundDrawable(this.drawableList[pos]);
        }
        switch (event.getAction()) {
            case 0: {
                this.tooltipView.animate().alpha(1.0f).scaleX(1.0f).scaleY(1.0f).translationY(1.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator()).start();
                break;
            }
            case 1: {
                this.tooltipView.animate().alpha(0.0f).scaleX(0.0f).scaleY(0.0f).translationY((float)(this.tooltipView.getMeasuredHeight() / 2)).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
            }
        }
        return true;
    }

    private void selectPage(int position) {
        if (this.selectedPosition != -1) {
            this.collapseView(this.linesLayout.getChildAt(this.selectedPosition));
        }
        this.selectedPosition = position;
        this.expandView(this.linesLayout.getChildAt(this.selectedPosition));
    }

    private void expandView(View selectedView) {
        selectedView.setBackgroundResource(this.selectedLineDrawableResource);
        if (this.expandAnimator != null) {
            this.expandAnimator.end();
        }
        this.expandAnimator = ValueAnimator.ofObject((TypeEvaluator)new IntEvaluator(), (Object[])new Object[]{this.lineWidth, this.lineWidthSelected});
        this.expandAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.expandAnimator.addUpdateListener(animation -> {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)selectedView.getLayoutParams();
            layoutParams.width = (Integer)animation.getAnimatedValue();
            selectedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        });
        this.expandAnimator.setDuration(200L);
        this.expandAnimator.start();
    }

    private void collapseView(View selectedView) {
        selectedView.setBackgroundResource(this.unselectedLineDrawableResource);
        if (this.collapseAnimator != null) {
            this.collapseAnimator.end();
        }
        this.collapseAnimator = ValueAnimator.ofObject((TypeEvaluator)new IntEvaluator(), (Object[])new Object[]{this.lineWidthSelected, this.lineWidth});
        this.collapseAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.collapseAnimator.addUpdateListener(animation -> {
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)selectedView.getLayoutParams();
            layoutParams.width = (Integer)animation.getAnimatedValue();
            selectedView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        });
        this.collapseAnimator.setDuration(500L);
        this.collapseAnimator.start();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.selectPage(position);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public int dpToPx(int dp) {
        Resources r = this.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }
}

