/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.ahmadullahpk.alldocumentreader.R;

public class ShimmerLayout
extends FrameLayout {
    private static final byte DEFAULT_ANGLE = 20;
    private static final int DEFAULT_ANIMATION_DURATION = 1500;
    private static final byte MAX_ANGLE_VALUE = 45;
    private static final byte MAX_GRADIENT_CENTER_COLOR_WIDTH_VALUE = 1;
    private static final byte MAX_MASK_WIDTH_VALUE = 1;
    private static final byte MIN_ANGLE_VALUE = -45;
    private static final byte MIN_GRADIENT_CENTER_COLOR_WIDTH_VALUE = 0;
    private static final byte MIN_MASK_WIDTH_VALUE = 0;
    private final boolean autoStart;
    private Canvas canvasForShimmerMask;
    private float gradientCenterColorWidth;
    private Paint gradientTexturePaint;
    private boolean isAnimationReversed;
    private boolean isAnimationStarted;
    private Bitmap localMaskBitmap;
    private ValueAnimator maskAnimator;
    private Bitmap maskBitmap;
    private int maskOffsetX;
    private Rect maskRect;
    private float maskWidth;
    private int shimmerAngle;
    private int shimmerAnimationDuration;
    private int shimmerColor;
    private ViewTreeObserver.OnPreDrawListener startAnimationPreDrawListener;

    public ShimmerLayout(Context context) {
        this(context, null);
    }

    public ShimmerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ShimmerLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.setWillNotDraw(false);
        TypedArray obtainStyledAttributes = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.ShimmerLayout, 0, 0);
        try {
            this.shimmerAngle = obtainStyledAttributes.getInteger(0, 20);
            this.shimmerAnimationDuration = obtainStyledAttributes.getInteger(1, 1500);
            this.shimmerColor = obtainStyledAttributes.getColor(3, this.getColor(R.color.shimmer_color));
            this.autoStart = obtainStyledAttributes.getBoolean(2, false);
            this.maskWidth = obtainStyledAttributes.getFloat(5, 0.4f);
            this.gradientCenterColorWidth = obtainStyledAttributes.getFloat(4, 0.01f);
            this.isAnimationReversed = obtainStyledAttributes.getBoolean(6, false);
            obtainStyledAttributes.recycle();
            this.setMaskWidth(this.maskWidth);
            this.setGradientCenterColorWidth(this.gradientCenterColorWidth);
            this.setShimmerAngle(this.shimmerAngle);
            this.enableForcedSoftwareLayerIfNeeded();
            if (this.autoStart && this.getVisibility() == 8) {
                this.startShimmerAnimation();
            }
        }
        catch (Throwable th) {
            obtainStyledAttributes.recycle();
            throw th;
        }
    }

    protected void onDetachedFromWindow() {
        this.resetShimmering();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (!this.isAnimationStarted || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.dispatchDrawShimmer(canvas);
        }
    }

    public void setVisibility(int i) {
        super.setVisibility(i);
        if (i != 0) {
            this.stopShimmerAnimation();
        } else if (this.autoStart) {
            this.startShimmerAnimation();
        }
    }

    public void startShimmerAnimation() {
        if (!this.isAnimationStarted) {
            if (this.getWidth() == 0) {
                this.startAnimationPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ShimmerLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        ShimmerLayout.this.startShimmerAnimation();
                        return true;
                    }
                };
                this.getViewTreeObserver().addOnPreDrawListener(this.startAnimationPreDrawListener);
                return;
            }
            this.getShimmerAnimation().start();
            this.isAnimationStarted = true;
        }
    }

    public void stopShimmerAnimation() {
        if (this.startAnimationPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener(this.startAnimationPreDrawListener);
        }
        this.resetShimmering();
    }

    public boolean isAnimationStarted() {
        return this.isAnimationStarted;
    }

    public void setShimmerColor(int i) {
        this.shimmerColor = i;
        this.resetIfStarted();
    }

    public void setShimmerAnimationDuration(int i) {
        this.shimmerAnimationDuration = i;
        this.resetIfStarted();
    }

    public void setAnimationReversed(boolean z) {
        this.isAnimationReversed = z;
        this.resetIfStarted();
    }

    public void setShimmerAngle(int i) {
        if (i < -45 || 45 < i) {
            throw new IllegalArgumentException(String.format("shimmerAngle value must be between %d and %d", (byte)-45, (byte)45));
        }
        this.shimmerAngle = i;
        this.resetIfStarted();
    }

    public void setMaskWidth(float f) {
        if (f <= 0.0f || 1.0f < f) {
            throw new IllegalArgumentException(String.format("maskWidth value must be higher than %d and less or equal to %d", (byte)0, (byte)1));
        }
        this.maskWidth = f;
        this.resetIfStarted();
    }

    public void setGradientCenterColorWidth(float f) {
        if (f <= 0.0f || 1.0f <= f) {
            throw new IllegalArgumentException(String.format("gradientCenterColorWidth value must be higher than %d and less than %d", (byte)0, (byte)1));
        }
        this.gradientCenterColorWidth = f;
        this.resetIfStarted();
    }

    private void resetIfStarted() {
        if (this.isAnimationStarted) {
            this.resetShimmering();
            this.startShimmerAnimation();
        }
    }

    private void dispatchDrawShimmer(Canvas canvas) {
        Bitmap maskBitmap2;
        super.dispatchDraw(canvas);
        this.localMaskBitmap = maskBitmap2 = this.getMaskBitmap();
        if (maskBitmap2 != null) {
            if (this.canvasForShimmerMask == null) {
                this.canvasForShimmerMask = new Canvas(this.localMaskBitmap);
            }
            this.canvasForShimmerMask.drawColor(0, PorterDuff.Mode.CLEAR);
            this.canvasForShimmerMask.save();
            this.canvasForShimmerMask.translate((float)(-this.maskOffsetX), 0.0f);
            super.dispatchDraw(this.canvasForShimmerMask);
            this.canvasForShimmerMask.restore();
            this.drawShimmer(canvas);
            this.localMaskBitmap = null;
        }
    }

    private void drawShimmer(Canvas canvas) {
        this.createShimmerPaint();
        canvas.save();
        canvas.translate((float)this.maskOffsetX, 0.0f);
        canvas.drawRect((float)this.maskRect.left, 0.0f, (float)this.maskRect.width(), (float)this.maskRect.height(), this.gradientTexturePaint);
        canvas.restore();
    }

    private void resetShimmering() {
        ValueAnimator valueAnimator = this.maskAnimator;
        if (valueAnimator != null) {
            valueAnimator.end();
            this.maskAnimator.removeAllUpdateListeners();
        }
        this.maskAnimator = null;
        this.gradientTexturePaint = null;
        this.isAnimationStarted = false;
        this.releaseBitMaps();
    }

    private void releaseBitMaps() {
        this.canvasForShimmerMask = null;
        Bitmap bitmap = this.maskBitmap;
        if (bitmap != null) {
            bitmap.recycle();
            this.maskBitmap = null;
        }
    }

    private Bitmap getMaskBitmap() {
        if (this.maskBitmap == null) {
            this.maskBitmap = this.createBitmap(this.maskRect.width(), this.getHeight());
        }
        return this.maskBitmap;
    }

    private void createShimmerPaint() {
        if (this.gradientTexturePaint == null) {
            Paint paint;
            int reduceColorAlphaValueToZero = this.reduceColorAlphaValueToZero(this.shimmerColor);
            float width = (float)(this.getWidth() / 2) * this.maskWidth;
            float height = this.shimmerAngle >= 0 ? (float)this.getHeight() : 0.0f;
            int i = this.shimmerColor;
            ComposeShader composeShader = new ComposeShader((Shader)new LinearGradient(0.0f, height, (float)Math.cos(Math.toRadians(this.shimmerAngle)) * width, height + (float)Math.sin(Math.toRadians(this.shimmerAngle)) * width, new int[]{reduceColorAlphaValueToZero, i, i, reduceColorAlphaValueToZero}, this.getGradientColorDistribution(), Shader.TileMode.CLAMP), (Shader)new BitmapShader(this.localMaskBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP), PorterDuff.Mode.DST_IN);
            this.gradientTexturePaint = paint = new Paint();
            paint.setAntiAlias(true);
            this.gradientTexturePaint.setDither(true);
            this.gradientTexturePaint.setFilterBitmap(true);
            this.gradientTexturePaint.setShader((Shader)composeShader);
        }
    }

    private Animator getShimmerAnimation() {
        ValueAnimator valueAnimator2 = this.maskAnimator;
        if (valueAnimator2 != null) {
            return valueAnimator2;
        }
        if (this.maskRect == null) {
            this.maskRect = this.calculateBitmapMaskRect();
        }
        int width = this.getWidth();
        int i = this.getWidth() > this.maskRect.width() ? -width : -this.maskRect.width();
        int width2 = this.maskRect.width();
        int i2 = width - i;
        ValueAnimator valueAnimator = this.isAnimationReversed ? ValueAnimator.ofInt((int[])new int[]{i2, 0}) : ValueAnimator.ofInt((int[])new int[]{0, i2});
        this.maskAnimator = valueAnimator;
        valueAnimator.setDuration((long)this.shimmerAnimationDuration);
        this.maskAnimator.setRepeatCount(-1);
        this.maskAnimator.addUpdateListener(valueAnimator1 -> {
            this.maskOffsetX = i + (Integer)valueAnimator1.getAnimatedValue();
            if (this.maskOffsetX + width2 >= 0) {
                this.invalidate();
            }
        });
        return this.maskAnimator;
    }

    private Bitmap createBitmap(int i, int i2) {
        try {
            return Bitmap.createBitmap((int)i, (int)i2, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        }
        catch (OutOfMemoryError unused) {
            System.gc();
            return null;
        }
    }

    private int getColor(int i) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getColor(i);
        }
        return this.getResources().getColor(i);
    }

    private int reduceColorAlphaValueToZero(int i) {
        return Color.argb((int)0, (int)Color.red((int)i), (int)Color.green((int)i), (int)Color.blue((int)i));
    }

    private Rect calculateBitmapMaskRect() {
        return new Rect(0, 0, this.calculateMaskWidth(), this.getHeight());
    }

    private int calculateMaskWidth() {
        double width = (float)(this.getWidth() / 2) * this.maskWidth;
        double cos = Math.cos(Math.toRadians(Math.abs(this.shimmerAngle)));
        Double.isNaN(width);
        double d = width / cos;
        double height = this.getHeight();
        double tan = Math.tan(Math.toRadians(Math.abs(this.shimmerAngle)));
        Double.isNaN(height);
        return (int)(d + height * tan);
    }

    private float[] getGradientColorDistribution() {
        float[] fArr = new float[4];
        fArr[0] = 0.0f;
        fArr[3] = 1.0f;
        float f = this.gradientCenterColorWidth;
        fArr[1] = 0.5f - f / 2.0f;
        fArr[2] = f / 2.0f + 0.5f;
        return fArr;
    }

    private void enableForcedSoftwareLayerIfNeeded() {
    }
}

