/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.util;

import com.ahmadullahpk.alldocumentreader.util.RtfElement;
import com.ahmadullahpk.alldocumentreader.util.RtfElementGroup;
import com.ahmadullahpk.alldocumentreader.util.RtfElementSymbol;
import com.ahmadullahpk.alldocumentreader.util.RtfState;
import com.ahmadullahpk.alldocumentreader.util.RtfText;
import com.ahmadullahpk.alldocumentreader.util.RtfWordControl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class RtfHtmlDataType {
    private String output;
    private Stack<RtfState> states;
    private RtfState state;
    private RtfState previousState;
    private Map<String, Boolean> openedTags;
    private List<String> fonttbl;
    private List<String> colortbl;
    private boolean newRootPar;

    public String format(RtfElementGroup root) {
        return this.format(root, false);
    }

    public String format(RtfElementGroup root, boolean page) {
        this.previousState = null;
        this.openedTags = new LinkedHashMap<String, Boolean>();
        this.openedTags.put("span", false);
        this.openedTags.put("p", true);
        this.states = new Stack();
        this.state = new RtfState();
        this.states.push(this.state);
        this.output = "<p>";
        this.newRootPar = true;
        this.formatGroup(root);
        if (page) {
            this.wrapTags();
        }
        return this.output;
    }

    protected void extractFontTable(List<RtfElement> fontTblGrp) {
        ArrayList<String> fonttbl = new ArrayList<String>();
        int c = fontTblGrp.size();
        for (int i = 1; i < c; ++i) {
            if (!(fontTblGrp.get(i) instanceof RtfElementGroup)) continue;
            RtfElementGroup fontDesc = (RtfElementGroup)fontTblGrp.get(i);
            String fontFamily = "";
            List<RtfElement> fontAttrs = fontDesc.children;
            for (int fa = 1; fa < fontAttrs.size(); ++fa) {
                RtfElement faElem = fontAttrs.get(fa);
                if (faElem instanceof RtfWordControl) {
                    RtfWordControl fontAttr = (RtfWordControl)faElem;
                    if (!fontAttr.word.equals("fnil")) {
                        if (fontAttr.word.equals("froman")) {
                            fontFamily = "Times,serif";
                        } else if (fontAttr.word.equals("fswiss")) {
                            fontFamily = "Helvetica,Swiss,sans-serif";
                        } else if (fontAttr.word.equals("fmodern")) {
                            fontFamily = "Courier,monospace";
                        } else if (fontAttr.word.equals("fscript")) {
                            fontFamily = "Cursive";
                        } else if (fontAttr.word.equals("fdecor")) {
                            fontFamily = "'ITC Zapf Chancery'";
                        } else if (fontAttr.word.equals("ftech")) {
                            fontFamily = "Symbol,Wingdings";
                        } else if (fontAttr.word.equals("fbidi")) {
                            fontFamily = "Miriam";
                        } else if (fontAttr.word.equals("fcharset") && fontAttr.parameter == 2) {
                            fontFamily = "Symbol";
                        }
                    }
                }
                if (!(faElem instanceof RtfText)) continue;
                RtfText fontName = (RtfText)faElem;
                String fontNameText = fontName.text;
                if (";".equals(fontNameText)) continue;
                if (fontNameText.endsWith(";")) {
                    fontNameText = fontNameText.substring(0, fontNameText.length() - 1);
                }
                if (fontFamily.contains(fontNameText)) continue;
                if (fontFamily.length() > 0) {
                    fontFamily = "," + fontFamily;
                }
                fontFamily = "'" + fontNameText + "'" + fontFamily;
            }
            fonttbl.add(fontFamily);
        }
        this.fonttbl = fonttbl;
    }

    protected void extractColorTable(List<RtfElement> colorTblGrp) {
        ArrayList<String> colortbl = new ArrayList<String>();
        colortbl.add(null);
        int c = colorTblGrp.size();
        String color2 = "";
        for (int i = 2; i < c; ++i) {
            if (colorTblGrp.get(i) instanceof RtfWordControl) {
                int red = ((RtfWordControl)colorTblGrp.get((int)i)).parameter;
                int green = ((RtfWordControl)colorTblGrp.get((int)(i + 1))).parameter;
                int blue = ((RtfWordControl)colorTblGrp.get((int)(i + 2))).parameter;
                color2 = String.format("#%02x%02x%02x", red, green, blue);
                i += 2;
                continue;
            }
            if (!(colorTblGrp.get(i) instanceof RtfText)) continue;
            colortbl.add(color2);
        }
        this.colortbl = colortbl;
    }

    protected void formatGroup(RtfElementGroup group) {
        if (group.getType().equals("fonttbl")) {
            this.extractFontTable(group.children);
            return;
        }
        if (group.getType().equals("colortbl")) {
            this.extractColorTable(group.children);
            return;
        }
        if (group.getType().equals("stylesheet")) {
            return;
        }
        if (group.getType().equals("info")) {
            return;
        }
        if (group.getType().length() >= 4 && group.getType().substring(0, 4).equals("pict")) {
            return;
        }
        if (group.isDestination()) {
            return;
        }
        this.state = (RtfState)this.state.clone();
        this.states.push(this.state);
        for (RtfElement child : group.children) {
            if (child instanceof RtfElementGroup) {
                this.formatGroup((RtfElementGroup)child);
                continue;
            }
            if (child instanceof RtfWordControl) {
                this.formatControlWord((RtfWordControl)child);
                continue;
            }
            if (child instanceof RtfElementSymbol) {
                this.formatControlSymbol((RtfElementSymbol)child);
                continue;
            }
            if (!(child instanceof RtfText)) continue;
            this.formatText((RtfText)child);
        }
        this.states.pop();
        this.state = this.states.peek();
    }

    protected void formatControlWord(RtfWordControl rtfWord) {
        if (rtfWord.word.equals("plain") || rtfWord.word.equals("pard")) {
            this.state.reset();
        } else if (rtfWord.word.equals("f")) {
            this.state.font = rtfWord.parameter;
        } else if (rtfWord.word.equals("b")) {
            this.state.bold = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("i")) {
            this.state.italic = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("ul")) {
            this.state.underline = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("ulnone")) {
            this.state.underline = false;
        } else if (rtfWord.word.equals("strike")) {
            this.state.strike = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("v")) {
            this.state.hidden = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("fs")) {
            this.state.fontSize = (int)Math.ceil((double)rtfWord.parameter / 24.0 * 16.0);
        } else if (rtfWord.word.equals("dn")) {
            this.state.dnup = (int)Math.ceil((double)rtfWord.parameter / 24.0 * 16.0) * -1;
        } else if (rtfWord.word.equals("up")) {
            this.state.dnup = (int)Math.ceil((double)rtfWord.parameter / 24.0 * 16.0);
        } else if (rtfWord.word.equals("sub")) {
            this.state.subscript = true;
            this.state.superscript = false;
        } else if (rtfWord.word.equals("super")) {
            this.state.subscript = false;
            this.state.superscript = true;
        } else if (rtfWord.word.equals("nosupersub")) {
            this.state.subscript = false;
            this.state.superscript = false;
        } else if (rtfWord.word.equals("cf")) {
            this.state.textColor = rtfWord.parameter;
        } else if (rtfWord.word.equals("cb") || rtfWord.word.equals("chcbpat") || rtfWord.word.equals("highlight")) {
            this.state.background = rtfWord.parameter;
        } else if (rtfWord.word.equals("lquote")) {
            this.applyStyle("&lsquo;");
        } else if (rtfWord.word.equals("rquote")) {
            this.applyStyle("&rsquo;");
        } else if (rtfWord.word.equals("ldblquote")) {
            this.applyStyle("&ldquo;");
        } else if (rtfWord.word.equals("rdblquote")) {
            this.applyStyle("&rdquo;");
        } else if (rtfWord.word.equals("emdash")) {
            this.applyStyle("&mdash;");
        } else if (rtfWord.word.equals("endash")) {
            this.applyStyle("&ndash;");
        } else if (rtfWord.word.equals("emspace")) {
            this.applyStyle("&emsp;");
        } else if (rtfWord.word.equals("enspace")) {
            this.applyStyle("&ensp;");
        } else if (rtfWord.word.equals("tab")) {
            this.applyStyle("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        } else if (rtfWord.word.equals("line")) {
            this.applyStyle("<br>");
        } else if (rtfWord.word.equals("bullet")) {
            this.applyStyle("&bull;");
        } else if (rtfWord.word.equals("u")) {
            this.applyStyle("&#" + rtfWord.parameter + ";");
        } else if (rtfWord.word.equals("par") || rtfWord.word.equals("row")) {
            this.closeTags();
            this.output = this.output + "<p>";
            this.openedTags.put("p", true);
            this.newRootPar = true;
        }
    }

    protected void applyStyle(String txt) {
        if (!this.state.equals(this.previousState) || this.newRootPar) {
            String span = "";
            if (this.state.font >= 0) {
                span = span + "font-family:" + this.printFontFamily(this.state.font) + ";";
            }
            if (this.state.bold) {
                span = span + "font-weight:bold;";
            }
            if (this.state.italic) {
                span = span + "font-style:italic;";
            }
            if (this.state.underline) {
                span = span + "text-decoration:underline;";
            }
            if (this.state.strike) {
                span = span + "text-decoration:strikethrough;";
            }
            if (this.state.hidden) {
                span = span + "display:none;";
            }
            if (this.state.fontSize != 0) {
                span = span + "font-size:" + this.state.fontSize + "px;";
            }
            if (this.state.dnup != 0) {
                span = span + this.calculateReducedFontSize() + "vertical-align:" + this.state.dnup + "px;";
            }
            if (this.state.subscript) {
                span = span + this.calculateReducedFontSize() + "vertical-align:sub;";
            }
            if (this.state.superscript) {
                span = span + this.calculateReducedFontSize() + "vertical-align:super;";
            }
            if (this.state.textColor != 0) {
                span = span + "color:" + this.printColor(this.state.textColor) + ";";
            }
            if (this.state.background != 0) {
                span = span + "background-color:" + this.printColor(this.state.background) + ";";
            }
            this.previousState = (RtfState)this.state.clone();
            this.closeTag("span");
            this.output = this.output + "<span style=\"" + span + "\">" + txt;
            this.openedTags.put("span", true);
        } else {
            this.output = this.output + txt;
        }
        this.newRootPar = false;
    }

    protected String calculateReducedFontSize() {
        String css;
        if (this.state.fontSize != 0) {
            int reducedFontSize = (int)Math.ceil((double)this.state.fontSize / 3.0 * 2.0);
            css = "font-size:" + reducedFontSize + "px;";
        } else {
            css = "font-size:smaller;";
        }
        return css;
    }

    protected String printFontFamily(int index) {
        if (index >= 0 && index < this.fonttbl.size()) {
            return this.fonttbl.get(index);
        }
        return "";
    }

    protected String printColor(int index) {
        if (index >= 1 && index < this.colortbl.size()) {
            return this.colortbl.get(index);
        }
        return "";
    }

    protected void closeTag(String tag) {
        if (this.openedTags.get(tag).booleanValue()) {
            this.output = this.output + "</" + tag + ">";
            this.openedTags.put(tag, false);
        }
    }

    protected void closeTags() {
        for (String tag : this.openedTags.keySet()) {
            this.closeTag(tag);
        }
    }

    protected void wrapTags() {
        StringBuilder source = new StringBuilder();
        source.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        source.append("<html>\n");
        source.append("  <head>\n");
        source.append("    <meta content=\"text/html;charset=UTF-8\" http-equiv=\"content-type\"/>\n");
        source.append("  </head>\n");
        source.append("  <body>\n");
        source.append(this.output + "\n");
        source.append("  </body>\n");
        source.append("</html>\n");
        this.output = source.toString();
    }

    protected void formatControlSymbol(RtfElementSymbol rtfSymbol) {
        if (rtfSymbol.symbol == '\'') {
            this.applyStyle("&#" + rtfSymbol.parameter + ";");
        }
        if (rtfSymbol.symbol == '~') {
            this.output = this.output + "&nbsp;";
        }
    }

    protected void formatText(RtfText rtfText) {
        this.applyStyle(rtfText.text);
    }
}

