/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.manageui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.R;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 Q2\u00020\u0001:\u0002QRB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010-\u001a\u00020\bJ\u0006\u0010.\u001a\u00020\bJ\u0006\u0010/\u001a\u00020\bJ\u0006\u00100\u001a\u00020\bJ\u0006\u00101\u001a\u00020\u000fJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u000208H\u0014J\u0018\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\bH\u0014J\u0010\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020>H\u0016J\n\u0010?\u001a\u0004\u0018\u00010>H\u0016J(\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0014J\u000e\u0010E\u001a\u0002032\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010F\u001a\u0002032\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010G\u001a\u0002032\u0006\u0010!\u001a\u00020\u000fJ\u0018\u0010H\u001a\u0002032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010I\u001a\u00020\bH\u0002J\u000e\u0010J\u001a\u0002032\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010K\u001a\u0002032\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010L\u001a\u0002032\u0006\u0010!\u001a\u00020\u000fJ\b\u0010M\u001a\u000203H\u0002J\u0006\u0010N\u001a\u000203J\u0010\u0010O\u001a\u0002032\u0006\u0010P\u001a\u00020\u001bH\u0002R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/ahmadullahpk/alldocumentreader/manageui/CustomWheelProgress;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "i", "", "barColor", "getBarColor", "()I", "setBarColor", "(I)V", "barExtraLength", "", "barGrowingFromFront", "", "barPaint", "Landroid/graphics/Paint;", "barSpinCycleTime", "", "barWidth", "circleBounds", "Landroid/graphics/RectF;", "circleRadius", "current", "", "f12959v", "fillRadius", "isSpinning", "pBarColor", "pausedTimeWithoutGrowing", "f", "progress", "getProgress", "()F", "setProgress", "(F)V", "rimColor", "rimPaint", "rimWidth", "spinSpeed", "startAngle", "timeStartGrowing", "getBarWidth", "getCircleRadius", "getRimColor", "getRimWidth", "getSpinSpeed", "initAppProgressWheel", "", "typedArray", "Landroid/content/res/TypedArray;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "parcelable", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "setBarWidth", "setCircleRadius", "setInstantProgress", "setPadding", "i2", "setRimColor", "setRimWidth", "setSpinSpeed", "setUpPaints", "upDateProgress", "updateBarLength", "deltaTimeInMilliSeconds", "Companion", "WheelSavedState", "documents-reader-lib_release"})
public final class CustomWheelProgress
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int circleRadius;
    private boolean fillRadius;
    private double timeStartGrowing;
    private double barSpinCycleTime;
    private float barExtraLength;
    private boolean barGrowingFromFront;
    private long pausedTimeWithoutGrowing;
    private int barWidth;
    private int rimWidth;
    private int pBarColor;
    private int rimColor;
    @NotNull
    private final Paint barPaint;
    @NotNull
    private final Paint rimPaint;
    @NotNull
    private RectF circleBounds;
    private float spinSpeed;
    private long current;
    private float startAngle;
    private float f12959v;
    private boolean isSpinning;
    private static final String TAG = CustomWheelProgress.class.getSimpleName();

    public CustomWheelProgress(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet);
        this.circleRadius = 80;
        this.timeStartGrowing = Double.longBitsToDouble(1L);
        this.barSpinCycleTime = 1000.0;
        this.barExtraLength = Float.intBitsToFloat(1);
        this.barGrowingFromFront = true;
        this.barWidth = 5;
        this.rimWidth = 5;
        this.pBarColor = -1442840576;
        this.rimColor = 0xFFFFFF;
        this.barPaint = new Paint();
        this.rimPaint = new Paint();
        this.circleBounds = new RectF();
        this.spinSpeed = 270.0f;
        this.startAngle = 270.0f;
        this.f12959v = Float.intBitsToFloat(1);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ProgressWheel);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026ogressWheel\n            )");
        this.initAppProgressWheel(typedArray);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int paddingLeft = this.circleRadius + this.getPaddingLeft() + this.getPaddingRight();
        int paddingTop = this.circleRadius + this.getPaddingTop() + this.getPaddingBottom();
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int size = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int mode2 = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int size2 = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (mode) {
            case 0x40000000: {
                paddingLeft = size;
                break;
            }
            case -2147483648: {
                paddingLeft = Math.min(paddingLeft, size);
            }
        }
        if (mode2 == 0x40000000 || mode == 0x40000000) {
            paddingTop = size2;
        } else if (mode2 == Integer.MIN_VALUE) {
            paddingTop = Math.min(paddingTop, size2);
        }
        this.setMeasuredDimension(paddingLeft, paddingTop);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setPadding(w, h);
        this.setUpPaints();
        this.invalidate();
    }

    private final void setUpPaints() {
        this.barPaint.setColor(this.pBarColor);
        this.barPaint.setAntiAlias(true);
        this.barPaint.setStyle(Paint.Style.STROKE);
        this.barPaint.setStrokeWidth((float)this.barWidth);
        this.rimPaint.setColor(this.rimColor);
        this.rimPaint.setAntiAlias(true);
        this.rimPaint.setStyle(Paint.Style.STROKE);
        this.rimPaint.setStrokeWidth((float)this.rimWidth);
    }

    private final void setPadding(int i, int i2) {
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        if (!this.fillRadius) {
            int i3 = i - paddingLeft - paddingRight;
            int min = Math.min(Math.min(i3, i2 - paddingBottom - paddingTop), this.circleRadius * 2 - this.barWidth * 2);
            int i4 = (i3 - min) / 2 + paddingLeft;
            int i5 = (i2 - paddingTop - paddingBottom - min) / 2 + paddingTop;
            int i6 = this.barWidth;
            this.circleBounds = new RectF((float)(i4 + i6), (float)(i5 + i6), (float)(i4 + min - i6), (float)(i5 + min - i6));
            return;
        }
        int i7 = this.barWidth;
        this.circleBounds = new RectF((float)(paddingLeft + i7), (float)(paddingTop + i7), (float)(i - paddingRight - i7), (float)(i2 - paddingBottom - i7));
    }

    private final void initAppProgressWheel(TypedArray typedArray) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        this.barWidth = (int)TypedValue.applyDimension((int)1, (float)this.barWidth, (DisplayMetrics)displayMetrics);
        this.rimWidth = (int)TypedValue.applyDimension((int)1, (float)this.rimWidth, (DisplayMetrics)displayMetrics);
        this.circleRadius = (int)typedArray.getDimension(R.styleable.ProgressWheel_circleRadius, (float)this.circleRadius);
        this.fillRadius = typedArray.getBoolean(R.styleable.ProgressWheel_fillRadius, false);
        this.barWidth = (int)typedArray.getDimension(R.styleable.ProgressWheel_barWidth, (float)this.barWidth);
        this.rimWidth = (int)typedArray.getDimension(R.styleable.ProgressWheel_rimWidth, (float)this.rimWidth);
        this.spinSpeed = typedArray.getFloat(R.styleable.ProgressWheel_spinSpeed, this.spinSpeed / 360.0f) * 360.0f;
        this.barSpinCycleTime = typedArray.getInt(R.styleable.ProgressWheel_barSpinCycleTime, (int)this.barSpinCycleTime);
        this.pBarColor = typedArray.getColor(R.styleable.ProgressWheel_pBarColor, this.pBarColor);
        this.rimColor = typedArray.getColor(R.styleable.ProgressWheel_rimColor, this.rimColor);
        if (typedArray.getBoolean(R.styleable.ProgressWheel_progressIndeterminate, false)) {
            this.upDateProgress();
        }
        typedArray.recycle();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawArc(this.circleBounds, 360.0f, 360.0f, false, this.rimPaint);
        boolean z = true;
        if (this.isSpinning) {
            long uptimeMillis = SystemClock.uptimeMillis() - this.current;
            float f = (float)uptimeMillis * this.spinSpeed / 1000.0f;
            this.updateBarLength(uptimeMillis);
            this.startAngle += f;
            float f2 = this.startAngle;
            if (f2 > 360.0f) {
                this.startAngle = f2 - 360.0f;
            }
            this.current = SystemClock.uptimeMillis();
            canvas.drawArc(this.circleBounds, this.startAngle - 90.0f, this.barExtraLength + 40.0f, false, this.barPaint);
        } else {
            if (!(this.startAngle == this.f12959v)) {
                this.startAngle = Math.min(this.startAngle + (float)(SystemClock.uptimeMillis() - this.current) / 1000.0f * this.spinSpeed, this.f12959v);
                this.current = SystemClock.uptimeMillis();
            } else {
                z = false;
            }
            canvas.drawArc(this.circleBounds, -90.0f, this.startAngle, false, this.barPaint);
        }
        if (z) {
            this.invalidate();
        }
    }

    private final void updateBarLength(long deltaTimeInMilliSeconds) {
        long j2 = this.pausedTimeWithoutGrowing;
        if (j2 >= 300L) {
            this.timeStartGrowing += (double)deltaTimeInMilliSeconds;
            if (this.timeStartGrowing > this.barSpinCycleTime) {
                this.timeStartGrowing = Double.longBitsToDouble(1L);
                if (!this.barGrowingFromFront) {
                    this.pausedTimeWithoutGrowing = 0L;
                }
                this.barGrowingFromFront = !this.barGrowingFromFront;
            }
            float cos = (float)Math.cos((this.timeStartGrowing / this.barSpinCycleTime + 1.0) * Math.PI) / 2.0f + 0.5f;
            if (this.barGrowingFromFront) {
                this.barExtraLength = cos * 230.0f;
                return;
            }
            float f = (1.0f - cos) * 230.0f;
            this.startAngle += this.barExtraLength - f;
            this.barExtraLength = f;
            return;
        }
        this.pausedTimeWithoutGrowing = j2 + deltaTimeInMilliSeconds;
    }

    public final void upDateProgress() {
        this.current = SystemClock.uptimeMillis();
        this.isSpinning = true;
        this.invalidate();
    }

    public final void setInstantProgress(float f) {
        float f2 = f;
        if (this.isSpinning) {
            this.startAngle = Float.intBitsToFloat(1);
            this.isSpinning = false;
        }
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        } else if (f2 < Float.intBitsToFloat(1)) {
            f2 = Float.intBitsToFloat(1);
        }
        if ((double)Math.abs(f2 - this.f12959v) >= 1.0E-4) {
            this.startAngle = this.f12959v = Math.min(f2 * 360.0f, 360.0f);
            this.current = SystemClock.uptimeMillis();
            this.invalidate();
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        WheelSavedState wheelSavedState = new WheelSavedState(super.onSaveInstanceState());
        wheelSavedState.setMProgress(this.startAngle);
        wheelSavedState.setMTargetProgress(this.f12959v);
        wheelSavedState.setSpinning(this.isSpinning);
        wheelSavedState.setSpinSpeed(this.spinSpeed);
        wheelSavedState.setBarWidth(this.barWidth);
        wheelSavedState.setBarColor(this.pBarColor);
        wheelSavedState.setRimWidth(this.rimWidth);
        wheelSavedState.setRimColor(this.rimColor);
        wheelSavedState.setCircleRadius(this.circleRadius);
        return (Parcelable)wheelSavedState;
    }

    public void onRestoreInstanceState(@NotNull Parcelable parcelable) {
        Intrinsics.checkNotNullParameter((Object)parcelable, (String)"parcelable");
        if (!(parcelable instanceof WheelSavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        super.onRestoreInstanceState(((WheelSavedState)parcelable).getSuperState());
        this.startAngle = ((WheelSavedState)parcelable).getMProgress();
        this.f12959v = ((WheelSavedState)parcelable).getMTargetProgress();
        this.isSpinning = ((WheelSavedState)parcelable).isSpinning();
        this.spinSpeed = ((WheelSavedState)parcelable).getSpinSpeed();
        this.barWidth = ((WheelSavedState)parcelable).getBarWidth();
        this.pBarColor = ((WheelSavedState)parcelable).getBarColor();
        this.rimWidth = ((WheelSavedState)parcelable).getRimWidth();
        this.rimColor = ((WheelSavedState)parcelable).getRimColor();
        this.circleRadius = ((WheelSavedState)parcelable).getCircleRadius();
    }

    public final float getProgress() {
        return this.isSpinning ? -1.0f : this.startAngle / 360.0f;
    }

    public final void setProgress(float f) {
        float f2 = f;
        if (this.isSpinning) {
            this.startAngle = Float.intBitsToFloat(1);
            this.isSpinning = false;
        }
        if (f2 > 1.0f) {
            f2 -= 1.0f;
        } else if (f2 < Float.intBitsToFloat(1)) {
            f2 = Float.intBitsToFloat(1);
        }
        if (Math.abs(f2 - this.f12959v) >= 1.0E-4f) {
            if (Math.abs(this.startAngle - this.f12959v) < 1.0E-4f) {
                this.current = SystemClock.uptimeMillis();
            }
            this.f12959v = Math.min(f2 * 360.0f, 360.0f);
            this.invalidate();
        }
    }

    public final int getCircleRadius() {
        return this.circleRadius;
    }

    public final void setCircleRadius(int i) {
        this.circleRadius = i;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public final int getBarWidth() {
        return this.barWidth;
    }

    public final void setBarWidth(int i) {
        this.barWidth = i;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public final int getBarColor() {
        return this.pBarColor;
    }

    public final void setBarColor(int i) {
        this.pBarColor = i;
        this.setUpPaints();
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public final int getRimColor() {
        return this.rimColor;
    }

    public final void setRimColor(int i) {
        this.rimColor = i;
        this.setUpPaints();
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    public final float getSpinSpeed() {
        return this.spinSpeed / 360.0f;
    }

    public final void setSpinSpeed(float f) {
        this.spinSpeed = f * 360.0f;
    }

    public final int getRimWidth() {
        return this.rimWidth;
    }

    public final void setRimWidth(int i) {
        this.rimWidth = i;
        if (!this.isSpinning) {
            this.invalidate();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ahmadullahpk/alldocumentreader/manageui/CustomWheelProgress$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "documents-reader-lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\tH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010\rR\u001a\u0010%\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\rR\u001a\u0010(\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001e\u00a8\u0006/"}, d2={"Lcom/ahmadullahpk/alldocumentreader/manageui/CustomWheelProgress$WheelSavedState;", "Landroid/view/View$BaseSavedState;", "parcelable", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "barColor", "", "getBarColor", "()I", "setBarColor", "(I)V", "barWidth", "getBarWidth", "setBarWidth", "circleRadius", "getCircleRadius", "setCircleRadius", "isSpinning", "", "()Z", "setSpinning", "(Z)V", "mProgress", "", "getMProgress", "()F", "setMProgress", "(F)V", "mTargetProgress", "getMTargetProgress", "setMTargetProgress", "rimColor", "getRimColor", "setRimColor", "rimWidth", "getRimWidth", "setRimWidth", "spinSpeed", "getSpinSpeed", "setSpinSpeed", "writeToParcel", "", "i", "Companion", "documents-reader-lib_release"})
    public static final class WheelSavedState
    extends View.BaseSavedState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private float mProgress;
        private float mTargetProgress;
        private boolean isSpinning;
        private float spinSpeed;
        private int barWidth;
        private int barColor;
        private int rimWidth;
        private int rimColor;
        private int circleRadius;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<WheelSavedState> CREATOR = (Parcelable.Creator)new Parcelable.Creator<WheelSavedState>(){

            @Nullable
            public WheelSavedState createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new WheelSavedState(parcel, null);
            }

            @NotNull
            public WheelSavedState[] newArray(int i) {
                return new WheelSavedState[i];
            }
        };

        public final float getMProgress() {
            return this.mProgress;
        }

        public final void setMProgress(float f) {
            this.mProgress = f;
        }

        public final float getMTargetProgress() {
            return this.mTargetProgress;
        }

        public final void setMTargetProgress(float f) {
            this.mTargetProgress = f;
        }

        public final boolean isSpinning() {
            return this.isSpinning;
        }

        public final void setSpinning(boolean bl) {
            this.isSpinning = bl;
        }

        public final float getSpinSpeed() {
            return this.spinSpeed;
        }

        public final void setSpinSpeed(float f) {
            this.spinSpeed = f;
        }

        public final int getBarWidth() {
            return this.barWidth;
        }

        public final void setBarWidth(int n) {
            this.barWidth = n;
        }

        public final int getBarColor() {
            return this.barColor;
        }

        public final void setBarColor(int n) {
            this.barColor = n;
        }

        public final int getRimWidth() {
            return this.rimWidth;
        }

        public final void setRimWidth(int n) {
            this.rimWidth = n;
        }

        public final int getRimColor() {
            return this.rimColor;
        }

        public final void setRimColor(int n) {
            this.rimColor = n;
        }

        public final int getCircleRadius() {
            return this.circleRadius;
        }

        public final void setCircleRadius(int n) {
            this.circleRadius = n;
        }

        public WheelSavedState(@Nullable Parcelable parcelable) {
            super(parcelable);
        }

        private WheelSavedState(Parcel parcel) {
            super(parcel);
            this.mProgress = parcel.readFloat();
            this.mTargetProgress = parcel.readFloat();
            this.isSpinning = parcel.readByte() != 0;
            this.spinSpeed = parcel.readFloat();
            this.barWidth = parcel.readInt();
            this.barColor = parcel.readInt();
            this.rimWidth = parcel.readInt();
            this.rimColor = parcel.readInt();
            this.circleRadius = parcel.readInt();
        }

        public void writeToParcel(@NotNull Parcel parcel, int i) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            super.writeToParcel(parcel, i);
            parcel.writeFloat(this.mProgress);
            parcel.writeFloat(this.mTargetProgress);
            parcel.writeByte(this.isSpinning ? (byte)1 : 0);
            parcel.writeFloat(this.spinSpeed);
            parcel.writeInt(this.barWidth);
            parcel.writeInt(this.barColor);
            parcel.writeInt(this.rimWidth);
            parcel.writeInt(this.rimColor);
            parcel.writeInt(this.circleRadius);
        }

        public /* synthetic */ WheelSavedState(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
            this(parcel);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ahmadullahpk/alldocumentreader/manageui/CustomWheelProgress$WheelSavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/ahmadullahpk/alldocumentreader/manageui/CustomWheelProgress$WheelSavedState;", "documents-reader-lib_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

