/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.dialog;

import android.view.MenuItem;
import android.widget.PopupMenu;
import com.ahmadullahpk.alldocumentreader.adapters_All.viewholder.ColumnViewHolder;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.TableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.sort.SortState;

public class DialogColumnLongPress
extends PopupMenu
implements PopupMenu.OnMenuItemClickListener {
    private static final int ASCENDING = 1;
    private static final int DESCENDING = 2;
    private static final int HIDE_ROW = 3;
    private static final int SCROLL_ROW = 5;
    private static final int SHOW_ROW = 4;
    private final TableView mTableView;
    private final int mXPosition;

    public DialogColumnLongPress(ColumnViewHolder columnViewHolder, TableView tableView) {
        super(columnViewHolder.itemView.getContext(), columnViewHolder.itemView);
        this.mTableView = tableView;
        this.mXPosition = columnViewHolder.getAdapterPosition();
        this.initialize();
    }

    private void initialize() {
        this.createMenuItem();
        this.changeMenuItemVisibility();
        this.setOnMenuItemClickListener(this);
    }

    private void createMenuItem() {
        this.mTableView.getContext();
    }

    private void changeMenuItemVisibility() {
        SortState sortingStatus = this.mTableView.getSortingStatus(this.mXPosition);
        if (sortingStatus != SortState.UNSORTED) {
            if (sortingStatus == SortState.DESCENDING) {
                this.getMenu().getItem(1).setVisible(false);
            } else if (sortingStatus == SortState.ASCENDING) {
                this.getMenu().getItem(0).setVisible(false);
            }
        }
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        int itemId = menuItem.getItemId();
        if (itemId == 1) {
            this.mTableView.sortColumn(this.mXPosition, SortState.ASCENDING);
        } else if (itemId == 2) {
            this.mTableView.sortColumn(this.mXPosition, SortState.DESCENDING);
        } else if (itemId == 3) {
            this.mTableView.hideRow(5);
        } else if (itemId == 4) {
            this.mTableView.showRow(5);
        } else if (itemId == 5) {
            this.mTableView.scrollToRowPosition(5);
        }
        return true;
    }
}

