/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.adapters_All.viewholder;

import android.util.Log;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.dataType.ColumnHeader;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.ITableView;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.ahmadullahpk.alldocumentreader.widgets.tableview.sort.SortState;

public class ColumnViewHolder
extends AbstractSorterViewHolder {
    private static final String LOG_TAG = ColumnViewHolder.class.getSimpleName();
    @NonNull
    private final LinearLayout column_header_container;
    @NonNull
    private final TextView column_header_textview;
    @NonNull
    private final ImageButton column_header_sortButton;
    @Nullable
    private final ITableView tableView;
    @NonNull
    private final View.OnClickListener mSortButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (ColumnViewHolder.this.getSortState() == SortState.ASCENDING) {
                ColumnViewHolder.this.tableView.sortColumn(ColumnViewHolder.this.getAdapterPosition(), SortState.DESCENDING);
            } else if (ColumnViewHolder.this.getSortState() == SortState.DESCENDING) {
                ColumnViewHolder.this.tableView.sortColumn(ColumnViewHolder.this.getAdapterPosition(), SortState.ASCENDING);
            } else {
                ColumnViewHolder.this.tableView.sortColumn(ColumnViewHolder.this.getAdapterPosition(), SortState.DESCENDING);
            }
        }
    };

    public ColumnViewHolder(@NonNull View itemView, @Nullable ITableView tableView) {
        super(itemView);
        this.tableView = tableView;
        this.column_header_textview = (TextView)itemView.findViewById(R.id.column_header_textView);
        this.column_header_container = (LinearLayout)itemView.findViewById(R.id.column_header_container);
        this.column_header_sortButton = (ImageButton)itemView.findViewById(R.id.column_header_sortButton);
        this.column_header_sortButton.setOnClickListener(this.mSortButtonClickListener);
    }

    public void setColumnHeader(@Nullable ColumnHeader columnHeader) {
        this.column_header_textview.setText((CharSequence)String.valueOf(columnHeader.getData()));
        this.column_header_container.getLayoutParams().width = -2;
        this.column_header_textview.requestLayout();
    }

    @Override
    public void onSortingStatusChanged(@NonNull SortState sortState) {
        Log.e((String)LOG_TAG, (String)(" + onSortingStatusChanged : x:  " + this.getAdapterPosition() + " old state " + (Object)((Object)this.getSortState()) + " current state : " + (Object)((Object)sortState) + " visiblity: " + this.column_header_sortButton.getVisibility()));
        super.onSortingStatusChanged(sortState);
        this.column_header_container.getLayoutParams().width = -2;
        this.controlSortState(sortState);
        Log.e((String)LOG_TAG, (String)(" - onSortingStatusChanged : x:  " + this.getAdapterPosition() + " old state " + (Object)((Object)this.getSortState()) + " current state : " + (Object)((Object)sortState) + " visiblity: " + this.column_header_sortButton.getVisibility()));
        this.column_header_textview.requestLayout();
        this.column_header_sortButton.requestLayout();
        this.column_header_container.requestLayout();
        this.itemView.requestLayout();
    }

    private void controlSortState(@NonNull SortState sortState) {
        if (sortState == SortState.ASCENDING) {
            this.column_header_sortButton.setVisibility(0);
            this.column_header_sortButton.setImageResource(R.drawable.ic_arrow_down);
        } else if (sortState == SortState.DESCENDING) {
            this.column_header_sortButton.setVisibility(0);
            this.column_header_sortButton.setImageResource(R.drawable.ic_arrow_up);
        } else {
            this.column_header_sortButton.setVisibility(4);
        }
    }
}

