/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.activity.BaseActivity;
import com.ahmadullahpk.alldocumentreader.databinding.ActivityViewFilesBinding;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.macro.DialogListener;
import com.ahmadullahpk.alldocumentreader.xs.res.ResKit;
import com.ahmadullahpk.alldocumentreader.xs.ss.sheetbar.SheetBar;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IMainFrame;
import com.ahmadullahpk.alldocumentreader.xs.system.MainControl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ViewFiles_Activity
extends BaseActivity
implements IMainFrame {
    ActivityViewFilesBinding binding;
    private static final String TAG = ViewFiles_Activity.class.getSimpleName();
    private LinearLayout appFrame;
    private int applicationType = -1;
    private final Object bg = -7829368;
    private SheetBar bottomBar;
    private MainControl control;
    private String fileName;
    private String filePath;
    private View gapView;
    private boolean isDispose;
    boolean isFromAppActivity = false;
    private boolean isThumbnail;
    private String tempFilePath;
    private Toast toast;
    private boolean writeLog = true;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            AppCompatDelegate.setDefaultNightMode((int)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.binding = ActivityViewFilesBinding.inflate(this.getLayoutInflater());
        RelativeLayout view = this.binding.getRoot();
        this.setContentView((View)view);
        this.binding.headerTitleText.setTextAppearance((Context)this, R.style.PageTitleBold);
        this.binding.imgBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewFiles_Activity.this.onBackPressed();
            }
        });
        this.binding.imgShare.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewFiles_Activity.this.shareFile();
            }
        });
        this.control = new MainControl(this);
        this.appFrame = (LinearLayout)this.findViewById(R.id.appFrame);
        if (this.getIntent() != null) {
            this.filePath = this.getIntent().getStringExtra("path");
            this.fileName = this.getIntent().getStringExtra("name");
            this.isFromAppActivity = this.getIntent().getBooleanExtra("fromAppActivity", false);
            this.binding.headerTitleText.setMaxLines(1);
            this.binding.headerTitleText.setText((CharSequence)this.fileName);
        }
        this.createView();
        this.control.openFile(this.filePath);
        this.control.setOffictToPicture(new IOfficeToPicture(){
            private Bitmap bitmap;

            @Override
            public void dispose() {
            }

            @Override
            public byte getModeType() {
                return 1;
            }

            @Override
            public boolean isZoom() {
                return false;
            }

            @Override
            public void setModeType(byte b) {
            }

            @Override
            public Bitmap getBitmap(int i, int i2) {
                if (i == 0 || i2 == 0) {
                    return null;
                }
                Bitmap bitmap = this.bitmap;
                if (bitmap == null || bitmap.getWidth() != i || this.bitmap.getHeight() != i2) {
                    Bitmap bitmap3 = this.bitmap;
                    if (bitmap3 != null) {
                        bitmap3.recycle();
                    }
                    this.bitmap = Bitmap.createBitmap((int)i, (int)i2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                return this.bitmap;
            }

            @Override
            public void callBack(Bitmap bitmap) {
                ViewFiles_Activity.this.saveBitmapToFile(bitmap);
            }
        });
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private void saveBitmapToFile(Bitmap bitmap) {
        String stringBuilder;
        File file;
        if (bitmap == null) {
            return;
        }
        if (this.tempFilePath == null) {
            if ("mounted".equals(Environment.getExternalStorageState())) {
                this.tempFilePath = Environment.getExternalStorageDirectory().getAbsolutePath();
            }
            if (!(file = new File(stringBuilder = this.tempFilePath + File.separatorChar + "tempPic")).exists()) {
                file.mkdir();
            }
            this.tempFilePath = file.getAbsolutePath();
        }
        stringBuilder = this.tempFilePath + File.separatorChar + "export_image.jpg";
        file = new File(stringBuilder);
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"saveBitmapToFile: ", (Throwable)ex);
        }
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    public DialogListener getDialogListener() {
        return null;
    }

    @Override
    public void setFindBackForwardState(boolean state) {
    }

    @Override
    public int getTopBarHeight() {
        return 0;
    }

    @Override
    public boolean onEventMethod(View v, MotionEvent e1, MotionEvent e2, float xValue, float yValue, byte eventMethodType) {
        return false;
    }

    @Override
    public boolean isDrawPageNumber() {
        return true;
    }

    @Override
    public boolean isShowZoomingMsg() {
        return true;
    }

    @Override
    public boolean isPopUpErrorDlg() {
        return true;
    }

    @Override
    public boolean isShowPasswordDlg() {
        return true;
    }

    @Override
    public boolean isShowProgressBar() {
        return true;
    }

    @Override
    public boolean isShowFindDlg() {
        return true;
    }

    @Override
    public boolean isShowTXTEncodeDlg() {
        return true;
    }

    @Override
    public String getTXTDefaultEncode() {
        return "GBK";
    }

    @Override
    public boolean isTouchZoom() {
        return true;
    }

    @Override
    public boolean isZoomAfterLayoutForWord() {
        return true;
    }

    @Override
    public byte getWordDefaultView() {
        return 0;
    }

    @Override
    public void changeZoom() {
    }

    @Override
    public void changePage() {
    }

    @Override
    public void completeLayout() {
    }

    @Override
    public void error(int errorCode) {
    }

    @Override
    public void fullScreen(boolean fullscreen) {
    }

    @Override
    public void showProgressBar(boolean visible) {
    }

    @Override
    public void updateViewImages(List<Integer> viewList) {
    }

    @Override
    public boolean isChangePage() {
        return true;
    }

    @Override
    public void setIgnoreOriginalSize(boolean ignoreOriginalSize) {
    }

    @Override
    public boolean isIgnoreOriginalSize() {
        return false;
    }

    @Override
    public byte getPageListViewMovingPosition() {
        return 0;
    }

    protected void onDestroy() {
        this.dispose();
        super.onDestroy();
    }

    private void createView() {
        String lowerCase = this.filePath.toLowerCase();
        this.applicationType = lowerCase.endsWith("doc") || lowerCase.endsWith("docx") || lowerCase.endsWith("txt") || lowerCase.endsWith("dot") || lowerCase.endsWith("dotx") || lowerCase.endsWith("dotm") ? 0 : (lowerCase.endsWith("xls") || lowerCase.endsWith("xlsx") || lowerCase.endsWith("xlt") || lowerCase.endsWith("xltx") || lowerCase.endsWith("xltm") || lowerCase.endsWith("xlsm") ? 1 : (lowerCase.endsWith("ppt") || lowerCase.endsWith("pptx") || lowerCase.endsWith("pot") || lowerCase.endsWith("pptm") || lowerCase.endsWith("potx") || lowerCase.endsWith("potm") ? 2 : (lowerCase.endsWith("pdf") ? 3 : 0)));
    }

    public void onBackPressed() {
        Object actionValue = this.control.getActionValue(0x51000000, null);
        if (actionValue == null || !((Boolean)actionValue).booleanValue()) {
            MainControl mainControl;
            if (this.control.getReader() != null) {
                this.control.getReader().abortReader();
            }
            if ((mainControl = this.control) == null || !mainControl.isAutoTest()) {
                if (this.isFromAppActivity) {
                    this.finish();
                }
                super.onBackPressed();
                this.overridePendingTransition(R.anim.slide_from_left, R.anim.slide_to_right);
                return;
            }
            System.exit(0);
            return;
        }
        this.fullScreen(false);
        this.control.actionEvent(1358954498, null);
    }

    private void maximiseScreen() {
        this.hideSystemUI();
    }

    private void shareFile() {
        Intent intent = new Intent("android.intent.action.SEND");
        Uri parse = Uri.parse((String)this.filePath);
        intent.setType("*/*");
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)parse);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getResources().getString(R.string.shareUsing)));
    }

    public void fileShare() {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        arrayList.add(Uri.fromFile((File)new File(this.filePath)));
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.putExtra("android.intent.extra.STREAM", arrayList);
        intent.setType("application/octet-stream");
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getResources().getText(R.string.sys_share_title)));
    }

    public Dialog onCreateDialog(int i) {
        return this.control.getDialog((Activity)this, i);
    }

    @Override
    public void updateToolsbarStatus() {
        LinearLayout linearLayout = this.appFrame;
        if (linearLayout != null && !this.isDispose) {
            int childCount = linearLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.appFrame.getChildAt(i);
            }
        }
    }

    public IControl getControl() {
        return this.control;
    }

    public int getApplicationType() {
        return this.applicationType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public boolean doActionEvent(int i, Object obj) {
        block13: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    if (i != 0) break block14;
                                    this.onBackPressed();
                                    break block13;
                                }
                                if (i == 15) break block13;
                                if (i != 20) break block15;
                                this.updateToolsbarStatus();
                                break block13;
                            }
                            if (i != 25) break block16;
                            this.setTitle((String)obj);
                            break block13;
                        }
                        if (i == 0x10000008) break block13;
                        if (i != 0x20000001) break block17;
                        this.fileShare();
                        break block13;
                    }
                    if (i != 0x2F000000) break block18;
                    String trim = ((String)obj).trim();
                    if (trim.length() <= 0 || !this.control.getFind().find(trim)) {
                        this.setFindBackForwardState(false);
                        this.toast.setText((CharSequence)this.getLocalString("DIALOG_FIND_NOT_FOUND"));
                        this.toast.show();
                    } else {
                        this.setFindBackForwardState(true);
                    }
                    break block13;
                }
                if (i == 0x40000004) break block19;
                switch (i) {
                    case 536870937: {
                        this.control.getSysKit().getCalloutManager().setDrawingMode(1);
                        this.appFrame.post(() -> this.control.actionEvent(536870942, null));
                        break block13;
                    }
                    case 536870938: {
                        this.control.getSysKit().getCalloutManager().setDrawingMode(0);
                        break block13;
                    }
                    case 536870939: {
                        if (!((Boolean)obj).booleanValue()) {
                            this.control.getSysKit().getCalloutManager().setDrawingMode(0);
                        } else {
                            this.control.getSysKit().getCalloutManager().setDrawingMode(1);
                            this.appFrame.post(() -> this.control.actionEvent(536870942, null));
                        }
                        break block13;
                    }
                    case 536870940: {
                        try {
                            if (!((Boolean)obj).booleanValue()) {
                                this.control.getSysKit().getCalloutManager().setDrawingMode(0);
                                break block13;
                            }
                            this.control.getSysKit().getCalloutManager().setDrawingMode(2);
                        }
                        catch (Exception e) {
                            this.control.getSysKit().getErrorKit().writerLog(e);
                        }
                        break block13;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.bottomBar.setFocusSheetButton((Integer)obj);
        }
        return true;
    }

    @Override
    public void openFileFinish() {
        View view;
        this.gapView = view = new View(this.getApplicationContext());
        view.setBackgroundColor(-7829368);
        this.appFrame.addView(this.control.getView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    @Override
    public int getBottomBarHeight() {
        SheetBar sheetBar = this.bottomBar;
        if (sheetBar != null) {
            return sheetBar.getSheetbarHeight();
        }
        return 0;
    }

    @Override
    public String getAppName() {
        return this.getString(R.string.sys_name);
    }

    public void destroyEngine() {
        super.onBackPressed();
    }

    @Override
    public String getLocalString(String str) {
        return ResKit.instance().getLocalString(str);
    }

    @Override
    public void setWriteLog(boolean z) {
        this.writeLog = z;
    }

    @Override
    public boolean isWriteLog() {
        return this.writeLog;
    }

    @Override
    public void setThumbnail(boolean z) {
        this.isThumbnail = z;
    }

    @Override
    public Object getViewBackground() {
        return this.bg;
    }

    @Override
    public boolean isThumbnail() {
        return this.isThumbnail;
    }

    @Override
    public File getTemporaryDirectory() {
        File externalFilesDir = this.getExternalFilesDir(null);
        if (externalFilesDir != null) {
            return externalFilesDir;
        }
        return this.getFilesDir();
    }

    @Override
    public void dispose() {
        this.isDispose = true;
        MainControl mainControl = this.control;
        if (mainControl != null) {
            mainControl.dispose();
            this.control = null;
        }
        this.bottomBar = null;
        LinearLayout linearLayout = this.appFrame;
        if (linearLayout != null) {
            int childCount = linearLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.appFrame.getChildAt(i);
            }
            this.appFrame = null;
        }
    }
}

