/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.queriable;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;

public abstract class ModelLoader<TModel, TReturn> {
    private final Class<TModel> modelClass;
    private DatabaseDefinition databaseDefinition;
    private InstanceAdapter<TModel> instanceAdapter;

    public ModelLoader(@NonNull Class<TModel> modelClass) {
        this.modelClass = modelClass;
    }

    @Nullable
    public TReturn load(@NonNull String query) {
        return this.load(this.getDatabaseDefinition().getWritableDatabase(), query);
    }

    @Nullable
    public TReturn load(@NonNull String query, @Nullable TReturn data) {
        return this.load(this.getDatabaseDefinition().getWritableDatabase(), query, data);
    }

    @Nullable
    public TReturn load(@NonNull DatabaseWrapper databaseWrapper, @NonNull String query) {
        return this.load(databaseWrapper, query, null);
    }

    @Nullable
    public TReturn load(@NonNull DatabaseWrapper databaseWrapper, @NonNull String query, @Nullable TReturn data) {
        FlowCursor cursor = databaseWrapper.rawQuery(query, null);
        return this.load(cursor, data);
    }

    @Nullable
    public TReturn load(@Nullable FlowCursor cursor) {
        return this.load(cursor, null);
    }

    @Nullable
    public TReturn load(@Nullable FlowCursor cursor, @Nullable TReturn data) {
        if (cursor != null) {
            try {
                data = this.convertToData(cursor, data);
            }
            finally {
                cursor.close();
            }
        }
        return data;
    }

    @NonNull
    public Class<TModel> getModelClass() {
        return this.modelClass;
    }

    @NonNull
    public InstanceAdapter<TModel> getInstanceAdapter() {
        if (this.instanceAdapter == null) {
            this.instanceAdapter = FlowManager.getInstanceAdapter(this.modelClass);
        }
        return this.instanceAdapter;
    }

    @NonNull
    public DatabaseDefinition getDatabaseDefinition() {
        if (this.databaseDefinition == null) {
            this.databaseDefinition = FlowManager.getDatabaseForTable(this.modelClass);
        }
        return this.databaseDefinition;
    }

    @Nullable
    public abstract TReturn convertToData(@NonNull FlowCursor var1, @Nullable TReturn var2);
}

