/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.converter.TypeConverter;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.property.Property;

public class TypeConvertedProperty<T, V>
extends Property<V> {
    private TypeConvertedProperty<V, T> databaseProperty;
    private boolean convertToDB;
    private final TypeConverterGetter getter;

    public TypeConvertedProperty(Class<?> table, NameAlias nameAlias, boolean convertToDB, TypeConverterGetter getter) {
        super(table, nameAlias);
        this.convertToDB = convertToDB;
        this.getter = getter;
    }

    public TypeConvertedProperty(Class<?> table, String columnName, boolean convertToDB, TypeConverterGetter getter) {
        super(table, columnName);
        this.convertToDB = convertToDB;
        this.getter = getter;
    }

    @Override
    @NonNull
    protected Operator<V> getCondition() {
        return Operator.op(this.getNameAlias(), this.getter.getTypeConverter(this.table), this.convertToDB);
    }

    @NonNull
    public Property<T> invertProperty() {
        if (this.databaseProperty == null) {
            this.databaseProperty = new TypeConvertedProperty<T, V>(this.table, this.nameAlias, !this.convertToDB, new TypeConverterGetter(){

                @Override
                public TypeConverter getTypeConverter(Class<?> modelClass) {
                    return TypeConvertedProperty.this.getter.getTypeConverter(modelClass);
                }
            });
        }
        return this.databaseProperty;
    }

    @Override
    @NonNull
    public Property<V> withTable(@NonNull NameAlias tableNameAlias) {
        NameAlias nameAlias = this.getNameAlias().newBuilder().withTable(tableNameAlias.getQuery()).build();
        return new TypeConvertedProperty<T, V>(this.getTable(), nameAlias, this.convertToDB, this.getter);
    }

    public static interface TypeConverterGetter {
        public TypeConverter getTypeConverter(Class<?> var1);
    }
}

