/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.TriggerMethod;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class Trigger
implements Query {
    public static final String BEFORE = "BEFORE";
    public static final String AFTER = "AFTER";
    public static final String INSTEAD_OF = "INSTEAD OF";
    final String triggerName;
    String beforeOrAfter;
    boolean temporary;

    @NonNull
    public static Trigger create(@NonNull String triggerName) {
        return new Trigger(triggerName);
    }

    private Trigger(@NonNull String triggerName) {
        this.triggerName = triggerName;
    }

    @NonNull
    public Trigger temporary() {
        this.temporary = true;
        return this;
    }

    @NonNull
    public Trigger after() {
        this.beforeOrAfter = AFTER;
        return this;
    }

    @NonNull
    public Trigger before() {
        this.beforeOrAfter = BEFORE;
        return this;
    }

    @NonNull
    public Trigger insteadOf() {
        this.beforeOrAfter = INSTEAD_OF;
        return this;
    }

    @NonNull
    public <TModel> TriggerMethod<TModel> deleteOn(@NonNull Class<TModel> onTable) {
        return new TriggerMethod<TModel>(this, "DELETE", onTable, new IProperty[0]);
    }

    @NonNull
    public <TModel> TriggerMethod<TModel> insertOn(@NonNull Class<TModel> onTable) {
        return new TriggerMethod<TModel>(this, "INSERT", onTable, new IProperty[0]);
    }

    @NonNull
    public <TModel> TriggerMethod<TModel> updateOn(@NonNull Class<TModel> onTable, IProperty ... properties) {
        return new TriggerMethod<TModel>(this, "UPDATE", onTable, properties);
    }

    @NonNull
    public String getName() {
        return this.triggerName;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"CREATE ");
        if (this.temporary) {
            queryBuilder.append((Object)"TEMP ");
        }
        queryBuilder.append((Object)"TRIGGER IF NOT EXISTS ").appendQuotedIfNeeded(this.triggerName).appendSpace().appendOptional((Object)(this.beforeOrAfter + " "));
        return queryBuilder.getQuery();
    }
}

