/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.config;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.runtime.BaseTransactionManager;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperListener;
import com.raizlabs.android.dbflow.structure.database.OpenHelper;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseConfig {
    private final OpenHelperCreator openHelperCreator;
    private final Class<?> databaseClass;
    private final TransactionManagerCreator transactionManagerCreator;
    private final DatabaseHelperListener helperListener;
    private final Map<Class<?>, TableConfig> tableConfigMap;
    private final ModelNotifier modelNotifier;
    private final boolean inMemory;
    private final String databaseName;
    private final String databaseExtensionName;

    public static Builder builder(@NonNull Class<?> database) {
        return new Builder(database);
    }

    public static Builder inMemoryBuilder(@NonNull Class<?> database) {
        return new Builder(database).inMemory();
    }

    DatabaseConfig(Builder builder) {
        this.openHelperCreator = builder.openHelperCreator;
        this.databaseClass = builder.databaseClass;
        this.transactionManagerCreator = builder.transactionManagerCreator;
        this.helperListener = builder.helperListener;
        this.tableConfigMap = builder.tableConfigMap;
        this.modelNotifier = builder.modelNotifier;
        this.inMemory = builder.inMemory;
        this.databaseName = builder.databaseName == null ? builder.databaseClass.getSimpleName() : builder.databaseName;
        this.databaseExtensionName = builder.databaseExtensionName == null ? ".db" : (StringUtils.isNotNullOrEmpty((String)builder.databaseExtensionName) ? "." + builder.databaseExtensionName : "");
    }

    @NonNull
    public String getDatabaseExtensionName() {
        return this.databaseExtensionName;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Nullable
    public OpenHelperCreator helperCreator() {
        return this.openHelperCreator;
    }

    @Nullable
    public DatabaseHelperListener helperListener() {
        return this.helperListener;
    }

    @NonNull
    public Class<?> databaseClass() {
        return this.databaseClass;
    }

    @Nullable
    public TransactionManagerCreator transactionManagerCreator() {
        return this.transactionManagerCreator;
    }

    @Nullable
    public ModelNotifier modelNotifier() {
        return this.modelNotifier;
    }

    @NonNull
    public Map<Class<?>, TableConfig> tableConfigMap() {
        return this.tableConfigMap;
    }

    @Nullable
    public <TModel> TableConfig<TModel> getTableConfigForTable(Class<TModel> modelClass) {
        return this.tableConfigMap().get(modelClass);
    }

    public static final class Builder {
        OpenHelperCreator openHelperCreator;
        final Class<?> databaseClass;
        TransactionManagerCreator transactionManagerCreator;
        DatabaseHelperListener helperListener;
        final Map<Class<?>, TableConfig> tableConfigMap = new HashMap();
        ModelNotifier modelNotifier;
        boolean inMemory = false;
        String databaseName;
        String databaseExtensionName;

        public Builder(@NonNull Class<?> databaseClass) {
            this.databaseClass = databaseClass;
        }

        public Builder transactionManagerCreator(TransactionManagerCreator transactionManager) {
            this.transactionManagerCreator = transactionManager;
            return this;
        }

        public Builder helperListener(DatabaseHelperListener helperListener) {
            this.helperListener = helperListener;
            return this;
        }

        public Builder addTableConfig(TableConfig<?> tableConfig) {
            this.tableConfigMap.put(tableConfig.tableClass(), tableConfig);
            return this;
        }

        public Builder modelNotifier(ModelNotifier modelNotifier) {
            this.modelNotifier = modelNotifier;
            return this;
        }

        @NonNull
        public Builder inMemory() {
            this.inMemory = true;
            return this;
        }

        @NonNull
        public Builder databaseName(String name) {
            this.databaseName = name;
            return this;
        }

        public Builder extensionName(String name) {
            this.databaseExtensionName = name;
            return this;
        }

        public Builder openHelper(OpenHelperCreator openHelper) {
            this.openHelperCreator = openHelper;
            return this;
        }

        public DatabaseConfig build() {
            return new DatabaseConfig(this);
        }
    }

    public static interface TransactionManagerCreator {
        public BaseTransactionManager createManager(DatabaseDefinition var1);
    }

    public static interface OpenHelperCreator {
        public OpenHelper createHelper(DatabaseDefinition var1, DatabaseHelperListener var2);
    }
}

