/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import com.raizlabs.android.dbflow.sql.saveable.ListModelSaver;
import com.raizlabs.android.dbflow.sql.saveable.ModelSaver;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.InvalidDBConfiguration;
import com.raizlabs.android.dbflow.structure.cache.IMultiKeyCacheConverter;
import com.raizlabs.android.dbflow.structure.cache.ModelCache;
import com.raizlabs.android.dbflow.structure.cache.SimpleMapCache;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;
import java.util.Collection;

public abstract class ModelAdapter<TModel>
extends InstanceAdapter<TModel>
implements InternalAdapter<TModel> {
    private DatabaseStatement insertStatement;
    private DatabaseStatement compiledStatement;
    private DatabaseStatement updateStatement;
    private DatabaseStatement deleteStatement;
    private String[] cachingColumns;
    private ModelCache<TModel, ?> modelCache;
    private ModelSaver<TModel> modelSaver;
    private ListModelSaver<TModel> listModelSaver;

    public ModelAdapter(@NonNull DatabaseDefinition databaseDefinition) {
        super(databaseDefinition);
        if (this.getTableConfig() != null && this.getTableConfig().modelSaver() != null) {
            this.modelSaver = this.getTableConfig().modelSaver();
            this.modelSaver.setModelAdapter(this);
        }
    }

    @NonNull
    public DatabaseStatement getInsertStatement() {
        if (this.insertStatement == null) {
            this.insertStatement = this.getInsertStatement(FlowManager.getWritableDatabaseForTable(this.getModelClass()));
        }
        return this.insertStatement;
    }

    @NonNull
    public DatabaseStatement getUpdateStatement() {
        if (this.updateStatement == null) {
            this.updateStatement = this.getUpdateStatement(FlowManager.getWritableDatabaseForTable(this.getModelClass()));
        }
        return this.updateStatement;
    }

    @NonNull
    public DatabaseStatement getDeleteStatement() {
        if (this.deleteStatement == null) {
            this.deleteStatement = this.getDeleteStatement(FlowManager.getWritableDatabaseForTable(this.getModelClass()));
        }
        return this.deleteStatement;
    }

    public void closeInsertStatement() {
        if (this.insertStatement == null) {
            return;
        }
        this.insertStatement.close();
        this.insertStatement = null;
    }

    @NonNull
    public DatabaseStatement getInsertStatement(@NonNull DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getInsertStatementQuery());
    }

    @NonNull
    public DatabaseStatement getUpdateStatement(@NonNull DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getUpdateStatementQuery());
    }

    @NonNull
    public DatabaseStatement getDeleteStatement(@NonNull DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getDeleteStatementQuery());
    }

    @NonNull
    public DatabaseStatement getCompiledStatement() {
        if (this.compiledStatement == null) {
            this.compiledStatement = this.getCompiledStatement(FlowManager.getWritableDatabaseForTable(this.getModelClass()));
        }
        return this.compiledStatement;
    }

    public void closeCompiledStatement() {
        if (this.compiledStatement == null) {
            return;
        }
        this.compiledStatement.close();
        this.compiledStatement = null;
    }

    public DatabaseStatement getCompiledStatement(@NonNull DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getCompiledStatementQuery());
    }

    public TModel loadFromCursor(@NonNull FlowCursor cursor) {
        Object model = this.newInstance();
        this.loadFromCursor(cursor, model);
        return model;
    }

    @Override
    public boolean save(@NonNull TModel model) {
        return this.getModelSaver().save(model);
    }

    @Override
    public boolean save(@NonNull TModel model, @NonNull DatabaseWrapper databaseWrapper) {
        return this.getModelSaver().save(model, databaseWrapper);
    }

    @Override
    public void saveAll(@NonNull Collection<TModel> models) {
        this.getListModelSaver().saveAll(models);
    }

    @Override
    public void saveAll(@NonNull Collection<TModel> models, @NonNull DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().saveAll(models, databaseWrapper);
    }

    @Override
    public long insert(@NonNull TModel model) {
        return this.getModelSaver().insert(model);
    }

    @Override
    public long insert(@NonNull TModel model, @NonNull DatabaseWrapper databaseWrapper) {
        return this.getModelSaver().insert(model, databaseWrapper);
    }

    @Override
    public void insertAll(@NonNull Collection<TModel> models) {
        this.getListModelSaver().insertAll(models);
    }

    @Override
    public void insertAll(@NonNull Collection<TModel> models, @NonNull DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().insertAll(models, databaseWrapper);
    }

    @Override
    public boolean update(@NonNull TModel model) {
        return this.getModelSaver().update(model);
    }

    @Override
    public boolean update(@NonNull TModel model, @NonNull DatabaseWrapper databaseWrapper) {
        return this.getModelSaver().update(model, databaseWrapper);
    }

    @Override
    public void updateAll(@NonNull Collection<TModel> models) {
        this.getListModelSaver().updateAll(models);
    }

    @Override
    public void updateAll(@NonNull Collection<TModel> models, @NonNull DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().updateAll(models, databaseWrapper);
    }

    @Override
    public boolean delete(@NonNull TModel model) {
        return this.getModelSaver().delete(model);
    }

    @Override
    public boolean delete(@NonNull TModel model, @NonNull DatabaseWrapper databaseWrapper) {
        return this.getModelSaver().delete(model, databaseWrapper);
    }

    @Override
    public void deleteAll(@NonNull Collection<TModel> tModels, @NonNull DatabaseWrapper databaseWrapper) {
        this.getListModelSaver().deleteAll(tModels, databaseWrapper);
    }

    @Override
    public void deleteAll(@NonNull Collection<TModel> tModels) {
        this.getListModelSaver().deleteAll(tModels);
    }

    @Override
    public void bindToInsertStatement(@NonNull DatabaseStatement sqLiteStatement, @NonNull TModel model) {
        this.bindToInsertStatement(sqLiteStatement, model, 0);
    }

    @Override
    public void bindToContentValues(@NonNull ContentValues contentValues, @NonNull TModel tModel) {
        this.bindToInsertValues(contentValues, tModel);
    }

    @Override
    public void bindToStatement(@NonNull DatabaseStatement sqLiteStatement, @NonNull TModel tModel) {
        this.bindToInsertStatement(sqLiteStatement, tModel, 0);
    }

    @Override
    public void updateAutoIncrement(@NonNull TModel model, @NonNull Number id) {
    }

    @Override
    @NonNull
    public Number getAutoIncrementingId(@NonNull TModel model) {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must containa single primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }

    @NonNull
    public String getAutoIncrementingColumnName() {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must contain an autoincrementing or single int/long primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }

    public void saveForeignKeys(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
    }

    public void deleteForeignKeys(@NonNull TModel model, @NonNull DatabaseWrapper wrapper) {
    }

    @NonNull
    public String[] createCachingColumns() {
        return new String[]{this.getAutoIncrementingColumnName()};
    }

    public String[] getCachingColumns() {
        if (this.cachingColumns == null) {
            this.cachingColumns = this.createCachingColumns();
        }
        return this.cachingColumns;
    }

    public Object[] getCachingColumnValuesFromCursor(@NonNull Object[] inValues, @NonNull FlowCursor cursor) {
        this.throwCachingError();
        return null;
    }

    public Object getCachingColumnValueFromCursor(@NonNull FlowCursor cursor) {
        this.throwSingleCachingError();
        return null;
    }

    public Object[] getCachingColumnValuesFromModel(@NonNull Object[] inValues, @NonNull TModel TModel) {
        this.throwCachingError();
        return null;
    }

    public Object getCachingColumnValueFromModel(@NonNull TModel model) {
        this.throwSingleCachingError();
        return null;
    }

    public void storeModelInCache(@NonNull TModel model) {
        this.getModelCache().addModel(this.getCachingId(model), model);
    }

    public void removeModelFromCache(@NonNull TModel model) {
        this.getModelCache().removeModel(this.getCachingId(model));
    }

    public ModelCache<TModel, ?> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = this.createModelCache();
        }
        return this.modelCache;
    }

    public Object getCachingId(@NonNull Object[] inValues) {
        if (inValues.length == 1) {
            return inValues[0];
        }
        return this.getCacheConverter().getCachingKey(inValues);
    }

    public Object getCachingId(@NonNull TModel model) {
        return this.getCachingId(this.getCachingColumnValuesFromModel(new Object[this.getCachingColumns().length], model));
    }

    public ModelSaver<TModel> getModelSaver() {
        if (this.modelSaver == null) {
            this.modelSaver = new ModelSaver();
            this.modelSaver.setModelAdapter(this);
        }
        return this.modelSaver;
    }

    public ListModelSaver<TModel> getListModelSaver() {
        if (this.listModelSaver == null) {
            this.listModelSaver = this.createListModelSaver();
        }
        return this.listModelSaver;
    }

    protected ListModelSaver<TModel> createListModelSaver() {
        return new ListModelSaver<TModel>(this.getModelSaver());
    }

    public void setModelSaver(ModelSaver<TModel> modelSaver) {
        this.modelSaver = modelSaver;
        this.modelSaver.setModelAdapter(this);
    }

    public void reloadRelationships(@NonNull TModel model, @NonNull FlowCursor cursor) {
        if (!this.cachingEnabled()) {
            this.throwCachingError();
        }
    }

    @Override
    public boolean cachingEnabled() {
        return false;
    }

    public int getCacheSize() {
        return 25;
    }

    public IMultiKeyCacheConverter<?> getCacheConverter() {
        throw new InvalidDBConfiguration("For multiple primary keys, a public static IMultiKeyCacheConverter field mustbe  marked with @MultiCacheField in the corresponding model class. The resulting keymust be a unique combination of the multiple keys, otherwise inconsistencies may occur.");
    }

    public ModelCache<TModel, ?> createModelCache() {
        return new SimpleMapCache(this.getCacheSize());
    }

    public abstract String getCreationQuery();

    public abstract Property getProperty(String var1);

    public abstract IProperty[] getAllColumnProperties();

    protected String getInsertStatementQuery() {
        return this.getCompiledStatementQuery();
    }

    protected abstract String getCompiledStatementQuery();

    protected abstract String getUpdateStatementQuery();

    protected abstract String getDeleteStatementQuery();

    public ConflictAction getUpdateOnConflictAction() {
        return ConflictAction.ABORT;
    }

    public ConflictAction getInsertOnConflictAction() {
        return ConflictAction.ABORT;
    }

    private void throwCachingError() {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must containan auto-incrementing or at least one primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }

    private void throwSingleCachingError() {
        throw new InvalidDBConfiguration(String.format("This method may have been called in error. The model class %1s must containan auto-incrementing or one primary key (if used in a ModelCache, this method may be called)", this.getModelClass()));
    }
}

