/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.config;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.config.DatabaseConfig;
import com.raizlabs.android.dbflow.config.DatabaseHolder;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.TableConfig;
import com.raizlabs.android.dbflow.runtime.BaseTransactionManager;
import com.raizlabs.android.dbflow.runtime.ContentResolverNotifier;
import com.raizlabs.android.dbflow.runtime.ModelNotifier;
import com.raizlabs.android.dbflow.sql.migration.Migration;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.ModelViewAdapter;
import com.raizlabs.android.dbflow.structure.QueryModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperListener;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowSQLiteOpenHelper;
import com.raizlabs.android.dbflow.structure.database.OpenHelper;
import com.raizlabs.android.dbflow.structure.database.transaction.DefaultTransactionManager;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DatabaseDefinition {
    private final Map<Integer, List<Migration>> migrationMap = new HashMap<Integer, List<Migration>>();
    private final Map<Class<?>, ModelAdapter> modelAdapters = new HashMap();
    private final Map<String, Class<?>> modelTableNames = new HashMap();
    private final Map<Class<?>, ModelViewAdapter> modelViewAdapterMap = new LinkedHashMap();
    private final Map<Class<?>, QueryModelAdapter> queryModelAdapterMap = new LinkedHashMap();
    private OpenHelper openHelper;
    private DatabaseHelperListener helperListener;
    private boolean isResetting = false;
    @NonNull
    private BaseTransactionManager transactionManager;
    @Nullable
    private DatabaseConfig databaseConfig = FlowManager.getConfig().databaseConfigMap().get(this.getAssociatedDatabaseClassFile());
    @Nullable
    private ModelNotifier modelNotifier;

    public DatabaseDefinition() {
        if (this.databaseConfig != null) {
            Collection<TableConfig> tableConfigCollection = this.databaseConfig.tableConfigMap().values();
            for (TableConfig tableConfig : tableConfigCollection) {
                ModelAdapter modelAdapter = this.modelAdapters.get(tableConfig.tableClass());
                if (modelAdapter == null) continue;
                if (tableConfig.listModelLoader() != null) {
                    modelAdapter.setListModelLoader(tableConfig.listModelLoader());
                }
                if (tableConfig.singleModelLoader() != null) {
                    modelAdapter.setSingleModelLoader(tableConfig.singleModelLoader());
                }
                if (tableConfig.modelSaver() == null) continue;
                modelAdapter.setModelSaver(tableConfig.modelSaver());
            }
            this.helperListener = this.databaseConfig.helperListener();
        }
        this.transactionManager = this.databaseConfig == null || this.databaseConfig.transactionManagerCreator() == null ? new DefaultTransactionManager(this) : this.databaseConfig.transactionManagerCreator().createManager(this);
    }

    protected <T> void addModelAdapter(ModelAdapter<T> modelAdapter, DatabaseHolder holder) {
        holder.putDatabaseForTable(modelAdapter.getModelClass(), this);
        this.modelTableNames.put(modelAdapter.getTableName(), modelAdapter.getModelClass());
        this.modelAdapters.put(modelAdapter.getModelClass(), modelAdapter);
    }

    protected <T> void addModelViewAdapter(ModelViewAdapter<T> modelViewAdapter, DatabaseHolder holder) {
        holder.putDatabaseForTable(modelViewAdapter.getModelClass(), this);
        this.modelViewAdapterMap.put(modelViewAdapter.getModelClass(), modelViewAdapter);
    }

    protected <T> void addQueryModelAdapter(QueryModelAdapter<T> queryModelAdapter, DatabaseHolder holder) {
        holder.putDatabaseForTable(queryModelAdapter.getModelClass(), this);
        this.queryModelAdapterMap.put(queryModelAdapter.getModelClass(), queryModelAdapter);
    }

    protected void addMigration(int version, Migration migration) {
        List<Migration> list = this.migrationMap.get(version);
        if (list == null) {
            list = new ArrayList<Migration>();
            this.migrationMap.put(version, list);
        }
        list.add(migration);
    }

    @NonNull
    public List<Class<?>> getModelClasses() {
        return new ArrayList(this.modelAdapters.keySet());
    }

    @NonNull
    public BaseTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @NonNull
    public List<ModelAdapter> getModelAdapters() {
        return new ArrayList<ModelAdapter>(this.modelAdapters.values());
    }

    @Nullable
    public <T> ModelAdapter<T> getModelAdapterForTable(Class<T> table) {
        return this.modelAdapters.get(table);
    }

    @Nullable
    public Class<?> getModelClassForName(String tableName) {
        return this.modelTableNames.get(tableName);
    }

    @NonNull
    public List<Class<?>> getModelViews() {
        return new ArrayList(this.modelViewAdapterMap.keySet());
    }

    @Nullable
    public <T> ModelViewAdapter<T> getModelViewAdapterForTable(Class<T> table) {
        return this.modelViewAdapterMap.get(table);
    }

    @NonNull
    public List<ModelViewAdapter> getModelViewAdapters() {
        return new ArrayList<ModelViewAdapter>(this.modelViewAdapterMap.values());
    }

    @NonNull
    public List<QueryModelAdapter> getModelQueryAdapters() {
        return new ArrayList<QueryModelAdapter>(this.queryModelAdapterMap.values());
    }

    @Nullable
    public <T> QueryModelAdapter<T> getQueryModelAdapterForQueryClass(Class<T> queryModel) {
        return this.queryModelAdapterMap.get(queryModel);
    }

    @NonNull
    public Map<Integer, List<Migration>> getMigrations() {
        return this.migrationMap;
    }

    @NonNull
    public synchronized OpenHelper getHelper() {
        if (this.openHelper == null) {
            DatabaseConfig config = FlowManager.getConfig().databaseConfigMap().get(this.getAssociatedDatabaseClassFile());
            this.openHelper = config == null || config.helperCreator() == null ? new FlowSQLiteOpenHelper(this, this.helperListener) : config.helperCreator().createHelper(this, this.helperListener);
            this.openHelper.performRestoreFromBackup();
        }
        return this.openHelper;
    }

    @NonNull
    public DatabaseWrapper getWritableDatabase() {
        return this.getHelper().getDatabase();
    }

    @NonNull
    public ModelNotifier getModelNotifier() {
        if (this.modelNotifier == null) {
            DatabaseConfig config = FlowManager.getConfig().databaseConfigMap().get(this.getAssociatedDatabaseClassFile());
            this.modelNotifier = config == null || config.modelNotifier() == null ? new ContentResolverNotifier() : config.modelNotifier();
        }
        return this.modelNotifier;
    }

    @NonNull
    public Transaction.Builder beginTransactionAsync(@NonNull ITransaction transaction) {
        return new Transaction.Builder(transaction, this);
    }

    public void executeTransaction(@NonNull ITransaction transaction) {
        DatabaseWrapper database = this.getWritableDatabase();
        try {
            database.beginTransaction();
            transaction.execute(database);
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
    }

    @NonNull
    public abstract String getDatabaseName();

    @NonNull
    public String getDatabaseFileName() {
        return this.getDatabaseName() + (StringUtils.isNotNullOrEmpty((String)this.getDatabaseExtensionName()) ? "." + this.getDatabaseExtensionName() : "");
    }

    @NonNull
    public String getDatabaseExtensionName() {
        return "db";
    }

    public abstract boolean isInMemory();

    public abstract int getDatabaseVersion();

    public abstract boolean areConsistencyChecksEnabled();

    public abstract boolean isForeignKeysSupported();

    public abstract boolean backupEnabled();

    @NonNull
    public abstract Class<?> getAssociatedDatabaseClassFile();

    public void reset(@NonNull Context context) {
        if (!this.isResetting) {
            this.isResetting = true;
            this.getTransactionManager().stopQueue();
            this.getHelper().closeDB();
            for (ModelAdapter modelAdapter : this.modelAdapters.values()) {
                modelAdapter.closeInsertStatement();
                modelAdapter.closeCompiledStatement();
            }
            context.deleteDatabase(this.getDatabaseFileName());
            this.transactionManager = this.databaseConfig == null || this.databaseConfig.transactionManagerCreator() == null ? new DefaultTransactionManager(this) : this.databaseConfig.transactionManagerCreator().createManager(this);
            this.openHelper = null;
            this.isResetting = false;
            this.getHelper().getDatabase();
        }
    }

    public void destroy(@NonNull Context context) {
        if (!this.isResetting) {
            this.isResetting = true;
            this.getTransactionManager().stopQueue();
            this.getHelper().closeDB();
            context.deleteDatabase(this.getDatabaseFileName());
            this.openHelper = null;
            this.isResetting = false;
        }
    }

    public boolean isDatabaseIntegrityOk() {
        return this.getHelper().isDatabaseIntegrityOk();
    }

    public void backupDatabase() {
        this.getHelper().backupDB();
    }
}

