/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.utils;

import com.raizlabs.android.dbflow.annotation.ColumnIgnore;
import com.raizlabs.android.dbflow.processor.ProcessorManager;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0015"}, d2={"Lcom/raizlabs/android/dbflow/processor/utils/ElementUtility;", "", "()V", "getAllElements", "", "Ljavax/lang/model/element/Element;", "element", "Ljavax/lang/model/element/TypeElement;", "manager", "Lcom/raizlabs/android/dbflow/processor/ProcessorManager;", "getClassName", "Lcom/squareup/javapoet/ClassName;", "elementClassname", "", "isInSamePackage", "", "elementToCheck", "original", "isPackagePrivate", "isValidAllFields", "allFields", "dbflow-processor"})
public final class ElementUtility {
    public static final ElementUtility INSTANCE;

    @NotNull
    public final List<Element> getAllElements(@NotNull TypeElement element, @NotNull ProcessorManager manager) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        ArrayList elements = new ArrayList(manager.getElements().getAllMembers(element));
        TypeMirror superMirror = null;
        TypeElement typeElement = element;
        block0: while (true) {
            AnnotatedConstruct annotatedConstruct;
            TypeMirror it;
            TypeElement typeElement2 = typeElement;
            superMirror = it = (annotatedConstruct = typeElement2 != null ? typeElement2.getSuperclass() : null);
            if (!(it != null)) break;
            TypeElement typeElement3 = typeElement = (TypeElement)manager.getTypeUtils().asElement(superMirror);
            if (typeElement3 == null) continue;
            it = annotatedConstruct = typeElement3;
            List<? extends Element> superElements = manager.getElements().getAllMembers(typeElement);
            Iterable $receiver$iv = superElements;
            Iterator iterator = $receiver$iv.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Object element$iv = iterator.next();
                Element it2 = (Element)element$iv;
                if (elements.contains(it2)) continue;
                Collection collection = elements;
                collection.add(it2);
            }
        }
        return elements;
    }

    public final boolean isInSamePackage(@NotNull ProcessorManager manager, @NotNull Element elementToCheck, @NotNull Element original) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)elementToCheck, (String)"elementToCheck");
        Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
        return Intrinsics.areEqual((Object)manager.getElements().getPackageOf(elementToCheck).toString(), (Object)manager.getElements().getPackageOf(original).toString());
    }

    public final boolean isPackagePrivate(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public final boolean isValidAllFields(boolean allFields, @NotNull Element element) {
        Element $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return allFields && element.getKind().isField() && !element.getModifiers().contains((Object)Modifier.STATIC) && !element.getModifiers().contains((Object)Modifier.FINAL) && ($receiver$iv = element).getAnnotation(ColumnIgnore.class) == null;
    }

    @Nullable
    public final ClassName getClassName(@NotNull String elementClassname, @NotNull ProcessorManager manager) {
        ClassName className;
        Intrinsics.checkParameterIsNotNull((Object)elementClassname, (String)"elementClassname");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        TypeElement typeElement = manager.getElements().getTypeElement(elementClassname);
        if (typeElement != null) {
            className = ClassName.get((TypeElement)typeElement);
        } else {
            List names = StringsKt.split$default((CharSequence)elementClassname, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            Collection collection = names;
            if (!collection.isEmpty()) {
                String className2 = (String)names.get(names.size() - 1);
                className = ClassName.get((String)StringsKt.replace$default((String)elementClassname, (String)("." + className2), (String)"", (boolean)false, (int)4, null), (String)className2, (String[])new String[0]);
            } else {
                className = null;
            }
        }
        return className;
    }

    private ElementUtility() {
        INSTANCE = this;
    }

    static {
        new ElementUtility();
    }
}

