/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.folderselector;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.webkit.MimeTypeMap;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.commons.R;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FileChooserDialog
extends DialogFragment
implements MaterialDialog.ListCallback {
    private static final String DEFAULT_TAG = "[MD_FILE_SELECTOR]";
    private File parentFolder;
    private File[] parentContents;
    private boolean canGoUp = true;
    private FileCallback callback;

    CharSequence[] getContentsArray() {
        if (this.parentContents == null) {
            if (this.canGoUp) {
                return new String[]{this.getBuilder().goUpLabel};
            }
            return new String[0];
        }
        CharSequence[] results = new String[this.parentContents.length + (this.canGoUp ? 1 : 0)];
        if (this.canGoUp) {
            results[0] = this.getBuilder().goUpLabel;
        }
        for (int i = 0; i < this.parentContents.length; ++i) {
            results[this.canGoUp ? i + 1 : i] = this.parentContents[i].getName();
        }
        return results;
    }

    File[] listFiles(@Nullable String mimeType, @Nullable String[] extensions) {
        File[] contents = this.parentFolder.listFiles();
        ArrayList<File> results = new ArrayList<File>();
        if (contents != null) {
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            for (File fi : contents) {
                if (fi.isDirectory()) {
                    results.add(fi);
                    continue;
                }
                if (extensions != null) {
                    boolean found = false;
                    for (String ext : extensions) {
                        if (!fi.getName().toLowerCase().endsWith(ext.toLowerCase())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    results.add(fi);
                    continue;
                }
                if (mimeType == null || !this.fileIsMimeType(fi, mimeType, mimeTypeMap)) continue;
                results.add(fi);
            }
            Collections.sort(results, new FileSorter());
            return results.toArray(new File[results.size()]);
        }
        return null;
    }

    boolean fileIsMimeType(File file, String mimeType, MimeTypeMap mimeTypeMap) {
        if (mimeType == null || mimeType.equals("*/*")) {
            return true;
        }
        String filename = file.toURI().toString();
        int dotPos = filename.lastIndexOf(46);
        if (dotPos == -1) {
            return false;
        }
        String fileExtension = filename.substring(dotPos + 1);
        if (fileExtension.endsWith("json")) {
            return mimeType.startsWith("application/json");
        }
        String fileType = mimeTypeMap.getMimeTypeFromExtension(fileExtension);
        if (fileType == null) {
            return false;
        }
        if (fileType.equals(mimeType)) {
            return true;
        }
        int mimeTypeDelimiter = mimeType.lastIndexOf(47);
        if (mimeTypeDelimiter == -1) {
            return false;
        }
        String mimeTypeMainType = mimeType.substring(0, mimeTypeDelimiter);
        String mimeTypeSubtype = mimeType.substring(mimeTypeDelimiter + 1);
        if (!mimeTypeSubtype.equals("*")) {
            return false;
        }
        int fileTypeDelimiter = fileType.lastIndexOf(47);
        if (fileTypeDelimiter == -1) {
            return false;
        }
        String fileTypeMainType = fileType.substring(0, fileTypeDelimiter);
        return fileTypeMainType.equals(mimeTypeMainType);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            return new MaterialDialog.Builder((Context)this.getActivity()).title(R.string.md_error_label).content(R.string.md_storage_perm_error).positiveText(17039370).build();
        }
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            throw new IllegalStateException("You must create a FileChooserDialog using the Builder.");
        }
        if (!this.getArguments().containsKey("current_path")) {
            this.getArguments().putString("current_path", this.getBuilder().initialPath);
        }
        this.parentFolder = new File(this.getArguments().getString("current_path"));
        this.checkIfCanGoUp();
        this.parentContents = this.listFiles(this.getBuilder().mimeType, this.getBuilder().extensions);
        return new MaterialDialog.Builder((Context)this.getActivity()).title((CharSequence)this.parentFolder.getAbsolutePath()).typeface(this.getBuilder().mediumFont, this.getBuilder().regularFont).items(this.getContentsArray()).itemsCallback((MaterialDialog.ListCallback)this).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                dialog.dismiss();
            }
        }).autoDismiss(false).negativeText(this.getBuilder().cancelButton).build();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.callback != null) {
            this.callback.onFileChooserDismissed(this);
        }
    }

    public void onSelection(MaterialDialog materialDialog, View view, int i, CharSequence s) {
        if (this.canGoUp && i == 0) {
            this.parentFolder = this.parentFolder.getParentFile();
            if (this.parentFolder.getAbsolutePath().equals("/storage/emulated")) {
                this.parentFolder = this.parentFolder.getParentFile();
            }
            this.canGoUp = this.parentFolder.getParent() != null;
        } else {
            this.parentFolder = this.parentContents[this.canGoUp ? i - 1 : i];
            this.canGoUp = true;
            if (this.parentFolder.getAbsolutePath().equals("/storage/emulated")) {
                this.parentFolder = Environment.getExternalStorageDirectory();
            }
        }
        if (this.parentFolder.isFile()) {
            this.callback.onFileSelection(this, this.parentFolder);
            this.dismiss();
        } else {
            this.parentContents = this.listFiles(this.getBuilder().mimeType, this.getBuilder().extensions);
            MaterialDialog dialog = (MaterialDialog)this.getDialog();
            dialog.setTitle((CharSequence)this.parentFolder.getAbsolutePath());
            this.getArguments().putString("current_path", this.parentFolder.getAbsolutePath());
            dialog.setItems(this.getContentsArray());
        }
    }

    private void checkIfCanGoUp() {
        try {
            this.canGoUp = this.parentFolder.getPath().split("/").length > 1;
        }
        catch (IndexOutOfBoundsException e) {
            this.canGoUp = false;
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.getActivity() instanceof FileCallback) {
            this.callback = (FileCallback)this.getActivity();
        } else if (this.getParentFragment() instanceof FileCallback) {
            this.callback = (FileCallback)this.getParentFragment();
        } else {
            throw new IllegalStateException("FileChooserDialog needs to be shown from an Activity/Fragment implementing FileCallback.");
        }
    }

    public void show(FragmentManager fragmentManager) {
        String tag = this.getBuilder().tag;
        Fragment frag = fragmentManager.findFragmentByTag(tag);
        if (frag != null) {
            ((DialogFragment)frag).dismiss();
            fragmentManager.beginTransaction().remove(frag).commit();
        }
        this.show(fragmentManager, tag);
    }

    public void show(FragmentActivity fragmentActivity) {
        this.show(fragmentActivity.getSupportFragmentManager());
    }

    @NonNull
    public String getInitialPath() {
        return this.getBuilder().initialPath;
    }

    @NonNull
    private Builder getBuilder() {
        return (Builder)this.getArguments().getSerializable("builder");
    }

    private static class FileSorter
    implements Comparator<File> {
        private FileSorter() {
        }

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs.isDirectory() && !rhs.isDirectory()) {
                return -1;
            }
            if (!lhs.isDirectory() && rhs.isDirectory()) {
                return 1;
            }
            return lhs.getName().compareTo(rhs.getName());
        }
    }

    public static class Builder
    implements Serializable {
        @NonNull
        final transient Context context;
        @StringRes
        int cancelButton;
        String initialPath;
        String mimeType;
        String[] extensions;
        String tag;
        String goUpLabel;
        @Nullable
        String mediumFont;
        @Nullable
        String regularFont;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.cancelButton = 0x1040000;
            this.initialPath = Environment.getExternalStorageDirectory().getAbsolutePath();
            this.mimeType = null;
            this.goUpLabel = "...";
        }

        @NonNull
        public Builder typeface(@Nullable String medium, @Nullable String regular) {
            this.mediumFont = medium;
            this.regularFont = regular;
            return this;
        }

        @NonNull
        public Builder cancelButton(@StringRes int text) {
            this.cancelButton = text;
            return this;
        }

        @NonNull
        public Builder initialPath(@Nullable String initialPath) {
            if (initialPath == null) {
                initialPath = File.separator;
            }
            this.initialPath = initialPath;
            return this;
        }

        @NonNull
        public Builder mimeType(@Nullable String type) {
            this.mimeType = type;
            return this;
        }

        @NonNull
        public Builder extensionsFilter(String ... extensions) {
            this.extensions = extensions;
            return this;
        }

        @NonNull
        public Builder tag(@Nullable String tag) {
            if (tag == null) {
                tag = FileChooserDialog.DEFAULT_TAG;
            }
            this.tag = tag;
            return this;
        }

        @NonNull
        public Builder goUpLabel(String text) {
            this.goUpLabel = text;
            return this;
        }

        @NonNull
        public FileChooserDialog build() {
            FileChooserDialog dialog = new FileChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable("builder", (Serializable)this);
            dialog.setArguments(args);
            return dialog;
        }

        @NonNull
        public FileChooserDialog show(FragmentManager fragmentManager) {
            FileChooserDialog dialog = this.build();
            dialog.show(fragmentManager);
            return dialog;
        }

        @NonNull
        public FileChooserDialog show(FragmentActivity fragmentActivity) {
            return this.show(fragmentActivity.getSupportFragmentManager());
        }
    }

    public static interface FileCallback {
        public void onFileSelection(@NonNull FileChooserDialog var1, @NonNull File var2);

        public void onFileChooserDismissed(@NonNull FileChooserDialog var1);
    }
}

