/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.simplelist;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.afollestad.materialdialogs.util.DialogUtils;

public class MaterialSimpleListItem {
    private final Builder mBuilder;

    private MaterialSimpleListItem(Builder builder) {
        this.mBuilder = builder;
    }

    public Drawable getIcon() {
        return this.mBuilder.mIcon;
    }

    public CharSequence getContent() {
        return this.mBuilder.mContent;
    }

    public int getIconPadding() {
        return this.mBuilder.mIconPadding;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.mBuilder.mBackgroundColor;
    }

    public long getId() {
        return this.mBuilder.mId;
    }

    @Nullable
    public Object getTag() {
        return this.mBuilder.mTag;
    }

    public String toString() {
        if (this.getContent() != null) {
            return this.getContent().toString();
        }
        return "(no content)";
    }

    public static class Builder {
        private final Context mContext;
        protected Drawable mIcon;
        protected CharSequence mContent;
        protected int mIconPadding;
        protected int mBackgroundColor;
        protected long mId;
        protected Object mTag;

        public Builder(Context context) {
            this.mContext = context;
            this.mBackgroundColor = Color.parseColor((String)"#BCBCBC");
        }

        public Builder icon(Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder icon(@DrawableRes int iconRes) {
            return this.icon(ContextCompat.getDrawable((Context)this.mContext, (int)iconRes));
        }

        public Builder iconPadding(@IntRange(from=0L, to=0x7FFFFFFFL) int padding) {
            this.mIconPadding = padding;
            return this;
        }

        public Builder iconPaddingDp(@IntRange(from=0L, to=0x7FFFFFFFL) int paddingDp) {
            this.mIconPadding = (int)TypedValue.applyDimension((int)1, (float)paddingDp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
            return this;
        }

        public Builder iconPaddingRes(@DimenRes int paddingRes) {
            return this.iconPadding(this.mContext.getResources().getDimensionPixelSize(paddingRes));
        }

        public Builder content(CharSequence content) {
            this.mContent = content;
            return this;
        }

        public Builder content(@StringRes int contentRes) {
            return this.content(this.mContext.getString(contentRes));
        }

        public Builder backgroundColor(@ColorInt int color) {
            this.mBackgroundColor = color;
            return this;
        }

        public Builder backgroundColorRes(@ColorRes int colorRes) {
            return this.backgroundColor(DialogUtils.getColor((Context)this.mContext, (int)colorRes));
        }

        public Builder backgroundColorAttr(@AttrRes int colorAttr) {
            return this.backgroundColor(DialogUtils.resolveColor((Context)this.mContext, (int)colorAttr));
        }

        public Builder id(long id) {
            this.mId = id;
            return this;
        }

        public Builder tag(@Nullable Object tag) {
            this.mTag = tag;
            return this;
        }

        public MaterialSimpleListItem build() {
            return new MaterialSimpleListItem(this);
        }
    }
}

