/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.folderselector;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.commons.R;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FolderChooserDialog
extends DialogFragment
implements MaterialDialog.ListCallback {
    private static final String DEFAULT_TAG = "[MD_FOLDER_SELECTOR]";
    private File parentFolder;
    private File[] parentContents;
    private boolean canGoUp = true;
    private FolderCallback mCallback;

    String[] getContentsArray() {
        if (this.parentContents == null) {
            return new String[0];
        }
        String[] results = new String[this.parentContents.length + (this.canGoUp ? 1 : 0)];
        if (this.canGoUp) {
            results[0] = "...";
        }
        for (int i = 0; i < this.parentContents.length; ++i) {
            results[this.canGoUp ? i + 1 : i] = this.parentContents[i].getName();
        }
        return results;
    }

    File[] listFiles() {
        File[] contents = this.parentFolder.listFiles();
        ArrayList<File> results = new ArrayList<File>();
        if (contents != null) {
            for (File fi : contents) {
                if (!fi.isDirectory()) continue;
                results.add(fi);
            }
            Collections.sort(results, new FolderSorter());
            return results.toArray(new File[results.size()]);
        }
        return null;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            return new MaterialDialog.Builder((Context)this.getActivity()).title(R.string.md_error_label).content(R.string.md_storage_perm_error).positiveText(17039370).build();
        }
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            throw new IllegalStateException("You must create a FolderChooserDialog using the Builder.");
        }
        if (!this.getArguments().containsKey("current_path")) {
            this.getArguments().putString("current_path", this.getBuilder().mInitialPath);
        }
        this.parentFolder = new File(this.getArguments().getString("current_path"));
        this.parentContents = this.listFiles();
        return new MaterialDialog.Builder((Context)this.getActivity()).title((CharSequence)this.parentFolder.getAbsolutePath()).items((CharSequence[])this.getContentsArray()).itemsCallback((MaterialDialog.ListCallback)this).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                dialog.dismiss();
                FolderChooserDialog.this.mCallback.onFolderSelection(FolderChooserDialog.this, FolderChooserDialog.this.parentFolder);
            }
        }).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                dialog.dismiss();
            }
        }).autoDismiss(false).positiveText(this.getBuilder().mChooseButton).negativeText(this.getBuilder().mCancelButton).build();
    }

    public void onSelection(MaterialDialog materialDialog, View view, int i, CharSequence s) {
        if (this.canGoUp && i == 0) {
            this.parentFolder = this.parentFolder.getParentFile();
            if (this.parentFolder.getAbsolutePath().equals("/storage/emulated")) {
                this.parentFolder = this.parentFolder.getParentFile();
            }
            this.canGoUp = this.parentFolder.getParent() != null;
        } else {
            this.parentFolder = this.parentContents[this.canGoUp ? i - 1 : i];
            this.canGoUp = true;
            if (this.parentFolder.getAbsolutePath().equals("/storage/emulated")) {
                this.parentFolder = Environment.getExternalStorageDirectory();
            }
        }
        this.parentContents = this.listFiles();
        MaterialDialog dialog = (MaterialDialog)this.getDialog();
        dialog.setTitle((CharSequence)this.parentFolder.getAbsolutePath());
        this.getArguments().putString("current_path", this.parentFolder.getAbsolutePath());
        dialog.setItems((CharSequence[])this.getContentsArray());
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mCallback = (FolderCallback)activity;
    }

    public void show(FragmentActivity context) {
        String tag = this.getBuilder().mTag;
        Fragment frag = context.getSupportFragmentManager().findFragmentByTag(tag);
        if (frag != null) {
            ((DialogFragment)frag).dismiss();
            context.getSupportFragmentManager().beginTransaction().remove(frag).commit();
        }
        this.show(context.getSupportFragmentManager(), tag);
    }

    @NonNull
    private Builder getBuilder() {
        return (Builder)this.getArguments().getSerializable("builder");
    }

    private static class FolderSorter
    implements Comparator<File> {
        private FolderSorter() {
        }

        @Override
        public int compare(File lhs, File rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    }

    public static class Builder
    implements Serializable {
        @NonNull
        protected final transient AppCompatActivity mContext;
        @StringRes
        protected int mChooseButton;
        @StringRes
        protected int mCancelButton;
        protected String mInitialPath;
        protected String mTag;

        public <ActivityType extends AppCompatActivity> Builder(@NonNull ActivityType context) {
            this.mContext = context;
            this.mChooseButton = R.string.md_choose_label;
            this.mCancelButton = 0x1040000;
            this.mInitialPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        }

        @NonNull
        public Builder chooseButton(@StringRes int text) {
            this.mChooseButton = text;
            return this;
        }

        @NonNull
        public Builder cancelButton(@StringRes int text) {
            this.mCancelButton = text;
            return this;
        }

        @NonNull
        public Builder initialPath(@Nullable String initialPath) {
            if (initialPath == null) {
                initialPath = File.separator;
            }
            this.mInitialPath = initialPath;
            return this;
        }

        @NonNull
        public Builder tag(@Nullable String tag) {
            if (tag == null) {
                tag = FolderChooserDialog.DEFAULT_TAG;
            }
            this.mTag = tag;
            return this;
        }

        @NonNull
        public FolderChooserDialog build() {
            FolderChooserDialog dialog = new FolderChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable("builder", (Serializable)this);
            dialog.setArguments(args);
            return dialog;
        }

        @NonNull
        public FolderChooserDialog show() {
            FolderChooserDialog dialog = this.build();
            dialog.show((FragmentActivity)this.mContext);
            return dialog;
        }
    }

    public static interface FolderCallback {
        public void onFolderSelection(@NonNull FolderChooserDialog var1, @NonNull File var2);
    }
}

