/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import com.aefyr.pseudoapksigner.Constants;
import com.aefyr.pseudoapksigner.ManifestBuilder;
import com.aefyr.pseudoapksigner.Utils;

class SignatureFileGenerator {
    private ManifestBuilder mManifest;
    private String mHashingAlgorithm;

    SignatureFileGenerator(ManifestBuilder manifestBuilder, String hashingAlgorithm) {
        this.mManifest = manifestBuilder;
        this.mHashingAlgorithm = hashingAlgorithm;
    }

    String generate() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.generateHeader().toString());
        for (ManifestBuilder.ManifestEntry manifestEntry : this.mManifest.getEntries()) {
            ManifestBuilder.ManifestEntry sfEntry = new ManifestBuilder.ManifestEntry();
            sfEntry.setAttribute("Name", manifestEntry.getAttribute("Name"));
            sfEntry.setAttribute(this.mHashingAlgorithm + "-Digest", Utils.base64Encode(Utils.hash(manifestEntry.toString().getBytes("UTF-8"), this.mHashingAlgorithm)));
            stringBuilder.append(sfEntry.toString());
        }
        return stringBuilder.toString();
    }

    private ManifestBuilder.ManifestEntry generateHeader() throws Exception {
        ManifestBuilder.ManifestEntry header = new ManifestBuilder.ManifestEntry();
        header.setAttribute("Signature-Version", "1.0");
        header.setAttribute("Created-By", Constants.GENERATOR_NAME);
        header.setAttribute(this.mHashingAlgorithm + "-Digest-Manifest", Utils.base64Encode(Utils.hash(this.mManifest.build().getBytes("UTF-8"), this.mHashingAlgorithm)));
        return header;
    }
}

