/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import android.os.Build;
import android.util.Log;
import com.aefyr.pseudoapksigner.PseudoApkSigner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class PseudoApkSignerInputStream
extends InputStream {
    private PseudoApkSigner mPseudoApkSigner;
    private PipedInputStream mPipeInput;
    private PipedOutputStream mPipeOutput;

    public PseudoApkSignerInputStream(File template, File privateKey, InputStream inputStream) throws Exception {
        this.init(template, privateKey, null, inputStream);
    }

    public PseudoApkSignerInputStream(File template, File privateKey, String signerName, InputStream inputStream) throws Exception {
        this.init(template, privateKey, signerName, inputStream);
    }

    private void init(File template, File privateKey, String signerName, final InputStream inputStream) throws Exception {
        this.mPseudoApkSigner = new PseudoApkSigner(template, privateKey);
        if (signerName != null) {
            this.mPseudoApkSigner.setSignerName(signerName);
        }
        this.mPipeOutput = new PipedOutputStream();
        if (Build.VERSION.SDK_INT >= 9) {
            this.mPipeInput = new PipedInputStream(0x100000);
            this.mPipeInput.connect(this.mPipeOutput);
        } else {
            this.mPipeInput = new PipedInputStream(this.mPipeOutput);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PseudoApkSignerInputStream.this.mPseudoApkSigner.sign(inputStream, PseudoApkSignerInputStream.this.mPipeOutput);
                }
                catch (Exception e) {
                    Log.w((String)"PASInputStream", (Throwable)e);
                }
            }
        }).start();
    }

    @Override
    public int read() throws IOException {
        return this.mPipeInput.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.mPipeInput.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.mPipeInput.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.mPipeInput.available();
    }

    @Override
    public void close() throws IOException {
        this.mPipeInput.close();
    }
}

