/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import com.aefyr.pseudoapksigner.Constants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

class ManifestBuilder {
    private ArrayList<ManifestEntry> mEntries = new ArrayList();
    private long mVersion = 0L;
    private String mCachedManifest;
    private long mCachedVersion = -1L;

    ManifestBuilder() {
    }

    String build() {
        if (this.mVersion == this.mCachedVersion) {
            return this.mCachedManifest;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.generateHeader().toString());
        for (ManifestEntry entry : this.mEntries) {
            stringBuilder.append(entry.toString());
        }
        this.mCachedVersion = this.mVersion;
        this.mCachedManifest = stringBuilder.toString();
        return this.mCachedManifest;
    }

    private ManifestEntry generateHeader() {
        ManifestEntry header = new ManifestEntry();
        header.setAttribute("Manifest-Version", "1.0");
        header.setAttribute("Created-By", Constants.GENERATOR_NAME);
        return header;
    }

    void addEntry(ManifestEntry entry) {
        this.mEntries.add(entry);
        ++this.mVersion;
    }

    List<ManifestEntry> getEntries() {
        return this.mEntries;
    }

    static class ManifestEntry {
        private LinkedHashMap<String, String> mAttributes = new LinkedHashMap();

        ManifestEntry() {
        }

        void setAttribute(String attribute, String value) {
            this.mAttributes.put(attribute, value);
        }

        String getAttribute(String attribute) {
            return this.mAttributes.get(attribute);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : this.mAttributes.keySet()) {
                stringBuilder.append(String.format("%s: %s\r\n", key, this.mAttributes.get(key)));
            }
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }
    }
}

