/*
 * Decompiled with CFR 0.152.
 */
package com.aefyr.pseudoapksigner;

import com.aefyr.pseudoapksigner.Constants;
import com.aefyr.pseudoapksigner.ManifestGenerator;
import com.aefyr.pseudoapksigner.Utils;

class SignatureFileGenerator {
    private ManifestGenerator mManifest;
    private String mHashingAlgorithm;

    SignatureFileGenerator(ManifestGenerator manifestGenerator) {
        this.mManifest = manifestGenerator;
        this.mHashingAlgorithm = manifestGenerator.getHashingAlgorithm();
    }

    String generate() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.generateHeader().toString());
        for (ManifestGenerator.ManifestEntry manifestEntry : this.mManifest.getEntries()) {
            ManifestGenerator.ManifestEntry sfEntry = new ManifestGenerator.ManifestEntry();
            sfEntry.setAttribute("Name", manifestEntry.getAttribute("Name"));
            sfEntry.setAttribute(this.mHashingAlgorithm + "-Digest", Utils.base64Encode(Utils.hash(manifestEntry.toString().getBytes("UTF-8"), this.mHashingAlgorithm)));
            stringBuilder.append(sfEntry.toString());
        }
        return stringBuilder.toString();
    }

    private ManifestGenerator.ManifestEntry generateHeader() throws Exception {
        ManifestGenerator.ManifestEntry header = new ManifestGenerator.ManifestEntry();
        header.setAttribute("Signature-Version", "1.0");
        header.setAttribute("Created-By", Constants.GENERATOR_NAME);
        header.setAttribute(this.mHashingAlgorithm + "-Digest-Manifest", Utils.base64Encode(Utils.hash(this.mManifest.generate().getBytes("UTF-8"), this.mHashingAlgorithm)));
        return header;
    }
}

