/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.xtivia.sgdxp.annotation.RegularRole;
import com.xtivia.sgdxp.core.SgDxpApplication;
import com.xtivia.sgdxp.filter.AbstractSecurityFilter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegularRole
public class RegularRoleFilter
extends AbstractSecurityFilter {
    private static Logger _logger = LoggerFactory.getLogger(RegularRoleFilter.class);

    public RegularRoleFilter(SgDxpApplication xsfApplication) {
        super(xsfApplication);
    }

    @Override
    public void filter(ContainerRequestContext requestContext) {
        ResourceInfo resourceInfo;
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Regular role filter executes for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
        if (!this.checkInRegularRole()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Regular role filter succeeds for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    private boolean checkInRegularRole() {
        boolean result = true;
        RegularRole annotation = (RegularRole)this.getAnnotation(RegularRole.class);
        if (annotation != null) {
            String[] roles = annotation.value();
            User user = this.getUser();
            if (user != null && !user.isDefaultUser()) {
                try {
                    for (String role : roles) {
                        RoleLocalService roleLocalService = this.getSgDxpApplication().getRoleLocalService();
                        result = roleLocalService.hasUserRole(user.getUserId(), user.getCompanyId(), role, true);
                        if (!result) continue;
                        return result;
                    }
                }
                catch (PortalException | SystemException e) {
                    _logger.error("Error accessing DXP role service", e);
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

