/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.filter;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.xtivia.sgdxp.annotation.OrgMember;
import com.xtivia.sgdxp.core.SgDxpApplication;
import com.xtivia.sgdxp.filter.AbstractSecurityFilter;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OrgMember
public class OrgMemberFilter
extends AbstractSecurityFilter {
    private static Logger _logger = LoggerFactory.getLogger(OrgMemberFilter.class);

    public OrgMemberFilter(SgDxpApplication xsfApplication) {
        super(xsfApplication);
    }

    @Override
    public void filter(ContainerRequestContext requestContext) {
        ResourceInfo resourceInfo;
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Org member filter executes for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
        if (!this.checkUserInOrg()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (_logger.isDebugEnabled()) {
            resourceInfo = super.getResourceInfo();
            _logger.debug(String.format("Org member filter succeeds for class=%s, method=%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        }
    }

    private boolean checkUserInOrg() {
        boolean result = true;
        OrgMember annotation = (OrgMember)this.getAnnotation(OrgMember.class);
        if (annotation != null) {
            User user = this.getUser();
            if (user != null && !user.isDefaultUser()) {
                try {
                    String orgname = annotation.value();
                    List organizations = user.getOrganizations();
                    result = false;
                    for (Organization organization : organizations) {
                        if (!organization.getName().equals(orgname)) continue;
                        result = true;
                    }
                }
                catch (PortalException | SystemException e) {
                    _logger.error("Error accessing user organizations", e);
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }
}

