/*
 * Decompiled with CFR 0.152.
 */
package org.abelsromero.embedded.mongo;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.MongoImportExecutable;
import de.flapdoodle.embed.mongo.MongoImportProcess;
import de.flapdoodle.embed.mongo.MongoImportStarter;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongoImportConfig;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongoImportConfigBuilder;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.abelsromero.embedded.mongo.AnnotationHelper;
import org.abelsromero.embedded.mongo.EmbeddedMongoDbConfiguration;
import org.abelsromero.embedded.mongo.EmbeddedMongoDbImport;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class EmbeddedMongoDb
extends TestWatcher {
    private static final String BIND_IP = "127.0.0.1";
    private MongodExecutable executable;
    private MongoDatabase db;
    private String collectionName;
    private String databaseName;

    protected void starting(Description description) {
        EmbeddedMongoDbImport mongoImport;
        EmbeddedMongoDbConfiguration mongoConfiguration = (EmbeddedMongoDbConfiguration)description.getAnnotation(EmbeddedMongoDbConfiguration.class);
        if (mongoConfiguration != null && mongoConfiguration.skip()) {
            return;
        }
        int port = this.port(mongoConfiguration);
        String version = this.version(mongoConfiguration);
        this.executable = (MongodExecutable)MongodStarter.getDefaultInstance().prepare((IExecutableProcessConfig)this.buildMongoConfig(port, version));
        this.executable.start();
        this.databaseName = this.databaseName(mongoConfiguration);
        this.collectionName = this.collectionName(mongoConfiguration);
        if (mongoConfiguration != null) {
            this.db = new MongoClient("localhost", port).getDatabase(mongoConfiguration.database());
            this.db.createCollection(this.collectionName);
        }
        if ((mongoImport = (EmbeddedMongoDbImport)description.getAnnotation(EmbeddedMongoDbImport.class)) != null && mongoImport.file().length() > 0) {
            this.startMongoImport(BIND_IP, port, version, this.databaseName, this.collectionName, mongoImport.file(), mongoImport == null ? AnnotationHelper.getDefaultBooleanValue(EmbeddedMongoDbImport.class, "jsonArray").booleanValue() : mongoImport.jsonArray());
        }
    }

    private MongoImportProcess startMongoImport(String bindIp, int port, String version, String dbName, String collection, String jsonFile, boolean jsonArray) {
        IMongoImportConfig mongoImportConfig = new MongoImportConfigBuilder().version((IFeatureAwareVersion)Version.valueOf((String)version)).net(new Net(bindIp, port, Network.localhostIsIPv6())).db(dbName).collection(collection).upsert(false).dropCollection(true).jsonArray(jsonArray).importFile(this.absolutePath(jsonFile)).build();
        MongoImportExecutable mongoImportExecutable = (MongoImportExecutable)MongoImportStarter.getDefaultInstance().prepare((IExecutableProcessConfig)mongoImportConfig);
        return (MongoImportProcess)mongoImportExecutable.start();
    }

    protected void finished(Description description) {
        if (this.executable != null) {
            this.executable.stop();
        }
    }

    private String collectionName(EmbeddedMongoDbConfiguration mongoConfiguration) {
        return mongoConfiguration != null ? mongoConfiguration.collection() : AnnotationHelper.getDefaultStringValue(EmbeddedMongoDbConfiguration.class, "collection");
    }

    private String databaseName(EmbeddedMongoDbConfiguration mongoConfiguration) {
        return mongoConfiguration != null ? mongoConfiguration.collection() : AnnotationHelper.getDefaultStringValue(EmbeddedMongoDbConfiguration.class, "database");
    }

    private int port(EmbeddedMongoDbConfiguration mongoConfiguration) {
        return mongoConfiguration != null ? mongoConfiguration.port() : AnnotationHelper.getDefaultIntValue(EmbeddedMongoDbConfiguration.class, "port").intValue();
    }

    private String version(EmbeddedMongoDbConfiguration mongoConfiguration) {
        return mongoConfiguration != null ? mongoConfiguration.version() : AnnotationHelper.getDefaultStringValue(EmbeddedMongoDbConfiguration.class, "version");
    }

    private String absolutePath(String jsonFile) {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(jsonFile);
        if (resource == null) {
            throw new FileNotFoundException("Could not find file: " + jsonFile);
        }
        return new File(resource.toURI()).getAbsolutePath();
    }

    private IMongodConfig buildMongoConfig(int port, String version) throws IOException {
        return new MongodConfigBuilder().version((IFeatureAwareVersion)Version.valueOf((String)version)).net(new Net(BIND_IP, port, Network.localhostIsIPv6())).build();
    }
}

