/*
 * Decompiled with CFR 0.152.
 */
package in.aabhasjindal.otptextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import in.aabhasjindal.otptextview.ItemView;
import in.aabhasjindal.otptextview.OTPChildEditText;
import in.aabhasjindal.otptextview.OTPListener;
import in.aabhasjindal.otptextview.R;
import in.aabhasjindal.otptextview.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class OtpTextView
extends FrameLayout {
    private static final int DEFAULT_LENGTH = 4;
    private static final int DEFAULT_HEIGHT = 48;
    private static final int DEFAULT_WIDTH = 48;
    private static final int DEFAULT_SPACE = 0;
    private static final int DEFAULT_SPACE_LEFT = 4;
    private static final int DEFAULT_SPACE_RIGHT = 4;
    private static final int DEFAULT_SPACE_TOP = 4;
    private static final int DEFAULT_SPACE_BOTTOM = 4;
    private Context context;
    private List<ItemView> itemViews;
    private OTPChildEditText otpChildEditText;
    private OTPListener otpListener;
    private int length;

    public OtpTextView(@NonNull Context context) {
        super(context);
        this.context = context;
        this.init(null);
    }

    public OtpTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    public OtpTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.OtpTextView);
        this.styleEditTexts(styles, attrs);
        styles.recycle();
    }

    private void styleEditTexts(TypedArray styles, AttributeSet attrs) {
        this.length = styles.getInt(R.styleable.OtpTextView_length, 4);
        this.generateViews(styles, attrs);
    }

    private void generateViews(TypedArray styles, AttributeSet attrs) {
        this.itemViews = new ArrayList<ItemView>();
        if (this.length > 0) {
            int width = (int)styles.getDimension(R.styleable.OtpTextView_width, (float)Utils.getPixels(this.context, 48));
            int height = (int)styles.getDimension(R.styleable.OtpTextView_height, (float)Utils.getPixels(this.context, 48));
            int space = (int)styles.getDimension(R.styleable.OtpTextView_padding, (float)Utils.getPixels(this.context, 0));
            int spaceLeft = (int)styles.getDimension(R.styleable.OtpTextView_padding_left, (float)Utils.getPixels(this.context, 4));
            int spaceRight = (int)styles.getDimension(R.styleable.OtpTextView_padding_right, (float)Utils.getPixels(this.context, 4));
            int spaceTop = (int)styles.getDimension(R.styleable.OtpTextView_padding_top, (float)Utils.getPixels(this.context, 4));
            int spaceBottom = (int)styles.getDimension(R.styleable.OtpTextView_padding_bottom, (float)Utils.getPixels(this.context, 4));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
            if (space > 0) {
                int spaceInPx = Utils.getPixels(this.context, space);
                params.setMargins(spaceInPx, spaceInPx, spaceInPx, spaceInPx);
            } else {
                params.setMargins(Utils.getPixels(this.context, spaceLeft), Utils.getPixels(this.context, spaceRight), Utils.getPixels(this.context, spaceTop), Utils.getPixels(this.context, spaceBottom));
            }
            LinearLayout.LayoutParams editTextLayoutParams = new LinearLayout.LayoutParams(-1, -2);
            editTextLayoutParams.gravity = 17;
            this.otpChildEditText = new OTPChildEditText(this.context);
            this.otpChildEditText.setFilters(new InputFilter[]{this.getFilter(), new InputFilter.LengthFilter(this.length)});
            this.setTextWatcher(this.otpChildEditText);
            this.addView((View)this.otpChildEditText, (ViewGroup.LayoutParams)editTextLayoutParams);
            LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(-1, -2);
            LinearLayout linearLayout = new LinearLayout(this.context);
            this.addView((View)linearLayout, (ViewGroup.LayoutParams)linearLayoutParams);
            for (int i = 0; i < this.length; ++i) {
                ItemView itemView = new ItemView(this.context, attrs);
                itemView.setViewState(0);
                linearLayout.addView((View)itemView, i, (ViewGroup.LayoutParams)params);
                this.itemViews.add(itemView);
            }
        } else {
            throw new IllegalStateException("Please specify the length of the otp view");
        }
    }

    private void setTextWatcher(OTPChildEditText otpChildEditText) {
        otpChildEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s.length() == OtpTextView.this.length && OtpTextView.this.otpListener != null) {
                    OtpTextView.this.otpListener.onOTPComplete(s.toString());
                }
                OtpTextView.this.setOTP(s);
                OtpTextView.this.setFocus(s.length());
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private void setFocus(int length) {
        for (int i = 0; i < this.itemViews.size(); ++i) {
            if (i == length) {
                this.itemViews.get(i).setViewState(1);
                continue;
            }
            this.itemViews.get(i).setViewState(0);
        }
        if (length == this.itemViews.size()) {
            this.itemViews.get(this.itemViews.size() - 1).setViewState(1);
        }
    }

    public void setOTP(CharSequence s) {
        for (int i = 0; i < this.itemViews.size(); ++i) {
            if (i < s.length()) {
                this.itemViews.get(i).setText(String.valueOf(s.charAt(i)));
                continue;
            }
            this.itemViews.get(i).setText("");
        }
    }

    public OTPListener getOtpListener() {
        return this.otpListener;
    }

    public void setOtpListener(OTPListener otpListener) {
        this.otpListener = otpListener;
    }

    private InputFilter getFilter() {
        return new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                for (int i = start; i < end; ++i) {
                    if (Pattern.compile("[1234567890]*").matcher(String.valueOf(source.charAt(i))).matches()) continue;
                    return "";
                }
                return null;
            }
        };
    }

    public void requestFocusOTP() {
        if (this.otpChildEditText != null) {
            this.otpChildEditText.requestFocus();
        }
    }

    public void showError() {
        if (this.itemViews != null) {
            for (ItemView itemView : this.itemViews) {
                itemView.setViewState(-1);
            }
        }
    }

    public void showSuccessError() {
        if (this.itemViews != null) {
            for (ItemView itemView : this.itemViews) {
                itemView.setViewState(2);
            }
        }
    }

    public void setOTP(String otp) {
        this.otpChildEditText.setText(otp);
    }

    public String getOTP() {
        if (this.otpChildEditText != null && this.otpChildEditText.getText() != null) {
            return this.otpChildEditText.getText().toString();
        }
        return null;
    }
}

