/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.app.Activity;
import android.net.Uri;
import androidx.core.util.Pair;
import com.gowtham.library.utils.TrimmerUtils;
import com.gowtham.library.utils.VideoRes;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"fromDisplayName", "Lcom/gowtham/library/utils/VideoRes;", "name", "", "getVideoResNames", "", "context", "Landroid/app/Activity;", "inputUri", "Landroid/net/Uri;", "library_release"})
@SourceDebugExtension(value={"SMAP\nVideoRes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoRes.kt\ncom/gowtham/library/utils/VideoResKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n1282#2,2:74\n*S KotlinDebug\n*F\n+ 1 VideoRes.kt\ncom/gowtham/library/utils/VideoResKt\n*L\n12#1:74,2\n*E\n"})
public final class VideoResKt {
    @Nullable
    public static final VideoRes fromDisplayName(@NotNull String name) {
        VideoRes videoRes;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VideoRes[] $this$firstOrNull$iv = VideoRes.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                VideoRes element$iv;
                VideoRes it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)name)) continue;
                videoRes = element$iv;
                break block1;
            }
            videoRes = null;
        }
        return videoRes;
    }

    @NotNull
    public static final List<String> getVideoResNames(@NotNull Activity context, @NotNull Uri inputUri) {
        Pair<Integer, Integer> wh;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inputUri, (String)"inputUri");
        Pair<Integer, Integer> pair = wh = TrimmerUtils.getVideoRes(context, inputUri);
        Intrinsics.checkNotNull(pair);
        Object object = pair.first;
        Intrinsics.checkNotNull((Object)object);
        int n = ((Number)object).intValue();
        Object object2 = wh.second;
        Intrinsics.checkNotNull((Object)object2);
        VideoRes inputRes = TrimmerUtils.classifyResolution(n, ((Number)object2).intValue());
        if (inputRes != VideoRes.LOWER_SD) {
            ArrayList<String> list = new ArrayList<String>();
            for (VideoRes res : VideoRes.values()) {
                if (res.ordinal() > inputRes.ordinal() || res == VideoRes.LOWER_SD) continue;
                list.add(res.getDisplayName());
            }
            return list;
        }
        Object[] objectArray = new String[]{inputRes.getDisplayName()};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }
}

