/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import androidx.core.content.ContextCompat;
import androidx.core.util.Pair;
import com.gowtham.library.utils.LogMessage;
import com.gowtham.library.utils.TrimType;
import com.gowtham.library.utils.VideoRes;
import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrimmerUtils {
    public static int getColor(Context context, int color2) {
        return ContextCompat.getColor((Context)context, (int)color2);
    }

    public static long getDuration(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            String time = retriever.extractMetadata(9);
            long timeInMillisec = Long.parseLong(time);
            retriever.release();
            return timeInMillisec / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getDurationMillis(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            String time = retriever.extractMetadata(9);
            long timeInMillisec = Long.parseLong(time);
            retriever.release();
            return timeInMillisec;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static int getTrimType(TrimType trimType) {
        switch (trimType) {
            case FIXED_DURATION: {
                return 1;
            }
            case MIN_DURATION: {
                return 2;
            }
            case MIN_MAX_DURATION: {
                return 3;
            }
        }
        return 0;
    }

    public static String getFileExtension(Context context, Uri uri) {
        try {
            String extension;
            if (uri.getScheme() != null && uri.getScheme().equals("content")) {
                MimeTypeMap mime = MimeTypeMap.getSingleton();
                extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
            } else {
                extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            }
            return extension == null || extension.isEmpty() ? ".mp4" : extension;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "mp4";
        }
    }

    public static Bitmap getFrameBySec(Activity context, Uri videoPath, long millies) {
        try {
            String formatted = millies + "000000";
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            Bitmap bitmap = retriever.getFrameAtTime(Long.parseLong(formatted));
            retriever.release();
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getFrameRate(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            int frameRate = Integer.parseInt(retriever.extractMetadata(32));
            retriever.release();
            return frameRate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 30;
        }
    }

    public static long getBitRate(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            long bitRate = Long.parseLong(retriever.extractMetadata(20));
            retriever.release();
            return bitRate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 15L;
        }
    }

    public static Pair<Integer, Integer> getVideoRes(Activity context, Uri videoUri) {
        try {
            MediaMetadataRetriever metaRetriever = new MediaMetadataRetriever();
            metaRetriever.setDataSource((Context)context, videoUri);
            String height = metaRetriever.extractMetadata(19);
            String width = metaRetriever.extractMetadata(18);
            int w = TrimmerUtils.clearNull(width).isEmpty() ? 0 : Integer.parseInt(width);
            int h = Integer.parseInt(height);
            return new Pair((Object)w, (Object)h);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getVideoRotation(Activity context, Uri videoUri) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoUri);
            int rotation = Integer.parseInt(retriever.extractMetadata(24));
            retriever.release();
            return rotation;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String formatSeconds(long timeInSeconds) {
        long hours = timeInSeconds / 3600L;
        long secondsLeft = timeInSeconds - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String formattedTime = "";
        if (hours < 10L && hours != 0L) {
            formattedTime = formattedTime + "0";
            formattedTime = formattedTime + hours + ":";
        }
        if (minutes < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + minutes + ":";
        if (seconds < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + seconds;
        return formattedTime;
    }

    public static String getLimitedTimeFormatted(long secs) {
        long hours = secs / 3600L;
        long secondsLeft = secs - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String time = hours != 0L ? hours + " Hrs " + (minutes != 0L ? minutes + " Mins " : "") + (seconds != 0L ? seconds + " Secs " : "") : (minutes != 0L ? minutes + " Mins " + (seconds != 0L ? seconds + " Secs " : "") : seconds + " Secs ");
        LogMessage.v(time);
        return time;
    }

    public static String clearNull(String value) {
        return value == null ? "" : value.trim();
    }

    public static boolean hasSpecialChar(String value) {
        value = TrimmerUtils.clearNull(value);
        Pattern p = Pattern.compile("[^a-z0-9 ]", 2);
        Matcher m = p.matcher(value);
        return m.find();
    }

    public static HashMap<VideoRes, Long> getResBitRate(Activity context, Uri fileUri) {
        HashMap<VideoRes, Long> resolutionBitRateMap = new HashMap<VideoRes, Long>();
        long videoBitRate = TrimmerUtils.getBitRate(context, fileUri);
        resolutionBitRateMap.put(VideoRes.LOWER_SD, videoBitRate != 0L ? videoBitRate : TrimmerUtils.mbToBits(0.09));
        resolutionBitRateMap.put(VideoRes.SD_360, videoBitRate != 0L ? Math.min(videoBitRate, TrimmerUtils.mbToBits(0.13)) : TrimmerUtils.mbToBits(0.13));
        resolutionBitRateMap.put(VideoRes.SD, videoBitRate != 0L ? Math.min(videoBitRate, TrimmerUtils.mbToBits(0.18)) : TrimmerUtils.mbToBits(0.18));
        resolutionBitRateMap.put(VideoRes.HD, videoBitRate != 0L ? Math.min(videoBitRate, TrimmerUtils.mbToBits(0.35)) : TrimmerUtils.mbToBits(0.35));
        resolutionBitRateMap.put(VideoRes.FULL_HD, videoBitRate != 0L ? Math.min(videoBitRate, TrimmerUtils.mbToBits(0.84)) : TrimmerUtils.mbToBits(0.84));
        return resolutionBitRateMap;
    }

    private static long mbToBits(double mb) {
        return (long)(mb * 8.0 * 1024.0 * 1024.0);
    }

    public static VideoRes classifyResolution(int width, int height) {
        int resolution = Math.max(width, height);
        if (resolution >= 1920) {
            return VideoRes.FULL_HD;
        }
        if (resolution >= 1280) {
            return VideoRes.HD;
        }
        if (resolution >= 854) {
            return VideoRes.SD;
        }
        if (resolution >= 640) {
            return VideoRes.SD_360;
        }
        return VideoRes.LOWER_SD;
    }
}

