/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.ui.seekbar.widgets;

import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.animation.OvershootInterpolator;
import com.gowtham.library.R;
import com.gowtham.library.ui.seekbar.widgets.CrystalRangeSeekbar;

public class BubbleThumbRangeSeekbar
extends CrystalRangeSeekbar {
    private boolean animate;
    private boolean isPressedLeftThumb;
    private boolean isPressedRightThumb;
    private BubbleRect thumbPressedRect;

    public BubbleThumbRangeSeekbar(Context context) {
        super(context);
    }

    public BubbleThumbRangeSeekbar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BubbleThumbRangeSeekbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.thumbPressedRect = new BubbleRect();
        super.init();
    }

    @Override
    protected void touchDown(float x, float y) {
        super.touchDown(x, y);
        this.animate = true;
        if (CrystalRangeSeekbar.Thumb.MIN.equals((Object)this.getPressedThumb())) {
            this.isPressedLeftThumb = true;
            this.startAnimationUp(CrystalRangeSeekbar.Thumb.MIN);
        } else if (CrystalRangeSeekbar.Thumb.MAX.equals((Object)this.getPressedThumb())) {
            this.isPressedRightThumb = true;
            this.startAnimationUp(CrystalRangeSeekbar.Thumb.MAX);
        }
    }

    @Override
    protected void touchUp(float x, float y) {
        super.touchUp(x, y);
        this.animate = true;
        if (CrystalRangeSeekbar.Thumb.MIN.equals((Object)this.getPressedThumb())) {
            this.startAnimationDown(CrystalRangeSeekbar.Thumb.MIN);
        } else {
            this.startAnimationDown(CrystalRangeSeekbar.Thumb.MAX);
        }
    }

    @Override
    protected void drawLeftThumbWithColor(Canvas canvas, Paint paint, RectF rect) {
        if (this.isPressedLeftThumb) {
            if (!this.animate) {
                rect.left -= this.getBubbleWith() / 2.0f - this.getThumbWidth() / 2.0f;
                rect.right = rect.left + this.getBubbleWith();
                rect.top = this.getLeftThumbRect().top - (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
                rect.bottom = this.getLeftThumbRect().bottom + (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
            } else {
                rect.left = this.thumbPressedRect.left;
                rect.right = this.thumbPressedRect.right;
                rect.top = this.thumbPressedRect.top;
                rect.bottom = this.thumbPressedRect.bottom;
            }
            canvas.drawOval(rect, paint);
        } else {
            canvas.drawOval(rect, paint);
        }
    }

    @Override
    protected void drawRightThumbWithColor(Canvas canvas, Paint paint, RectF rect) {
        if (this.isPressedRightThumb) {
            if (!this.animate) {
                rect.left -= this.getBubbleWith() / 2.0f - this.getThumbWidth() / 2.0f;
                rect.right = rect.left + this.getBubbleWith();
                rect.top = this.getRightThumbRect().top - (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
                rect.bottom = this.getRightThumbRect().bottom + (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
            } else {
                rect.left = this.thumbPressedRect.left;
                rect.right = this.thumbPressedRect.right;
                rect.top = this.thumbPressedRect.top;
                rect.bottom = this.thumbPressedRect.bottom;
            }
            canvas.drawOval(rect, paint);
        } else {
            canvas.drawOval(rect, paint);
        }
    }

    @Override
    protected void drawLeftThumbWithImage(Canvas canvas, Paint paint, RectF rect, Bitmap image) {
        if (this.isPressedLeftThumb) {
            if (!this.animate) {
                image = this.resizeImage((int)this.getBubbleWith(), (int)this.getBubbleHeight(), image);
                rect.top = this.getLeftThumbRect().top - (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
                rect.left -= this.getBubbleWith() / 2.0f - this.getThumbWidth() / 2.0f;
            } else {
                image = this.resizeImage((int)this.thumbPressedRect.imageWith, (int)this.thumbPressedRect.imageHeight, image);
                rect.top = this.thumbPressedRect.top;
                rect.left = this.thumbPressedRect.left;
            }
            canvas.drawBitmap(image, rect.left, rect.top, paint);
        } else {
            canvas.drawBitmap(image, rect.left, rect.top, paint);
        }
    }

    @Override
    protected void drawRightThumbWithImage(Canvas canvas, Paint paint, RectF rect, Bitmap image) {
        if (this.isPressedRightThumb) {
            if (!this.animate) {
                image = this.resizeImage((int)this.getBubbleWith(), (int)this.getBubbleHeight(), image);
                rect.top = this.getRightThumbRect().top - (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
                rect.left -= this.getBubbleWith() / 2.0f - this.getThumbWidth() / 2.0f;
            } else {
                image = this.resizeImage((int)this.thumbPressedRect.imageWith, (int)this.thumbPressedRect.imageHeight, image);
                rect.top = this.thumbPressedRect.top;
                rect.left = this.thumbPressedRect.left;
            }
            canvas.drawBitmap(image, rect.left, rect.top, paint);
        } else {
            canvas.drawBitmap(image, rect.left, rect.top, paint);
        }
    }

    protected float getBubbleWith() {
        return this.getResources().getDimension(R.dimen.bubble_thumb_width);
    }

    protected float getBubbleHeight() {
        return this.getResources().getDimension(R.dimen.bubble_thumb_height);
    }

    protected void startAnimationUp(CrystalRangeSeekbar.Thumb thumb) {
        BubbleRect toRect = new BubbleRect();
        RectF fromRect = CrystalRangeSeekbar.Thumb.MIN.equals((Object)thumb) ? this.getLeftThumbRect() : this.getRightThumbRect();
        toRect.left = fromRect.left - (this.getBubbleWith() / 2.0f - this.getThumbWidth() / 2.0f);
        toRect.right = toRect.left + this.getBubbleWith();
        toRect.top = fromRect.top - (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
        toRect.bottom = fromRect.bottom + (this.getBubbleHeight() / 2.0f - this.getThumbHeight() / 2.0f);
        PropertyValuesHolder leftValueHolder = PropertyValuesHolder.ofFloat((String)"left", (float[])new float[]{fromRect.left, toRect.left});
        PropertyValuesHolder rightValueHolder = PropertyValuesHolder.ofFloat((String)"right", (float[])new float[]{fromRect.right, toRect.right});
        PropertyValuesHolder topValueHolder = PropertyValuesHolder.ofFloat((String)"top", (float[])new float[]{fromRect.top, toRect.top});
        PropertyValuesHolder bottomValueHolder = PropertyValuesHolder.ofFloat((String)"bottom", (float[])new float[]{fromRect.bottom, toRect.bottom});
        PropertyValuesHolder imageWithValueHolder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.getThumbWidth(), this.getBubbleWith()});
        PropertyValuesHolder imageHeightValueHolder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.getThumbHeight(), this.getBubbleHeight()});
        ValueAnimator animation = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{leftValueHolder, rightValueHolder, topValueHolder, bottomValueHolder, imageWithValueHolder, imageHeightValueHolder});
        animation.setDuration(200L);
        animation.setInterpolator((TimeInterpolator)new OvershootInterpolator(5.0f));
        animation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.left = ((Float)animation.getAnimatedValue("left")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.right = ((Float)animation.getAnimatedValue("right")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.top = ((Float)animation.getAnimatedValue("top")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.bottom = ((Float)animation.getAnimatedValue("bottom")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.imageWith = ((Float)animation.getAnimatedValue("width")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.imageHeight = ((Float)animation.getAnimatedValue("height")).floatValue();
                BubbleThumbRangeSeekbar.this.invalidate();
            }
        });
        animation.start();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                BubbleThumbRangeSeekbar.this.animate = false;
            }
        }, 200L);
    }

    protected void startAnimationDown(CrystalRangeSeekbar.Thumb thumb) {
        RectF toRect = new RectF();
        RectF fromRect = CrystalRangeSeekbar.Thumb.MIN.equals((Object)thumb) ? this.getLeftThumbRect() : this.getRightThumbRect();
        toRect.left = fromRect.left + (this.getBubbleWith() / 2.0f - this.getThumbWidth() / 2.0f);
        toRect.right = toRect.left + this.getThumbWidth();
        toRect.top = 0.0f;
        toRect.bottom = this.getThumbHeight();
        PropertyValuesHolder leftValueHolder = PropertyValuesHolder.ofFloat((String)"left", (float[])new float[]{fromRect.left, toRect.left});
        PropertyValuesHolder rightValueHolder = PropertyValuesHolder.ofFloat((String)"right", (float[])new float[]{fromRect.right, toRect.right});
        PropertyValuesHolder topValueHolder = PropertyValuesHolder.ofFloat((String)"top", (float[])new float[]{fromRect.top, toRect.top});
        PropertyValuesHolder bottomValueHolder = PropertyValuesHolder.ofFloat((String)"bottom", (float[])new float[]{fromRect.bottom, toRect.bottom});
        PropertyValuesHolder imageWithValueHolder = PropertyValuesHolder.ofFloat((String)"width", (float[])new float[]{this.getBubbleWith(), this.getThumbWidth()});
        PropertyValuesHolder imageHeightValueHolder = PropertyValuesHolder.ofFloat((String)"height", (float[])new float[]{this.getBubbleHeight(), this.getThumbHeight()});
        ValueAnimator animation = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{leftValueHolder, rightValueHolder, topValueHolder, bottomValueHolder, imageWithValueHolder, imageHeightValueHolder});
        animation.setDuration(300L);
        animation.setInterpolator((TimeInterpolator)new OvershootInterpolator(3.0f));
        animation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.left = ((Float)animation.getAnimatedValue("left")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.right = ((Float)animation.getAnimatedValue("right")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.top = ((Float)animation.getAnimatedValue("top")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.bottom = ((Float)animation.getAnimatedValue("bottom")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.imageWith = ((Float)animation.getAnimatedValue("width")).floatValue();
                ((BubbleThumbRangeSeekbar)BubbleThumbRangeSeekbar.this).thumbPressedRect.imageHeight = ((Float)animation.getAnimatedValue("height")).floatValue();
                BubbleThumbRangeSeekbar.this.invalidate();
            }
        });
        animation.start();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                BubbleThumbRangeSeekbar.this.animate = false;
                BubbleThumbRangeSeekbar.this.isPressedLeftThumb = false;
                BubbleThumbRangeSeekbar.this.isPressedRightThumb = false;
            }
        }, 300L);
    }

    private Bitmap resizeImage(int iconWidth, int iconHeight, Bitmap bmp) {
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        float scaleWidth = (float)iconWidth / (float)width;
        float scaleHeight = (float)iconHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    private class BubbleRect {
        public float left;
        public float right;
        public float top;
        public float bottom;
        public float imageWith;
        public float imageHeight;

        private BubbleRect() {
        }
    }
}

