/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.ui;

import Jni.FFmpegCmd;
import VideoHandle.OnEditorListener;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.crystal.crystalrangeseekbar.interfaces.OnSeekbarFinalValueListener;
import com.crystal.crystalrangeseekbar.widgets.CrystalRangeSeekbar;
import com.crystal.crystalrangeseekbar.widgets.CrystalSeekbar;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.gowtham.library.R;
import com.gowtham.library.utils.CustomProgressView;
import com.gowtham.library.utils.FileUtils;
import com.gowtham.library.utils.LogMessage;
import com.gowtham.library.utils.TrimVideoOptions;
import com.gowtham.library.utils.TrimmerUtils;
import java.io.File;

public class ActVideoTrimmer
extends AppCompatActivity {
    private PlayerView playerView;
    private static final int PER_REQ_CODE = 115;
    private SimpleExoPlayer videoPlayer;
    private ImageView imagePlayPause;
    private ImageView[] imageViews;
    private long totalDuration;
    private Uri uri;
    private TextView txtStartDuration;
    private TextView txtEndDuration;
    private CrystalRangeSeekbar seekbar;
    private long lastMinValue = 0L;
    private long lastMaxValue = 0L;
    private long totalVideoDuration;
    private MenuItem menuDone;
    private CrystalSeekbar seekbarController;
    private boolean isValidVideo = true;
    private boolean isVideoEnded;
    private Handler seekHandler;
    private long currentDuration;
    private String outputPath;
    private String destinationPath;
    private int trimType;
    private long fixedGap;
    private long minGap;
    private long minFromGap;
    private long maxToGap;
    private boolean hidePlayerSeek;
    private boolean isAccurateCut;
    private CustomProgressView progressView;
    Runnable updateSeekbar = new Runnable(){

        @Override
        public void run() {
            try {
                ActVideoTrimmer.this.currentDuration = ActVideoTrimmer.this.videoPlayer.getCurrentPosition() / 1000L;
                if (!ActVideoTrimmer.this.videoPlayer.getPlayWhenReady()) {
                    return;
                }
                if (ActVideoTrimmer.this.currentDuration <= ActVideoTrimmer.this.lastMaxValue) {
                    ActVideoTrimmer.this.seekbarController.setMinStartValue((float)((int)ActVideoTrimmer.this.currentDuration)).apply();
                } else {
                    ActVideoTrimmer.this.videoPlayer.setPlayWhenReady(false);
                }
            }
            finally {
                ActVideoTrimmer.this.seekHandler.postDelayed(ActVideoTrimmer.this.updateSeekbar, 1000L);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.act_video_trimmer);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.setUpToolBar(this.getSupportActionBar(), "Edit Video");
        toolbar.setNavigationOnClickListener(v -> this.finish());
        this.progressView = new CustomProgressView((Context)this);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.playerView = (PlayerView)this.findViewById(R.id.player_view_lib);
        this.imagePlayPause = (ImageView)this.findViewById(R.id.image_play_pause);
        this.seekbar = (CrystalRangeSeekbar)this.findViewById(R.id.range_seek_bar);
        this.txtStartDuration = (TextView)this.findViewById(R.id.txt_start_duration);
        this.txtEndDuration = (TextView)this.findViewById(R.id.txt_end_duration);
        this.seekbarController = (CrystalSeekbar)this.findViewById(R.id.seekbar_controller);
        ImageView imageOne = (ImageView)this.findViewById(R.id.image_one);
        ImageView imageTwo = (ImageView)this.findViewById(R.id.image_two);
        ImageView imageThree = (ImageView)this.findViewById(R.id.image_three);
        ImageView imageFour = (ImageView)this.findViewById(R.id.image_four);
        ImageView imageFive = (ImageView)this.findViewById(R.id.image_five);
        ImageView imageSix = (ImageView)this.findViewById(R.id.image_six);
        ImageView imageSeven = (ImageView)this.findViewById(R.id.image_seven);
        ImageView imageEight = (ImageView)this.findViewById(R.id.image_eight);
        this.imageViews = new ImageView[]{imageOne, imageTwo, imageThree, imageFour, imageFive, imageSix, imageSeven, imageEight};
        this.seekHandler = new Handler();
        this.initPlayer();
        if (this.checkStoragePermission()) {
            this.setDataInView();
        }
    }

    private void setUpToolBar(ActionBar actionBar, String title) {
        try {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
            actionBar.setTitle((CharSequence)title);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initPlayer() {
        try {
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
            DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter));
            this.videoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this, (TrackSelector)trackSelector);
            this.playerView.requestFocus();
            this.playerView.setResizeMode(0);
            this.playerView.setPlayer((Player)this.videoPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDataInView() {
        try {
            this.uri = Uri.parse((String)this.getIntent().getStringExtra("trim_video_uri"));
            this.uri = Uri.parse((String)FileUtils.getPath((Context)this, this.uri));
            LogMessage.v("VideoUri:: " + this.uri);
            this.totalDuration = TrimmerUtils.getDuration((Activity)this, this.uri);
            this.imagePlayPause.setOnClickListener(v -> this.onVideoClicked());
            this.playerView.getVideoSurfaceView().setOnClickListener(v -> this.onVideoClicked());
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validate() {
        try {
            TrimVideoOptions trimVideoOptions = (TrimVideoOptions)this.getIntent().getParcelableExtra("trim_video_option");
            assert (trimVideoOptions != null);
            this.trimType = TrimmerUtils.getTrimType(trimVideoOptions.trimType);
            this.destinationPath = trimVideoOptions.destination;
            this.hidePlayerSeek = trimVideoOptions.hideSeekBar;
            this.isAccurateCut = trimVideoOptions.accurateCut;
            this.fixedGap = trimVideoOptions.fixedDuration;
            this.fixedGap = this.fixedGap != 0L ? this.fixedGap : this.totalDuration;
            this.minGap = trimVideoOptions.minDuration;
            long l = this.minGap = this.minGap != 0L ? this.minGap : this.totalDuration;
            if (this.trimType == 3) {
                this.minFromGap = trimVideoOptions.minToMax[0];
                this.maxToGap = trimVideoOptions.minToMax[1];
                this.minFromGap = this.minFromGap != 0L ? this.minFromGap : this.totalDuration;
                long l2 = this.maxToGap = this.maxToGap != 0L ? this.maxToGap : this.totalDuration;
            }
            if (this.destinationPath != null) {
                File outputDir = new File(this.destinationPath);
                outputDir.mkdirs();
                this.destinationPath = String.valueOf(outputDir);
                if (!outputDir.isDirectory()) {
                    throw new IllegalArgumentException("Destination file path error " + this.destinationPath);
                }
            }
            this.buildMediaSource(this.uri);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private void onVideoClicked() {
        try {
            if (this.isVideoEnded) {
                this.seekTo(this.lastMinValue);
                this.videoPlayer.setPlayWhenReady(true);
                return;
            }
            if (this.currentDuration - this.lastMaxValue > 0L) {
                this.seekTo(this.lastMinValue);
            }
            this.videoPlayer.setPlayWhenReady(!this.videoPlayer.getPlayWhenReady());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void seekTo(long sec) {
        if (this.videoPlayer != null) {
            this.videoPlayer.seekTo(sec * 1000L);
        }
    }

    private void buildMediaSource(Uri mUri) {
        try {
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
            DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory((Context)this, Util.getUserAgent((Context)this, (String)this.getString(R.string.app_name)), (TransferListener)bandwidthMeter);
            ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(mUri);
            this.videoPlayer.prepare((MediaSource)videoSource);
            this.videoPlayer.setPlayWhenReady(true);
            this.videoPlayer.addListener((Player.EventListener)new Player.DefaultEventListener(){

                public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                    switch (playbackState) {
                        case 2: {
                            LogMessage.v("onPlayerStateChanged: Buffering video.");
                            break;
                        }
                        case 4: {
                            LogMessage.v("onPlayerStateChanged: Video ended.");
                            ActVideoTrimmer.this.imagePlayPause.setVisibility(0);
                            ActVideoTrimmer.this.isVideoEnded = true;
                            break;
                        }
                        case 1: {
                            LogMessage.v("onPlayerStateChanged: Player.STATE_IDLE");
                            break;
                        }
                        case 3: {
                            ActVideoTrimmer.this.isVideoEnded = false;
                            ActVideoTrimmer.this.totalVideoDuration = ActVideoTrimmer.this.videoPlayer.getDuration() / 1000L;
                            ActVideoTrimmer.this.startProgress();
                            ActVideoTrimmer.this.imagePlayPause.setVisibility(ActVideoTrimmer.this.videoPlayer.getPlayWhenReady() ? 8 : 0);
                            LogMessage.v("onPlayerStateChanged: Ready to play.");
                            break;
                        }
                    }
                }
            });
            this.setImageBitmaps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setImageBitmaps() {
        try {
            long diff = this.totalDuration / 8L;
            new Handler().postDelayed(() -> {
                int index = 1;
                for (ImageView img : this.imageViews) {
                    img.setImageBitmap(TrimmerUtils.getFrameBySec((Activity)this, this.uri, diff * (long)index));
                    ++index;
                }
                this.seekbar.setVisibility(0);
                this.txtStartDuration.setVisibility(0);
                this.txtEndDuration.setVisibility(0);
            }, 1000L);
            this.seekbarController.setMaxValue((float)this.totalDuration).apply();
            this.seekbar.setMaxValue((float)this.totalDuration).apply();
            this.seekbar.setMaxStartValue((float)this.totalDuration).apply();
            if (this.trimType == 1) {
                this.seekbar.setFixGap((float)this.fixedGap).apply();
                this.lastMaxValue = this.totalDuration;
            } else if (this.trimType == 2) {
                this.seekbar.setMaxStartValue((float)this.minGap);
                this.seekbar.setGap((float)this.minGap).apply();
                this.lastMaxValue = this.totalDuration;
            } else if (this.trimType == 3) {
                this.seekbar.setMaxStartValue((float)this.maxToGap);
                this.seekbar.setGap((float)this.minFromGap).apply();
                this.lastMaxValue = this.maxToGap;
            } else {
                this.seekbar.setGap(2.0f).apply();
                this.lastMaxValue = this.totalDuration;
            }
            if (this.hidePlayerSeek) {
                this.seekbarController.setVisibility(8);
            }
            this.seekbar.setOnRangeSeekbarChangeListener((minValue, maxValue) -> {
                long minVal = (Long)minValue;
                long maxVal = (Long)maxValue;
                if (this.lastMinValue != minVal) {
                    this.seekTo((Long)minValue);
                }
                this.lastMinValue = minVal;
                this.lastMaxValue = maxVal;
                this.txtStartDuration.setText((CharSequence)TrimmerUtils.formatSeconds(minVal));
                this.txtEndDuration.setText((CharSequence)TrimmerUtils.formatSeconds(maxVal));
                if (this.trimType == 3) {
                    this.setDoneColor(minVal, maxVal);
                }
            });
            this.seekbarController.setOnSeekbarFinalValueListener(new OnSeekbarFinalValueListener(){

                public void finalValue(Number value) {
                    long value1 = (Long)value;
                    if (value1 < ActVideoTrimmer.this.lastMaxValue && value1 > ActVideoTrimmer.this.lastMinValue) {
                        ActVideoTrimmer.this.seekTo(value1);
                        return;
                    }
                    if (value1 > ActVideoTrimmer.this.lastMaxValue) {
                        ActVideoTrimmer.this.seekbarController.setMinStartValue((float)((int)ActVideoTrimmer.this.lastMaxValue)).apply();
                    } else if (value1 < ActVideoTrimmer.this.lastMinValue) {
                        ActVideoTrimmer.this.seekbarController.setMinStartValue((float)((int)ActVideoTrimmer.this.lastMinValue)).apply();
                        if (ActVideoTrimmer.this.videoPlayer.getPlayWhenReady()) {
                            ActVideoTrimmer.this.seekTo(ActVideoTrimmer.this.lastMinValue);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDoneColor(long minVal, long maxVal) {
        try {
            if (this.menuDone == null) {
                return;
            }
            if (maxVal - minVal <= this.maxToGap) {
                this.menuDone.getIcon().setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorWhite), PorterDuff.Mode.SRC_IN));
                this.isValidVideo = true;
            } else {
                this.menuDone.getIcon().setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorWhiteLt), PorterDuff.Mode.SRC_IN));
                this.isValidVideo = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 115) {
            if (this.isPermissionOk(grantResults)) {
                this.setDataInView();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Storage permission denied", (int)0).show();
                this.finish();
            }
        }
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.videoPlayer.setPlayWhenReady(false);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.videoPlayer != null) {
            this.videoPlayer.release();
        }
        if (this.progressView != null && this.progressView.isShowing()) {
            this.progressView.dismiss();
        }
        this.stopRepeatingTask();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        this.menuDone = menu2.findItem(R.id.action_done);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_done) {
            this.validateVideo();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void validateVideo() {
        if (this.isValidVideo) {
            String path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS) + "";
            if (this.destinationPath != null) {
                path = this.destinationPath;
            }
            int fileNo = 0;
            String fileName = "trimmed_video_";
            File newFile = new File(path + File.separator + fileName + fileNo + "." + TrimmerUtils.getFileExtension((Context)this, this.uri));
            while (newFile.exists()) {
                newFile = new File(path + File.separator + fileName + ++fileNo + "." + TrimmerUtils.getFileExtension((Context)this, this.uri));
            }
            this.outputPath = String.valueOf(newFile);
            LogMessage.v("outputPath::" + this.outputPath);
            this.videoPlayer.setPlayWhenReady(false);
            this.progressView.show();
            String[] complexCommand = this.isAccurateCut ? new String[]{"ffmpeg", "-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.uri), "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), "-async", "1", this.outputPath} : new String[]{"ffmpeg", "-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.uri), "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), "-async", "1", "-strict", "-2", "-c", "copy", this.outputPath};
            FFmpegCmd.exec((String[])complexCommand, (long)0L, (OnEditorListener)new OnEditorListener(){

                public void onSuccess() {
                    ActVideoTrimmer.this.progressView.dismiss();
                    Intent intent = new Intent();
                    intent.putExtra("trimmed_video_path", ActVideoTrimmer.this.outputPath);
                    ActVideoTrimmer.this.setResult(-1, intent);
                    ActVideoTrimmer.this.finish();
                }

                public void onFailure() {
                    if (ActVideoTrimmer.this.progressView.isShowing()) {
                        ActVideoTrimmer.this.progressView.dismiss();
                    }
                    ActVideoTrimmer.this.runOnUiThread(() -> Toast.makeText((Context)ActVideoTrimmer.this, (CharSequence)"Failed to trim", (int)0).show());
                }

                public void onProgress(float progress) {
                    LogMessage.v("Progress::" + progress + "%");
                }
            });
        } else {
            Toast.makeText((Context)this, (CharSequence)(this.getString(R.string.txt_smaller) + " " + TrimmerUtils.getLimitedTimeFormatted(this.maxToGap)), (int)0).show();
        }
    }

    private boolean checkStoragePermission() {
        if (Build.VERSION.SDK_INT >= 29) {
            return this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.ACCESS_MEDIA_LOCATION");
        }
        return this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE");
    }

    private boolean checkPermission(String ... permissions) {
        boolean allPermitted = false;
        for (String permission2 : permissions) {
            boolean bl = allPermitted = ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
            if (!allPermitted) break;
        }
        if (allPermitted) {
            return true;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)115);
        return false;
    }

    private boolean isPermissionOk(int ... results) {
        boolean isAllGranted = true;
        for (int result : results) {
            if (0 == result) continue;
            isAllGranted = false;
            break;
        }
        return isAllGranted;
    }

    void startProgress() {
        this.updateSeekbar.run();
    }

    void stopRepeatingTask() {
        this.seekHandler.removeCallbacks(this.updateSeekbar);
    }
}

