/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import androidx.core.content.ContextCompat;
import com.gowtham.library.utils.FileUtils;
import com.gowtham.library.utils.LogMessage;
import java.io.File;

public class TrimmerUtils {
    public static String formatCSeconds(long timeInSeconds) {
        long hours = timeInSeconds / 3600L;
        long secondsLeft = timeInSeconds - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String formattedTime = "";
        if (hours < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + hours + ":";
        if (minutes < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + minutes + ":";
        if (seconds < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + seconds;
        return formattedTime;
    }

    public static int getColor(Context context, int color) {
        return ContextCompat.getColor((Context)context, (int)color);
    }

    public static long getDuration(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            String time = retriever.extractMetadata(9);
            long timeInMillisec = Long.parseLong(time);
            retriever.release();
            return timeInMillisec / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getVideoDuration(Activity context, Uri videoUri) {
        try {
            String videoPath = FileUtils.getPath((Context)context, videoUri);
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, Uri.parse((String)videoPath));
            String time = retriever.extractMetadata(9);
            long timeInMillisec = Long.parseLong(time);
            retriever.release();
            return timeInMillisec / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getFileExtension(Context context, Uri uri) {
        try {
            String extension;
            if (uri.getScheme() != null && uri.getScheme().equals("content")) {
                MimeTypeMap mime = MimeTypeMap.getSingleton();
                extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
            } else {
                extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            }
            return extension == null || extension.isEmpty() ? ".mp4" : extension;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "mp4";
        }
    }

    public static Bitmap getFrameBySec(Activity context, Uri videoPath, long millies) {
        try {
            String formatted = millies + "000000";
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            Bitmap bitmap = retriever.getFrameAtTime(Long.parseLong(formatted));
            retriever.release();
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getFrameRate(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            int frameRate = Integer.parseInt(retriever.extractMetadata(32));
            retriever.release();
            return frameRate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 30;
        }
    }

    public static int getBitRate(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            int bitRate = Integer.parseInt(retriever.extractMetadata(20));
            retriever.release();
            return bitRate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 15;
        }
    }

    public static int[] getVideoWidthHeight(Activity context, Uri videoPath) {
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource((Context)context, videoPath);
            int width = Integer.parseInt(retriever.extractMetadata(18));
            int height = Integer.parseInt(retriever.extractMetadata(19));
            retriever.release();
            return new int[]{width, height};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatSeconds(long timeInSeconds) {
        long hours = timeInSeconds / 3600L;
        long secondsLeft = timeInSeconds - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String formattedTime = "";
        if (hours < 10L && hours != 0L) {
            formattedTime = formattedTime + "0";
            formattedTime = formattedTime + hours + ":";
        }
        if (minutes < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + minutes + ":";
        if (seconds < 10L) {
            formattedTime = formattedTime + "0";
        }
        formattedTime = formattedTime + seconds;
        return formattedTime;
    }

    public static String getLimitedTimeFormatted(long secs) {
        long hours = secs / 3600L;
        long secondsLeft = secs - hours * 3600L;
        long minutes = secondsLeft / 60L;
        long seconds = secondsLeft - minutes * 60L;
        String time = hours != 0L ? hours + " Hrs " + (minutes != 0L ? minutes + " Mins " : "") + (seconds != 0L ? seconds + " Secs " : "") : (minutes != 0L ? minutes + " Mins " + (seconds != 0L ? seconds + " Secs " : "") : seconds + " Secs ");
        LogMessage.v(time);
        return time;
    }
}

