/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat = Build.VERSION.SDK_INT >= 19;
        String selection = null;
        String[] selectionArgs = null;
        if (isKitKat) {
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                String fullPath = FileUtils.getPathFromExtSD(split);
                if (fullPath != "") {
                    return fullPath;
                }
                return null;
            }
            if (FileUtils.isDownloadsDocument(uri)) {
                String id;
                if (Build.VERSION.SDK_INT >= 23) {
                    String[] path;
                    try (Cursor cursor = null;){
                        cursor = context.getContentResolver().query(uri, new String[]{"_display_name"}, null, null, null);
                        if (cursor != null && cursor.moveToFirst()) {
                            String fileName = cursor.getString(0);
                            path = Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName;
                            if (!TextUtils.isEmpty((CharSequence)path)) {
                                String[] stringArray = path;
                                return stringArray;
                            }
                        }
                    }
                    id = DocumentsContract.getDocumentId((Uri)uri);
                    if (!TextUtils.isEmpty((CharSequence)id)) {
                        if (id.startsWith("raw:")) {
                            return id.replaceFirst("raw:", "");
                        }
                        int n = 0;
                        String[] contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads"};
                        path = contentUriPrefixesToTry;
                        int n2 = path.length;
                        if (n < n2) {
                            String contentUriPrefix = path[n];
                            try {
                                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)contentUriPrefix), (long)Long.valueOf(id));
                                return FileUtils.getDataColumn(context, contentUri, null, null);
                            }
                            catch (NumberFormatException e) {
                                return uri.getPath().replaceFirst("^/document/raw:", "").replaceFirst("^raw:", "");
                            }
                        }
                    }
                } else {
                    id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = null;
                    if (id.startsWith("raw:")) {
                        return id.replaceFirst("raw:", "");
                    }
                    try {
                        contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    if (contentUri != null) {
                        return FileUtils.getDataColumn(context, contentUri, null, null);
                    }
                }
            }
            if (FileUtils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                selection = "_id=?";
                selectionArgs = new String[]{split[1]};
                return FileUtils.getDataColumn(context, contentUri, selection, selectionArgs);
            }
            if (FileUtils.isGoogleDriveUri(uri)) {
                return FileUtils.getDriveFilePath(context, uri);
            }
            if (FileUtils.isWhatsAppFile(uri)) {
                return FileUtils.getFilePathForWhatsApp(context, uri);
            }
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                if (FileUtils.isGoogleDriveUri(uri)) {
                    return FileUtils.getDriveFilePath(context, uri);
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    return FileUtils.copyFileToInternalStorage(context, uri, "userfiles");
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        } else {
            if (FileUtils.isWhatsAppFile(uri)) {
                return FileUtils.getFilePathForWhatsApp(context, uri);
            }
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                String[] projection = new String[]{"_data"};
                Cursor cursor = null;
                try {
                    cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                    int column_index = cursor.getColumnIndexOrThrow("_data");
                    if (cursor.moveToFirst()) {
                        return cursor.getString(column_index);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static boolean fileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    private static String getPathFromExtSD(String[] pathData) {
        String type = pathData[0];
        String relativePath = "/" + pathData[1];
        String fullPath = "";
        if ("primary".equalsIgnoreCase(type) && FileUtils.fileExists(fullPath = Environment.getExternalStorageDirectory() + relativePath)) {
            return fullPath;
        }
        fullPath = System.getenv("SECONDARY_STORAGE") + relativePath;
        if (FileUtils.fileExists(fullPath)) {
            return fullPath;
        }
        fullPath = System.getenv("EXTERNAL_STORAGE") + relativePath;
        if (FileUtils.fileExists(fullPath)) {
            return fullPath;
        }
        return fullPath;
    }

    private static String getDriveFilePath(Context context, Uri uri) {
        Uri returnUri = uri;
        Cursor returnCursor = context.getContentResolver().query(returnUri, null, null, null, null);
        int nameIndex = returnCursor.getColumnIndex("_display_name");
        int sizeIndex = returnCursor.getColumnIndex("_size");
        returnCursor.moveToFirst();
        String name = returnCursor.getString(nameIndex);
        String size = Long.toString(returnCursor.getLong(sizeIndex));
        File file = new File(context.getCacheDir(), name);
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            int read = 0;
            int maxBufferSize = 0x100000;
            int bytesAvailable = inputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffers = new byte[bufferSize];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            Log.e((String)"File Size", (String)("Size " + file.length()));
            inputStream.close();
            outputStream.close();
            Log.e((String)"File Path", (String)("Path " + file.getPath()));
            Log.e((String)"File Size", (String)("Size " + file.length()));
        }
        catch (Exception e) {
            Log.e((String)"Exception", (String)e.getMessage());
        }
        return file.getPath();
    }

    private static String copyFileToInternalStorage(Context context, Uri uri, String newDirName) {
        File output;
        Uri returnUri = uri;
        Cursor returnCursor = context.getContentResolver().query(returnUri, new String[]{"_display_name", "_size"}, null, null, null);
        int nameIndex = returnCursor.getColumnIndex("_display_name");
        int sizeIndex = returnCursor.getColumnIndex("_size");
        returnCursor.moveToFirst();
        String name = returnCursor.getString(nameIndex);
        String size = Long.toString(returnCursor.getLong(sizeIndex));
        if (!newDirName.equals("")) {
            File dir = new File(context.getFilesDir() + "/" + newDirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            output = new File(context.getFilesDir() + "/" + newDirName + "/" + name);
        } else {
            output = new File(context.getFilesDir() + "/" + name);
        }
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(output);
            int read = 0;
            int bufferSize = 1024;
            byte[] buffers = new byte[bufferSize];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (Exception e) {
            Log.e((String)"Exception", (String)e.getMessage());
        }
        return output.getPath();
    }

    private static String getFilePathForWhatsApp(Context context, Uri uri) {
        return FileUtils.copyFileToInternalStorage(context, uri, "whatsapp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isWhatsAppFile(Uri uri) {
        return "com.whatsapp.provider.media".equals(uri.getAuthority());
    }

    private static boolean isGoogleDriveUri(Uri uri) {
        return "com.google.android.apps.docs.storage".equals(uri.getAuthority()) || "com.google.android.apps.docs.storage.legacy".equals(uri.getAuthority());
    }
}

