/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator.changehandlers;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.zhuinden.simplestack.navigator.ViewChangeHandler;
import com.zhuinden.simplestack.navigator.changehandlers.ViewUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TargetApi(value=11)
public abstract class AnimatorViewChangeHandler
implements ViewChangeHandler {
    private Long startDelay = null;
    private Interpolator interpolator = null;
    private Long duration = null;

    @Override
    public void performViewChange(final @Nonnull ViewGroup container, final @Nonnull View previousView, final @Nonnull View newView, final int direction, final @Nonnull ViewChangeHandler.ViewChangeCallback viewChangeCallback) {
        container.addView(newView);
        ViewUtils.waitForMeasure(newView, new ViewUtils.OnMeasuredCallback(){

            @Override
            public void onMeasured(View view, int width, int height) {
                AnimatorViewChangeHandler.this.runAnimation(previousView, newView, direction, new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        container.removeView(previousView);
                        AnimatorViewChangeHandler.this.resetPreviousViewValues(previousView);
                        viewChangeCallback.onCompleted();
                    }
                });
            }
        });
    }

    private void runAnimation(View previousView, View newView, int direction, AnimatorListenerAdapter animatorListenerAdapter) {
        Animator animator = this.createAnimator(previousView, newView, direction);
        animator.addListener((Animator.AnimatorListener)animatorListenerAdapter);
        if (this.duration != null) {
            animator.setDuration(this.duration.longValue());
        }
        if (this.interpolator != null) {
            animator.setInterpolator((TimeInterpolator)this.interpolator);
        }
        if (this.startDelay != null) {
            animator.setStartDelay(this.startDelay.longValue());
        }
        animator.start();
    }

    protected abstract Animator createAnimator(@Nonnull View var1, @Nonnull View var2, int var3);

    @Nullable
    public Long getStartDelay() {
        return this.startDelay;
    }

    public AnimatorViewChangeHandler setStartDelay(@Nullable Long startDelay) {
        this.startDelay = startDelay;
        return this;
    }

    @Nullable
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public AnimatorViewChangeHandler setInterpolator(@Nullable Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    @Nullable
    public Long getDuration() {
        return this.duration;
    }

    public AnimatorViewChangeHandler setDuration(@Nullable Long duration) {
        this.duration = duration;
        return this;
    }

    protected void resetPreviousViewValues(View previousView) {
    }
}

