/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import javax.annotation.Nonnull;

public class SimpleStateChanger
implements StateChanger {
    private final NavigationHandler navigationHandler;

    public SimpleStateChanger(@Nonnull NavigationHandler navigationHandler) {
        if (navigationHandler == null) {
            throw new NullPointerException("navigationHandler should not be null!");
        }
        this.navigationHandler = navigationHandler;
    }

    @Override
    public void handleStateChange(@Nonnull StateChange stateChange, @Nonnull StateChanger.Callback completionCallback) {
        if (stateChange.isTopNewKeyEqualToPrevious()) {
            completionCallback.stateChangeComplete();
            return;
        }
        this.navigationHandler.onNavigationEvent(stateChange);
        completionCallback.stateChangeComplete();
    }

    public static interface NavigationHandler {
        public void onNavigationEvent(@Nonnull StateChange var1);
    }
}

