/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import com.zhuinden.simplestack.AheadOfTimeBackCallbackRegistry;
import com.zhuinden.simplestack.BackHandlingModel;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeManager;
import com.zhuinden.simplestack.ScopeNode;
import javax.annotation.Nonnull;

public class ServiceBinder {
    private final ScopeManager scopeManager;
    private final Backstack backstack;
    private final Object key;
    private final String scopeTag;
    private final ScopeNode scope;
    private final AheadOfTimeBackCallbackRegistry aheadOfTimeBackCallbackRegistry;

    ServiceBinder(ScopeManager scopeManager, Object key, String scopeTag, ScopeNode scope, AheadOfTimeBackCallbackRegistry aheadOfTimeBackCallbackRegistry) {
        this.scopeManager = scopeManager;
        this.backstack = scopeManager.getBackstack();
        this.key = key;
        this.scopeTag = scopeTag;
        this.scope = scope;
        this.aheadOfTimeBackCallbackRegistry = aheadOfTimeBackCallbackRegistry;
    }

    @Nonnull
    public AheadOfTimeBackCallbackRegistry getAheadOfTimeBackCallbackRegistry() {
        if (this.backstack.getBackHandlingModel() != BackHandlingModel.AHEAD_OF_TIME) {
            throw new IllegalStateException("Using the ahead-of-time back callback registry is only allowed in AHEAD_OF_TIME back handling mode.");
        }
        return this.aheadOfTimeBackCallbackRegistry;
    }

    @Nonnull
    public <T> T getKey() {
        return (T)this.key;
    }

    @Nonnull
    public final String getScopeTag() {
        return this.scopeTag;
    }

    public void addService(@Nonnull String serviceTag, @Nonnull Object service) {
        this.scope.addService(serviceTag, service);
    }

    public boolean hasService(@Nonnull String serviceTag) {
        return this.scope.hasService(serviceTag);
    }

    @Nonnull
    public <T> T getService(@Nonnull String serviceTag) {
        return this.scope.getService(serviceTag);
    }

    public void addAlias(@Nonnull String alias, @Nonnull Object service) {
        this.scope.addAlias(alias, service);
    }

    public boolean canFindService(@Nonnull String serviceTag) {
        return this.scopeManager.canFindService(serviceTag);
    }

    @Nonnull
    public <T> T lookupService(@Nonnull String serviceTag) {
        return this.scopeManager.lookupService(serviceTag);
    }

    public boolean canFindFromScope(String scopeTag, String serviceTag) {
        return this.scopeManager.canFindFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    @Nonnull
    public <T> T lookupFromScope(String scopeTag, String serviceTag) {
        return this.scopeManager.lookupFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
    }

    @Nonnull
    public Backstack getBackstack() {
        return this.backstack;
    }
}

