/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

class ScopeNode {
    private final Map<String, Object> services = new LinkedHashMap<String, Object>();
    private final Map<String, Object> aliases = new LinkedHashMap<String, Object>();

    ScopeNode() {
    }

    ScopeNode(@Nonnull ScopeNode services) {
        if (services == null) {
            throw new IllegalArgumentException("services cannot be null!");
        }
        this.services.putAll(services.services);
        this.aliases.putAll(services.aliases);
    }

    public boolean isEmpty() {
        return this.services.isEmpty();
    }

    public void addService(@Nonnull String serviceTag, @Nonnull Object service) {
        ScopeNode.checkServiceTag(serviceTag);
        ScopeNode.checkService(service);
        this.services.put(serviceTag, service);
    }

    public boolean hasService(@Nonnull String serviceTag) {
        ScopeNode.checkServiceTag(serviceTag);
        if (this.services.containsKey(serviceTag)) {
            return true;
        }
        ScopeNode.checkAlias(serviceTag);
        return this.aliases.containsKey(serviceTag);
    }

    public void addAlias(@Nonnull String alias, @Nonnull Object service) {
        ScopeNode.checkAlias(alias);
        ScopeNode.checkService(service);
        this.aliases.put(alias, service);
    }

    public Set<Map.Entry<String, Object>> services() {
        return Collections.unmodifiableSet(this.services.entrySet());
    }

    public <T> T getService(@Nonnull String serviceTag) {
        ScopeNode.checkServiceTag(serviceTag);
        if (this.services.containsKey(serviceTag)) {
            return (T)this.services.get(serviceTag);
        }
        ScopeNode.checkAlias(serviceTag);
        if (this.aliases.containsKey(serviceTag)) {
            return (T)this.aliases.get(serviceTag);
        }
        throw new IllegalArgumentException("Scope does not contain [" + serviceTag + "]");
    }

    private static void checkServiceTag(@Nonnull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("serviceTag cannot be null!");
        }
    }

    private static void checkService(@Nonnull Object service) {
        if (service == null) {
            throw new IllegalArgumentException("service cannot be null!");
        }
    }

    private static void checkAlias(@Nonnull String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias cannot be null!");
        }
    }
}

