/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.view.LayoutInflater;
import javax.annotation.Nonnull;

public class KeyContextWrapper
extends ContextWrapper {
    public static final String TAG = "Backstack.KEY";
    LayoutInflater layoutInflater;
    final Object key;

    public KeyContextWrapper(Context base, @Nonnull Object key) {
        super(base);
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        this.key = key;
    }

    public Object getSystemService(String name) {
        if ("layout_inflater".equals(name)) {
            if (this.layoutInflater == null) {
                this.layoutInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
            }
            return this.layoutInflater;
        }
        if (TAG.equals(name)) {
            return this.key;
        }
        return super.getSystemService(name);
    }

    @Nonnull
    @SuppressLint(value={"WrongConstant"})
    public static <T> T getKey(Context context) {
        Object key = context.getSystemService(TAG);
        if (key == null) {
            throw new IllegalStateException("The context is supposed to contain a key, but it does not!");
        }
        return (T)key;
    }
}

