/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import com.zhuinden.simplestack.AheadOfTimeBackCallback;
import com.zhuinden.simplestack.AheadOfTimeBackProcessingContractViolationException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class AheadOfTimeBackCallbackRegistry
extends AheadOfTimeBackCallback {
    private final AheadOfTimeBackCallback.EnabledChangedListener childEventListener = new AheadOfTimeBackCallback.EnabledChangedListener(){

        @Override
        public void onEnabledChanged(boolean isEnabled) {
            if (isEnabled) {
                AheadOfTimeBackCallbackRegistry.this.setEnabled(true);
                return;
            }
            for (int i = AheadOfTimeBackCallbackRegistry.this.callbacks.size() - 1; i >= 0; --i) {
                AheadOfTimeBackCallback callback = (AheadOfTimeBackCallback)AheadOfTimeBackCallbackRegistry.this.callbacks.get(i);
                if (!callback.isEnabled()) continue;
                AheadOfTimeBackCallbackRegistry.this.setEnabled(true);
                return;
            }
            AheadOfTimeBackCallbackRegistry.this.setEnabled(false);
        }
    };
    private final long threadId = Thread.currentThread().getId();
    private List<AheadOfTimeBackCallback> callbacks = new ArrayList<AheadOfTimeBackCallback>();

    public AheadOfTimeBackCallbackRegistry() {
        super(false);
    }

    private void checkCorrectThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Object should only be mutated on the same thread where the object was created.");
        }
    }

    public void registerAheadOfTimeBackCallback(@Nonnull AheadOfTimeBackCallback aheadOfTimeBackCallback) {
        this.checkCorrectThread();
        if (aheadOfTimeBackCallback == null) {
            throw new IllegalArgumentException("aheadOfTimeBackCallback cannot be null!");
        }
        this.callbacks.add(aheadOfTimeBackCallback);
        if (aheadOfTimeBackCallback.isEnabled()) {
            this.setEnabled(true);
        }
        aheadOfTimeBackCallback.addEnabledChangedListener(this.childEventListener);
    }

    public void unregisterAheadOfTimeBackCallback(@Nonnull AheadOfTimeBackCallback aheadOfTimeBackCallback) {
        this.checkCorrectThread();
        if (aheadOfTimeBackCallback == null) {
            throw new IllegalArgumentException("aheadOfTimeBackCallback cannot be null!");
        }
        aheadOfTimeBackCallback.removeEnabledChangedListener(this.childEventListener);
        this.callbacks.remove(aheadOfTimeBackCallback);
    }

    @Override
    public final void onBackReceived() {
        for (int i = this.callbacks.size() - 1; i >= 0; --i) {
            AheadOfTimeBackCallback callback = this.callbacks.get(i);
            if (!callback.isEnabled()) continue;
            callback.onBackReceived();
            return;
        }
        throw new AheadOfTimeBackProcessingContractViolationException("Registry was enabled, but it contained no enabled callback. This is most definitely an error. Please report it if you see it.");
    }
}

