/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zlylib.upperdialog.manager.DecorLayer;
import com.zlylib.upperdialog.view.ContainerLayout;

public final class Utils {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context = null;

    public static void init(Context context) {
        Utils.context = context;
    }

    public static Context getAppContext() {
        if (context == null) {
            throw new RuntimeException("Utils\u672a\u5728Application\u4e2d\u521d\u59cb\u5316");
        }
        return context;
    }

    public static <T> T requireNonNull(T obj, String msg) {
        if (obj == null) {
            throw new NullPointerException(msg);
        }
        return obj;
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static float floatRange01(float value) {
        return Utils.floatRange(value, 0.0f, 1.0f);
    }

    public static float floatRange(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static int intRange(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static Activity getActivity(Context context) {
        Context baseContext;
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper && (baseContext = ((ContextWrapper)context).getBaseContext()) instanceof Activity) {
            return (Activity)baseContext;
        }
        return null;
    }

    public static Bitmap snapshot(FrameLayout decor, ImageView iv, float scale, DecorLayer.LevelLayout currLevelLayout, ContainerLayout currContainerLayout) {
        int w = iv.getWidth();
        int h = iv.getHeight();
        int oW = (int)((float)w / scale);
        int oH = (int)((float)h / scale);
        Bitmap bitmap = Bitmap.createBitmap((int)oW, (int)oH, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.save();
        int[] locationRootView = new int[2];
        decor.getLocationOnScreen(locationRootView);
        int[] locationBackground = new int[2];
        iv.getLocationOnScreen(locationBackground);
        int x = locationBackground[0] - locationRootView[0];
        int y = locationBackground[1] - locationRootView[1];
        canvas.scale(1.0f / scale, 1.0f / scale);
        canvas.translate((float)x / scale, (float)y / scale);
        if (decor.getBackground() != null) {
            decor.getBackground().draw(canvas);
        }
        block0: for (int i = 0; i < decor.getChildCount(); ++i) {
            View decorChildAt = decor.getChildAt(i);
            if (decorChildAt instanceof DecorLayer.LayerLayout) {
                View layerChildAt;
                DecorLayer.LayerLayout layerLayout = (DecorLayer.LayerLayout)decorChildAt;
                for (int j = 0; j < layerLayout.getChildCount() && (layerChildAt = layerLayout.getChildAt(j)) instanceof DecorLayer.LevelLayout; ++j) {
                    DecorLayer.LevelLayout levelLayout = (DecorLayer.LevelLayout)layerChildAt;
                    if (levelLayout == currLevelLayout) {
                        View containerLayout;
                        for (int k = 0; k < levelLayout.getChildCount() && (containerLayout = levelLayout.getChildAt(k)) != currContainerLayout; ++k) {
                            containerLayout.draw(canvas);
                        }
                        break block0;
                    }
                    levelLayout.draw(canvas);
                }
                break;
            }
            decorChildAt.draw(canvas);
        }
        canvas.restore();
        return bitmap;
    }

    public static void transparent(Activity activity) {
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
        }
    }

    public static void getViewSize(final View view, final Runnable runnable) {
        Utils.requireNonNull(view);
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (view.getViewTreeObserver().isAlive()) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
                runnable.run();
            }
        });
    }
}

