/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.manager;

import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.zlylib.upperdialog.utils.Utils;

public class ViewManager {
    private ViewGroup mParent = null;
    private View mChild = null;
    private LayerKeyListener mLayerKeyListener = null;
    private LayerGlobalFocusChangeListener mLayerGlobalFocusChangeListener = null;
    private View currentKeyView = null;
    private OnLifeListener mOnLifeListener = null;
    private OnPreDrawListener mOnPreDrawListener = null;
    private OnKeyListener mOnKeyListener = null;

    public void setParent(ViewGroup parent) {
        Utils.requireNonNull(parent, "parent == null");
        this.mParent = parent;
    }

    public void setChild(View child) {
        Utils.requireNonNull(child, "child == null");
        this.mChild = child;
    }

    public ViewGroup getParent() {
        return this.mParent;
    }

    public View getChild() {
        return this.mChild;
    }

    private void checkChildParent() {
        ViewGroup parent = (ViewGroup)this.mChild.getParent();
        if (parent != null && parent != this.mParent) {
            parent.removeView(this.mChild);
        }
    }

    public void attach() {
        Utils.requireNonNull(this.mParent, "parent cannot be null on attach");
        Utils.requireNonNull(this.mChild, "child cannot be null on attach");
        this.checkChildParent();
        if (!this.isAttached()) {
            this.onAttach();
        }
    }

    public void detach() {
        if (this.isAttached()) {
            this.onDetach();
        }
    }

    public boolean isAttached() {
        return this.mChild != null && this.mChild.getParent() != null;
    }

    public void setOnLifeListener(OnLifeListener onLifeListener) {
        this.mOnLifeListener = onLifeListener;
    }

    public void setOnPreDrawListener(OnPreDrawListener onPreDrawListener) {
        this.mOnPreDrawListener = onPreDrawListener;
    }

    public void setOnKeyListener(OnKeyListener onKeyListener) {
        this.mOnKeyListener = onKeyListener;
    }

    private void onAttach() {
        if (this.mOnKeyListener != null) {
            this.mChild.setFocusable(true);
            this.mChild.setFocusableInTouchMode(true);
            this.mChild.requestFocus();
            this.currentKeyView = this.mChild;
            this.mLayerGlobalFocusChangeListener = new LayerGlobalFocusChangeListener();
            this.mChild.getViewTreeObserver().addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mLayerGlobalFocusChangeListener);
            this.mLayerKeyListener = new LayerKeyListener();
            this.currentKeyView.setOnKeyListener((View.OnKeyListener)this.mLayerKeyListener);
        }
        this.mChild.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new LayerPreDrawListener());
        this.mParent.addView(this.mChild);
        if (this.mOnLifeListener != null) {
            this.mOnLifeListener.onAttach();
        }
    }

    private void onDetach() {
        if (this.currentKeyView != null) {
            this.currentKeyView.setOnKeyListener(null);
            this.mLayerKeyListener = null;
            this.mChild.getViewTreeObserver().removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.mLayerGlobalFocusChangeListener);
            this.mLayerGlobalFocusChangeListener = null;
        }
        this.mParent.removeView(this.mChild);
        if (this.mOnLifeListener != null) {
            this.mOnLifeListener.onDetach();
        }
    }

    public static interface OnKeyListener {
        public boolean onKey(int var1, KeyEvent var2);
    }

    public static interface OnPreDrawListener {
        public void onPreDraw();
    }

    public static interface OnLifeListener {
        public void onAttach();

        public void onDetach();
    }

    private final class LayerKeyListener
    implements View.OnKeyListener {
        private LayerKeyListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (!ViewManager.this.isAttached()) {
                return false;
            }
            if (ViewManager.this.mOnKeyListener == null) {
                return false;
            }
            return ViewManager.this.mOnKeyListener.onKey(keyCode, event);
        }
    }

    private final class LayerGlobalFocusChangeListener
    implements ViewTreeObserver.OnGlobalFocusChangeListener {
        private LayerGlobalFocusChangeListener() {
        }

        public void onGlobalFocusChanged(View oldFocus, View newFocus) {
            if (ViewManager.this.currentKeyView != null) {
                ViewManager.this.currentKeyView.setOnKeyListener(null);
            }
            if (oldFocus != null) {
                oldFocus.setOnKeyListener(null);
            }
            if (newFocus != null) {
                ViewManager.this.currentKeyView = newFocus;
                ViewManager.this.currentKeyView.setOnKeyListener((View.OnKeyListener)ViewManager.this.mLayerKeyListener);
            }
        }
    }

    private final class LayerPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        private LayerPreDrawListener() {
        }

        public boolean onPreDraw() {
            if (ViewManager.this.mChild.getViewTreeObserver().isAlive()) {
                ViewManager.this.mChild.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            }
            if (ViewManager.this.mOnPreDrawListener != null) {
                ViewManager.this.mOnPreDrawListener.onPreDraw();
            }
            return true;
        }
    }
}

