/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.common;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import com.zlylib.upperdialog.utils.Utils;
import java.util.ArrayList;

public class AnimatorHelper {
    private static final float ZOOM_PERCENT = 0.9f;
    private static final float MOVE_PERCENT = 0.9f;
    private static final float INTERPOLATOR_FACTOR_1 = 1.5f;
    private static final float INTERPOLATOR_FACTOR_2 = 2.5f;
    static ViewGroup targetGroup;

    private static TimeInterpolator createDefInterpolator(float factor) {
        return new DecelerateInterpolator(factor);
    }

    private static TimeInterpolator createDefInterpolator1() {
        return AnimatorHelper.createDefInterpolator(1.5f);
    }

    private static TimeInterpolator createDefInterpolator2() {
        return AnimatorHelper.createDefInterpolator(2.5f);
    }

    public static Animator createAlphaInAnim(View target) {
        return AnimatorHelper.createAlphaInAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createAlphaInAnim(View target, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        return alpha;
    }

    public static Animator createAlphaOutAnim(View target) {
        return AnimatorHelper.createAlphaOutAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createAlphaOutAnim(View target, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{target.getAlpha(), 0.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        return alpha;
    }

    public static Animator createZoomInAnim(View target) {
        return AnimatorHelper.createZoomInAnim(target, 0.5f, 0.5f);
    }

    public static Animator createZoomInAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createZoomInAnim(target, centerPercentX, centerPercentY, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createZoomInAnim(View target, float centerPercentX, float centerPercentY, TimeInterpolator zoomInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createZoomInAnim(target, centerX, centerY, zoomInterpolator);
    }

    public static Animator createZoomInAnim(View target, int centerX, int centerY, TimeInterpolator zoomInterpolator) {
        if (target == null) {
            return null;
        }
        target.setPivotX((float)centerX);
        target.setPivotY((float)centerY);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        if (zoomInterpolator != null) {
            scaleX.setInterpolator(zoomInterpolator);
            scaleY.setInterpolator(zoomInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{scaleX, scaleY});
        return set;
    }

    public static Animator createZoomOutAnim(View target) {
        return AnimatorHelper.createZoomOutAnim(target, 0.5f, 0.5f);
    }

    public static Animator createZoomOutAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createZoomOutAnim(target, centerPercentX, centerPercentY, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createZoomOutAnim(View target, float centerPercentX, float centerPercentY, TimeInterpolator zoomInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createZoomOutAnim(target, centerX, centerY, zoomInterpolator);
    }

    public static Animator createZoomOutAnim(View target, int centerX, int centerY, TimeInterpolator zoomInterpolator) {
        if (target == null) {
            return null;
        }
        target.setPivotX((float)centerX);
        target.setPivotY((float)centerY);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{target.getScaleX(), 0.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{target.getScaleY(), 0.0f});
        if (zoomInterpolator != null) {
            scaleX.setInterpolator(zoomInterpolator);
            scaleY.setInterpolator(zoomInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{scaleX, scaleY});
        return set;
    }

    public static Animator createZoomAlphaInAnim(View target) {
        return AnimatorHelper.createZoomAlphaInAnim(target, 0.9f);
    }

    public static Animator createZoomAlphaInAnim(View target, float fromScale) {
        return AnimatorHelper.createZoomAlphaInAnim(target, 0.5f, 0.5f, fromScale);
    }

    public static Animator createZoomAlphaInAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createZoomAlphaInAnim(target, centerPercentX, centerPercentY, 0.9f);
    }

    public static Animator createZoomAlphaInAnim(View target, int centerX, int centerY) {
        return AnimatorHelper.createZoomAlphaInAnim(target, centerX, centerY, 0.9f);
    }

    public static Animator createZoomAlphaInAnim(View target, float centerPercentX, float centerPercentY, float fromScale) {
        return AnimatorHelper.createZoomAlphaInAnim(target, centerPercentX, centerPercentY, fromScale, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createZoomAlphaInAnim(View target, int centerX, int centerY, float fromScale) {
        return AnimatorHelper.createZoomAlphaInAnim(target, centerX, centerY, fromScale, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createZoomAlphaInAnim(View target, float centerPercentX, float centerPercentY, float fromScale, TimeInterpolator zoomInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createZoomAlphaInAnim(target, centerX, centerY, fromScale, zoomInterpolator, alphaInterpolator);
    }

    public static Animator createZoomAlphaInAnim(View target, int centerX, int centerY, float fromScale, TimeInterpolator zoomInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        target.setPivotX((float)centerX);
        target.setPivotY((float)centerY);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{fromScale, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{fromScale, 1.0f});
        if (zoomInterpolator != null) {
            scaleX.setInterpolator(zoomInterpolator);
            scaleY.setInterpolator(zoomInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, scaleX, scaleY});
        return set;
    }

    public static Animator createZoomAlphaOutAnim(View target) {
        return AnimatorHelper.createZoomAlphaOutAnim(target, 0.9f);
    }

    public static Animator createZoomAlphaOutAnim(View target, float toScale) {
        return AnimatorHelper.createZoomAlphaOutAnim(target, 0.5f, 0.5f, toScale);
    }

    public static Animator createZoomAlphaOutAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createZoomAlphaOutAnim(target, centerPercentX, centerPercentY, 0.9f);
    }

    public static Animator createZoomAlphaOutAnim(View target, int centerX, int centerY) {
        return AnimatorHelper.createZoomAlphaOutAnim(target, centerX, centerY, 0.9f);
    }

    public static Animator createZoomAlphaOutAnim(View target, float centerPercentX, float centerPercentY, float toScale) {
        return AnimatorHelper.createZoomAlphaOutAnim(target, centerPercentX, centerPercentY, toScale, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createZoomAlphaOutAnim(View target, int centerX, int centerY, float toScale) {
        return AnimatorHelper.createZoomAlphaOutAnim(target, centerX, centerY, toScale, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createZoomAlphaOutAnim(View target, float centerPercentX, float centerPercentY, float toScale, TimeInterpolator zoomInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createZoomAlphaOutAnim(target, centerX, centerY, toScale, zoomInterpolator, alphaInterpolator);
    }

    public static Animator createZoomAlphaOutAnim(View target, int centerX, int centerY, float toScale, TimeInterpolator zoomInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        target.setPivotX((float)centerX);
        target.setPivotY((float)centerY);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{target.getAlpha(), 0.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (String)"scaleX", (float[])new float[]{target.getScaleX(), toScale});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (String)"scaleY", (float[])new float[]{target.getScaleY(), toScale});
        if (zoomInterpolator != null) {
            scaleX.setInterpolator(zoomInterpolator);
            scaleY.setInterpolator(zoomInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, scaleX, scaleY});
        return set;
    }

    public static Animator createTopInAnim(View target) {
        return AnimatorHelper.createTopInAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createTopInAnim(View target, TimeInterpolator topInterpolator) {
        if (target == null) {
            return null;
        }
        ObjectAnimator top = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{-target.getBottom(), 0.0f});
        if (topInterpolator != null) {
            top.setInterpolator(topInterpolator);
        }
        return top;
    }

    public static Animator createTopOutAnim(View target) {
        return AnimatorHelper.createTopOutAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createTopOutAnim(View target, TimeInterpolator topInterpolator) {
        if (target == null) {
            return null;
        }
        ObjectAnimator top = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{target.getTranslationY(), -target.getBottom()});
        if (topInterpolator != null) {
            top.setInterpolator(topInterpolator);
        }
        return top;
    }

    public static Animator createTopAlphaInAnim(View target) {
        return AnimatorHelper.createTopAlphaInAnim(target, 0.100000024f);
    }

    public static Animator createTopAlphaInAnim(View target, float percentTargetHeight) {
        return AnimatorHelper.createTopAlphaInAnim(target, percentTargetHeight, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createTopAlphaInAnim(View target, float percentTargetHeight, TimeInterpolator yInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float y = percentTargetHeight * (float)target.getMeasuredHeight();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{-y, 0.0f});
        if (yInterpolator != null) {
            translationY.setInterpolator(yInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationY});
        return set;
    }

    public static Animator createTopAlphaOutAnim(View target) {
        return AnimatorHelper.createTopAlphaOutAnim(target, 0.100000024f);
    }

    public static Animator createTopAlphaOutAnim(View target, float percentTargetHeight) {
        return AnimatorHelper.createTopAlphaOutAnim(target, percentTargetHeight, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createTopAlphaOutAnim(View target, float percentTargetHeight, TimeInterpolator yInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float y = percentTargetHeight * (float)target.getMeasuredHeight();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{target.getAlpha(), 0.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{target.getTranslationY(), -y});
        if (yInterpolator != null) {
            translationY.setInterpolator(yInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationY});
        return set;
    }

    public static Animator createBottomInAnim(View target) {
        return AnimatorHelper.createBottomInAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createBottomInAnim(View target, TimeInterpolator yInterpolator) {
        if (target == null) {
            return null;
        }
        float y = ((ViewGroup)target.getParent()).getMeasuredHeight() - target.getTop();
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{y, 0.0f});
        if (yInterpolator != null) {
            translationY.setInterpolator(yInterpolator);
        }
        return translationY;
    }

    public static Animator createBottomAlphaInAnim(View target) {
        return AnimatorHelper.createBottomAlphaInAnim(target, 0.100000024f);
    }

    public static Animator createBottomAlphaInAnim(View target, float percentTargetHeight) {
        return AnimatorHelper.createBottomAlphaInAnim(target, percentTargetHeight, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createBottomAlphaInAnim(View target, float percentTargetHeight, TimeInterpolator yInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float y = percentTargetHeight * (float)target.getMeasuredHeight();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{y, 0.0f});
        if (yInterpolator != null) {
            translationY.setInterpolator(yInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationY});
        return set;
    }

    public static Animator createBottomOutAnim(View target) {
        return AnimatorHelper.createBottomOutAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createBottomOutAnim(View target, TimeInterpolator yInterpolator) {
        if (target == null) {
            return null;
        }
        float y = ((ViewGroup)target.getParent()).getMeasuredHeight() - target.getTop();
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{target.getTranslationY(), y});
        if (yInterpolator != null) {
            translationY.setInterpolator(yInterpolator);
        }
        return translationY;
    }

    public static Animator createBottomAlphaOutAnim(View target) {
        return AnimatorHelper.createBottomAlphaOutAnim(target, 0.100000024f);
    }

    public static Animator createBottomAlphaOutAnim(View target, float percentTargetHeight) {
        return AnimatorHelper.createBottomAlphaOutAnim(target, percentTargetHeight, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createBottomAlphaOutAnim(View target, float percentTargetHeight, TimeInterpolator yInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float y = percentTargetHeight * (float)target.getMeasuredHeight();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{target.getAlpha(), 0.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)target, (String)"translationY", (float[])new float[]{target.getTranslationY(), y});
        if (yInterpolator != null) {
            translationY.setInterpolator(yInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationY});
        return set;
    }

    public static Animator createLeftInAnim(View target) {
        return AnimatorHelper.createLeftInAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createLeftInAnim(View target, TimeInterpolator xInterpolator) {
        if (target == null) {
            return null;
        }
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{-target.getRight(), 0.0f});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        return translationX;
    }

    public static Animator createLeftOutAnim(View target) {
        return AnimatorHelper.createLeftOutAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createLeftOutAnim(View target, TimeInterpolator xInterpolator) {
        if (target == null) {
            return null;
        }
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{target.getTranslationX(), -target.getRight()});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        return translationX;
    }

    public static Animator createLeftAlphaInAnim(View target) {
        return AnimatorHelper.createLeftAlphaInAnim(target, 0.100000024f);
    }

    public static Animator createLeftAlphaInAnim(View target, float percentTargetWidth) {
        return AnimatorHelper.createLeftAlphaInAnim(target, percentTargetWidth, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createLeftAlphaInAnim(View target, float percentTargetWidth, TimeInterpolator xInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float x = percentTargetWidth * (float)target.getMeasuredWidth();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{-x, 0.0f});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationX});
        return set;
    }

    public static Animator createLeftAlphaOutAnim(View target) {
        return AnimatorHelper.createLeftAlphaOutAnim(target, 0.100000024f);
    }

    public static Animator createLeftAlphaOutAnim(View target, float percentTargetWidth) {
        return AnimatorHelper.createLeftAlphaOutAnim(target, percentTargetWidth, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createLeftAlphaOutAnim(View target, float percentTargetWidth, TimeInterpolator xInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float x = percentTargetWidth * (float)target.getMeasuredWidth();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{target.getAlpha(), 0.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{target.getTranslationX(), -x});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationX});
        return set;
    }

    public static Animator createRightInAnim(View target) {
        return AnimatorHelper.createRightInAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createRightInAnim(View target, TimeInterpolator xInterpolator) {
        if (target == null) {
            return null;
        }
        float x = ((ViewGroup)target.getParent()).getMeasuredWidth() - target.getLeft();
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{x, 0.0f});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        return translationX;
    }

    public static Animator createRightOutAnim(View target) {
        return AnimatorHelper.createRightOutAnim(target, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createRightOutAnim(View target, TimeInterpolator xInterpolator) {
        if (target == null) {
            return null;
        }
        float x = ((ViewGroup)target.getParent()).getMeasuredWidth() - target.getLeft();
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{target.getTranslationX(), x});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        return translationX;
    }

    public static Animator createRightAlphaInAnim(View target) {
        return AnimatorHelper.createRightAlphaInAnim(target, 0.100000024f);
    }

    public static Animator createRightAlphaInAnim(View target, float percentTargetWidth) {
        return AnimatorHelper.createRightAlphaInAnim(target, percentTargetWidth, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createRightAlphaInAnim(View target, float percentTargetWidth, TimeInterpolator xInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float x = percentTargetWidth * (float)target.getMeasuredWidth();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{x, 0.0f});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationX});
        return set;
    }

    public static Animator createRightAlphaOutAnim(View target) {
        return AnimatorHelper.createRightAlphaOutAnim(target, 0.100000024f);
    }

    public static Animator createRightAlphaOutAnim(View target, float percentTargetWidth) {
        return AnimatorHelper.createRightAlphaOutAnim(target, percentTargetWidth, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createRightAlphaOutAnim(View target, float percentTargetWidth, TimeInterpolator xInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        float x = percentTargetWidth * (float)target.getMeasuredWidth();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (String)"alpha", (float[])new float[]{target.getAlpha(), 0.0f});
        if (alphaInterpolator != null) {
            alpha.setInterpolator(alphaInterpolator);
        }
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)target, (String)"translationX", (float[])new float[]{target.getTranslationX(), x});
        if (xInterpolator != null) {
            translationX.setInterpolator(xInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{alpha, translationX});
        return set;
    }

    public static Animator createCircularRevealInAnim(View target) {
        return AnimatorHelper.createCircularRevealInAnim(target, 0.5f, 0.5f);
    }

    public static Animator createCircularRevealInAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createCircularRevealInAnim(target, centerPercentX, centerPercentY, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createCircularRevealInAnim(View target, int centerX, int centerY) {
        return AnimatorHelper.createCircularRevealInAnim(target, centerX, centerY, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createCircularRevealInAnim(View target, float centerPercentX, float centerPercentY, TimeInterpolator timeInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createCircularRevealInAnim(target, centerX, centerY, timeInterpolator);
    }

    public static Animator createCircularRevealInAnim(View target, int centerX, int centerY, TimeInterpolator timeInterpolator) {
        if (target == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        int x = target.getMeasuredWidth();
        int y = target.getMeasuredHeight();
        int r = (int)Math.sqrt(Math.pow(Math.max(centerX, x - centerX), 2.0) + Math.pow(Math.max(centerY, y - centerY), 2.0));
        Animator animator = ViewAnimationUtils.createCircularReveal((View)target, (int)centerX, (int)centerY, (float)0.0f, (float)r);
        if (timeInterpolator != null) {
            animator.setInterpolator(timeInterpolator);
        }
        return animator;
    }

    public static Animator createCircularRevealOutAnim(View target) {
        return AnimatorHelper.createCircularRevealOutAnim(target, 0.5f, 0.5f);
    }

    public static Animator createCircularRevealOutAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createCircularRevealOutAnim(target, centerPercentX, centerPercentY, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createCircularRevealOutAnim(View target, int centerX, int centerY) {
        return AnimatorHelper.createCircularRevealOutAnim(target, centerX, centerY, AnimatorHelper.createDefInterpolator1());
    }

    public static Animator createCircularRevealOutAnim(View target, float centerPercentX, float centerPercentY, TimeInterpolator timeInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createCircularRevealOutAnim(target, centerX, centerY, timeInterpolator);
    }

    public static Animator createCircularRevealOutAnim(View target, int centerX, int centerY, TimeInterpolator timeInterpolator) {
        if (target == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        int x = target.getMeasuredWidth();
        int y = target.getMeasuredHeight();
        int r = (int)Math.sqrt(Math.pow(Math.max(centerX, x - centerX), 2.0) + Math.pow(Math.max(centerY, y - centerY), 2.0));
        Animator animator = ViewAnimationUtils.createCircularReveal((View)target, (int)centerX, (int)centerY, (float)r, (float)0.0f);
        if (timeInterpolator != null) {
            animator.setInterpolator(timeInterpolator);
        }
        return animator;
    }

    public static Animator createDelayedZoomInAnim(View target) {
        return AnimatorHelper.createDelayedZoomInAnim(target, 0.5f, 0.5f);
    }

    public static Animator createDelayedZoomInAnim(View target, int centerX, int centerY) {
        return AnimatorHelper.createDelayedZoomInAnim(target, centerX, centerY, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createDelayedZoomInAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createDelayedZoomInAnim(target, centerPercentX, centerPercentY, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createDelayedZoomInAnim(View target, float centerPercentX, float centerPercentY, TimeInterpolator zoomInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createDelayedZoomInAnim(target, centerX, centerY, zoomInterpolator, alphaInterpolator);
    }

    public static Animator createDelayedZoomInAnim(View target, int centerX, int centerY, TimeInterpolator zoomInterpolator, final TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        if (!(target instanceof ViewGroup)) {
            return AnimatorHelper.createZoomInAnim(target, centerX, centerY);
        }
        targetGroup = (ViewGroup)target;
        for (int i = 0; i < targetGroup.getChildCount(); ++i) {
            View targetChild = targetGroup.getChildAt(i);
            targetChild.setAlpha(0.0f);
        }
        targetGroup.setPivotX((float)centerX);
        targetGroup.setPivotY((float)centerY);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)targetGroup, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)targetGroup, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        if (zoomInterpolator != null) {
            scaleX.setInterpolator(zoomInterpolator);
            scaleY.setInterpolator(zoomInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{scaleX, scaleY});
        scaleX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private boolean isChildAnimStart = false;

            public void onAnimationUpdate(ValueAnimator animation) {
                float f = animation.getAnimatedFraction();
                if (!this.isChildAnimStart && f > 0.618f) {
                    this.isChildAnimStart = true;
                    ArrayList<ObjectAnimator> childAnimators = new ArrayList<ObjectAnimator>(targetGroup.getChildCount());
                    for (int i = 0; i < targetGroup.getChildCount(); ++i) {
                        View targetChild = targetGroup.getChildAt(i);
                        ObjectAnimator alphaChild = ObjectAnimator.ofFloat((Object)targetChild, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
                        if (alphaInterpolator != null) {
                            alphaChild.setInterpolator(alphaInterpolator);
                        }
                        alphaChild.setStartDelay((long)(18 * i));
                        alphaChild.setDuration(50L);
                        childAnimators.add(alphaChild);
                    }
                    AnimatorSet set = new AnimatorSet();
                    set.playTogether(childAnimators);
                    set.start();
                }
            }
        });
        return set;
    }

    public static Animator createDelayedZoomOutAnim(View target) {
        return AnimatorHelper.createDelayedZoomOutAnim(target, 0.5f, 0.5f);
    }

    public static Animator createDelayedZoomOutAnim(View target, int centerX, int centerY) {
        return AnimatorHelper.createDelayedZoomOutAnim(target, centerX, centerY, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createDelayedZoomOutAnim(View target, float centerPercentX, float centerPercentY) {
        return AnimatorHelper.createDelayedZoomOutAnim(target, centerPercentX, centerPercentY, AnimatorHelper.createDefInterpolator1(), AnimatorHelper.createDefInterpolator2());
    }

    public static Animator createDelayedZoomOutAnim(View target, float centerPercentX, float centerPercentY, TimeInterpolator zoomInterpolator, TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        int centerX = (int)((float)target.getMeasuredWidth() * Utils.floatRange01(centerPercentX));
        int centerY = (int)((float)target.getMeasuredHeight() * Utils.floatRange01(centerPercentY));
        return AnimatorHelper.createDelayedZoomOutAnim(target, centerX, centerY, zoomInterpolator, alphaInterpolator);
    }

    public static Animator createDelayedZoomOutAnim(View target, int centerX, int centerY, TimeInterpolator zoomInterpolator, final TimeInterpolator alphaInterpolator) {
        if (target == null) {
            return null;
        }
        if (!(target instanceof ViewGroup)) {
            return AnimatorHelper.createZoomInAnim(target, centerX, centerY);
        }
        targetGroup = (ViewGroup)target;
        targetGroup.setPivotX((float)centerX);
        targetGroup.setPivotY((float)centerY);
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)targetGroup, (String)"scaleX", (float[])new float[]{targetGroup.getScaleX(), 0.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)targetGroup, (String)"scaleY", (float[])new float[]{targetGroup.getScaleY(), 0.0f});
        if (zoomInterpolator != null) {
            scaleX.setInterpolator(zoomInterpolator);
            scaleY.setInterpolator(zoomInterpolator);
        }
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{scaleX, scaleY});
        scaleX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private boolean isChildAnimStart = false;

            public void onAnimationUpdate(ValueAnimator animation) {
                if (!this.isChildAnimStart) {
                    this.isChildAnimStart = true;
                    ArrayList<ObjectAnimator> childAnimators = new ArrayList<ObjectAnimator>(targetGroup.getChildCount());
                    for (int i = targetGroup.getChildCount() - 1; i >= 0; --i) {
                        View targetChild = targetGroup.getChildAt(i);
                        ObjectAnimator alphaChild = ObjectAnimator.ofFloat((Object)targetChild, (String)"alpha", (float[])new float[]{targetChild.getAlpha(), 0.0f});
                        if (alphaInterpolator != null) {
                            alphaChild.setInterpolator(alphaInterpolator);
                        }
                        alphaChild.setStartDelay((long)(18 * (targetGroup.getChildCount() - 1 - i)));
                        alphaChild.setDuration(50L);
                        childAnimators.add(alphaChild);
                    }
                    AnimatorSet set = new AnimatorSet();
                    set.playTogether(childAnimators);
                    set.start();
                }
            }
        });
        return set;
    }
}

