/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import com.zlylib.upperdialog.R;
import com.zlylib.upperdialog.Upper;
import com.zlylib.upperdialog.dialog.DialogLayer;
import com.zlylib.upperdialog.listener.SimpleCallback;
import com.zlylib.upperdialog.manager.Layer;
import com.zlylib.upperdialog.utils.ResUtils;
import com.zlylib.upperdialog.utils.Utils;

public class TipDialog {
    private final Context context;
    private CharSequence title;
    private CharSequence msg;
    private CharSequence yesText;
    private CharSequence noText;
    private int yesTextColor = 0;
    private int noTextColor = 0;
    private boolean singleBtnYes = false;
    private boolean isadaption = true;
    private int WidthSize = 400;
    private boolean cancelable = true;
    private SimpleCallback<Void> callbackYes = null;
    private SimpleCallback<Void> callbackNo = null;
    private SimpleCallback<Void> onDismissListener = null;
    private DialogLayer mDialogLayer;

    public static TipDialog with(Context context) {
        return new TipDialog(context);
    }

    private TipDialog(Context context) {
        this.context = context;
        Utils.init(context);
        this.mDialogLayer = Upper.dialog(context);
        this.mDialogLayer.contentView(R.layout.basic_ui_dialog_tip).gravity(17).backgroundDimDefault().cancelableOnTouchOutside(this.cancelable).cancelableOnClickKeyBack(this.cancelable).onVisibleChangeListener(new Layer.OnVisibleChangeListener(){

            @Override
            public void onShow(Layer layer) {
            }

            @Override
            public void onDismiss(Layer layer) {
                if (TipDialog.this.onDismissListener != null) {
                    TipDialog.this.onDismissListener.onResult(null);
                }
            }
        }).bindData(new Layer.DataBinder(){

            @Override
            public void bindData(Layer layer) {
                LinearLayout basic_ll_tip = (LinearLayout)layer.getView(R.id.basic_ll_tip);
                if (!TipDialog.this.isadaption) {
                    ViewGroup.LayoutParams lp = basic_ll_tip.getLayoutParams();
                    lp.width = (int)TypedValue.applyDimension((int)1, (float)TipDialog.this.WidthSize, (DisplayMetrics)ResUtils.getResources().getDisplayMetrics());
                    basic_ll_tip.setLayoutParams(lp);
                }
                TextView tvYes = (TextView)layer.getView(R.id.basic_ui_tv_dialog_tip_yes);
                TextView tvNo = (TextView)layer.getView(R.id.basic_ui_tv_dialog_tip_no);
                Object vLine = layer.getView(R.id.basic_ui_v_dialog_tip_line);
                if (TipDialog.this.yesTextColor != 0) {
                    tvYes.setTextColor(ResUtils.getResources().getColor(TipDialog.this.yesTextColor));
                }
                if (TipDialog.this.noTextColor != 0) {
                    tvNo.setTextColor(ResUtils.getResources().getColor(TipDialog.this.noTextColor));
                }
                if (TipDialog.this.singleBtnYes) {
                    tvNo.setVisibility(8);
                    vLine.setVisibility(8);
                } else {
                    tvNo.setVisibility(0);
                    vLine.setVisibility(0);
                    if (TipDialog.this.noText != null) {
                        tvNo.setText(TipDialog.this.noText);
                    } else {
                        tvNo.setText(R.string.basic_ui_dialog_btn_no);
                    }
                }
                if (TipDialog.this.yesText != null) {
                    tvYes.setText(TipDialog.this.yesText);
                } else {
                    tvYes.setText(R.string.basic_ui_dialog_btn_yes);
                }
                TextView tvTitle = (TextView)layer.getView(R.id.basic_ui_tv_dialog_tip_title);
                if (TipDialog.this.title == null) {
                    tvTitle.setVisibility(8);
                } else {
                    tvTitle.setVisibility(0);
                    tvTitle.setText(TipDialog.this.title);
                }
                TextView tvContent = (TextView)layer.getView(R.id.basic_ui_tv_dialog_tip_content);
                tvContent.setText(TipDialog.this.msg);
            }
        }).onClickToDismiss(new Layer.OnClickListener(){

            @Override
            public void onClick(Layer layer, View v) {
                if (TipDialog.this.callbackYes != null) {
                    TipDialog.this.callbackYes.onResult(null);
                }
            }
        }, R.id.basic_ui_tv_dialog_tip_yes).onClickToDismiss(new Layer.OnClickListener(){

            @Override
            public void onClick(Layer layer, View v) {
                if (TipDialog.this.callbackNo != null) {
                    TipDialog.this.callbackNo.onResult(null);
                }
            }
        }, R.id.basic_ui_tv_dialog_tip_no);
    }

    public TipDialog yesText(CharSequence yesText) {
        this.yesText = yesText;
        return this;
    }

    public TipDialog yesText(@StringRes int yesText) {
        this.yesText = this.context.getString(yesText);
        return this;
    }

    public TipDialog noText(CharSequence noText) {
        this.noText = noText;
        return this;
    }

    public TipDialog noText(@StringRes int noText) {
        this.noText = this.context.getString(noText);
        return this;
    }

    public TipDialog yesTextColor(@ColorRes int yesColor) {
        this.yesTextColor = yesColor;
        return this;
    }

    public TipDialog noTextColor(@ColorRes int noColor) {
        this.noTextColor = noColor;
        return this;
    }

    public TipDialog title(CharSequence title) {
        this.title = title;
        return this;
    }

    public TipDialog title(@StringRes int title) {
        this.title = this.context.getString(title);
        return this;
    }

    public TipDialog message(CharSequence msg) {
        this.msg = msg;
        return this;
    }

    public TipDialog message(@StringRes int msg) {
        this.msg = this.context.getString(msg);
        return this;
    }

    public TipDialog singleYesBtn() {
        this.singleBtnYes = true;
        return this;
    }

    public TipDialog setAdaption(boolean isadaption) {
        this.isadaption = isadaption;
        return this;
    }

    public TipDialog setAdaptionSize(boolean isadaption, int WidthSize) {
        this.isadaption = isadaption;
        this.WidthSize = WidthSize;
        return this;
    }

    public TipDialog cancelable(boolean cancelable) {
        this.cancelable = cancelable;
        return this;
    }

    public TipDialog onYes(SimpleCallback<Void> callback) {
        this.callbackYes = callback;
        return this;
    }

    public TipDialog onNo(SimpleCallback<Void> callback) {
        this.callbackNo = callback;
        return this;
    }

    public TipDialog onDismissListener(SimpleCallback<Void> onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    public void dismiss() {
        if (this.mDialogLayer != null) {
            this.mDialogLayer.dismiss();
        }
    }

    public void show() {
        if (this.mDialogLayer != null) {
            this.mDialogLayer.show();
        }
    }
}

