/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.zlylib.upperdialog.R;
import com.zlylib.upperdialog.Upper;
import com.zlylib.upperdialog.manager.Layer;
import com.zlylib.upperdialog.utils.ResUtils;
import com.zlylib.upperdialog.utils.Utils;
import com.zlylib.upperdialog.view.DragLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListDialog {
    private final Context context;
    private CharSequence title;
    private CharSequence yesText;
    private CharSequence noText;
    private int yesTextColor = 0;
    private int noTextColor = 0;
    private boolean noBtn = false;
    private boolean noYesBtn;
    private boolean noNoBtn = false;
    private boolean cancelable = true;
    private OnItemSelectedListener listener = null;
    private BaseQuickAdapter<String, BaseViewHolder> mAdapter = null;
    private List<String> datas = new ArrayList<String>();
    private int currSelectPos = -1;

    public static ListDialog with(Context context) {
        return new ListDialog(context);
    }

    private ListDialog(Context context) {
        this.context = context;
        Utils.init(context);
    }

    public ListDialog title(CharSequence title) {
        this.title = title;
        return this;
    }

    public ListDialog title(@StringRes int title) {
        this.title = this.context.getString(title);
        return this;
    }

    public ListDialog yesText(CharSequence yesText) {
        this.yesText = yesText;
        return this;
    }

    public ListDialog yesText(@StringRes int yesText) {
        this.yesText = this.context.getString(yesText);
        return this;
    }

    public ListDialog noText(CharSequence noText) {
        this.noText = noText;
        return this;
    }

    public ListDialog noText(@StringRes int noText) {
        this.noText = this.context.getString(noText);
        return this;
    }

    public ListDialog noBtn() {
        this.noBtn = true;
        return this;
    }

    public ListDialog noYseBtn() {
        this.noYesBtn = true;
        return this;
    }

    public ListDialog noNoBtn() {
        this.noNoBtn = true;
        return this;
    }

    public ListDialog yesTextColor(@ColorRes int yesColor) {
        this.yesTextColor = yesColor;
        return this;
    }

    public ListDialog noTextColor(@ColorRes int noColor) {
        this.noTextColor = noColor;
        return this;
    }

    public ListDialog cancelable(boolean cancelable) {
        this.cancelable = cancelable;
        return this;
    }

    public ListDialog datas(List<String> datas) {
        this.datas.addAll(datas);
        return this;
    }

    public ListDialog datas(String ... datas) {
        return this.datas(Arrays.asList(datas));
    }

    public ListDialog currSelectPos(int currSelectPos) {
        this.currSelectPos = currSelectPos;
        return this;
    }

    public ListDialog listener(OnItemSelectedListener listener) {
        this.listener = listener;
        return this;
    }

    public void show() {
        Upper.dialog(this.context).contentView(R.layout.basic_ui_dialog_list).gravity(80).backgroundDimDefault().dragDismiss(DragLayout.DragStyle.Bottom).cancelableOnTouchOutside(this.cancelable).cancelableOnClickKeyBack(this.cancelable).bindData(new Layer.DataBinder(){

            @Override
            public void bindData(final Layer layer) {
                LinearLayout llYesNo = (LinearLayout)layer.getView(R.id.basic_ui_ll_dialog_list_yes_no);
                Object vLineH = layer.getView(R.id.basic_ui_v_dialog_list_line_h);
                if (ListDialog.this.noBtn) {
                    vLineH.setVisibility(8);
                    llYesNo.setVisibility(8);
                } else {
                    vLineH.setVisibility(0);
                    llYesNo.setVisibility(0);
                    TextView tvYes = (TextView)layer.getView(R.id.basic_ui_tv_dialog_list_yes);
                    TextView tvNo = (TextView)layer.getView(R.id.basic_ui_tv_dialog_list_no);
                    Object vLine = layer.getView(R.id.basic_ui_v_dialog_list_line);
                    if (ListDialog.this.yesTextColor != 0) {
                        tvYes.setTextColor(ResUtils.getResources().getColor(ListDialog.this.yesTextColor));
                    }
                    if (ListDialog.this.noTextColor != 0) {
                        tvNo.setTextColor(ResUtils.getResources().getColor(ListDialog.this.noTextColor));
                    }
                    if (ListDialog.this.noNoBtn) {
                        tvNo.setVisibility(8);
                        vLine.setVisibility(8);
                    } else if (ListDialog.this.noYesBtn) {
                        ListDialog.this.noBtn = true;
                        tvYes.setVisibility(8);
                        vLine.setVisibility(8);
                    } else {
                        tvYes.setVisibility(0);
                        tvNo.setVisibility(0);
                        vLine.setVisibility(0);
                    }
                    if (ListDialog.this.yesText != null) {
                        tvYes.setText(ListDialog.this.yesText);
                    } else {
                        tvYes.setText(R.string.basic_ui_dialog_btn_yes);
                    }
                    if (ListDialog.this.noText != null) {
                        tvNo.setText(ListDialog.this.noText);
                    } else {
                        tvNo.setText(R.string.basic_ui_dialog_btn_no);
                    }
                }
                TextView tvTitle = (TextView)layer.getView(R.id.basic_ui_tv_dialog_list_title);
                if (ListDialog.this.title == null) {
                    tvTitle.setVisibility(8);
                } else {
                    tvTitle.setText(ListDialog.this.title);
                }
                RecyclerView rv = (RecyclerView)layer.getView(R.id.basic_ui_rv_dialog_list);
                rv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(rv.getContext()));
                ListDialog.this.mAdapter = (BaseQuickAdapter)new BaseQuickAdapter<String, BaseViewHolder>(R.layout.basic_ui_rv_item_dialog_list){

                    protected void convert(BaseViewHolder helper, String item) {
                        TextView tvName = (TextView)helper.getView(R.id.basic_ui_tv_dialog_list_name);
                        if (helper.getAdapterPosition() == ListDialog.this.currSelectPos) {
                            tvName.setTextColor(ResUtils.getColor(tvName.getContext(), R.color.text_main));
                        } else {
                            tvName.setTextColor(ResUtils.getColor(tvName.getContext(), R.color.text_surface));
                        }
                        tvName.setText((CharSequence)item);
                    }
                };
                ListDialog.this.mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

                    public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                        ListDialog.this.currSelectPos = position;
                        adapter.notifyDataSetChanged();
                        if (ListDialog.this.noBtn) {
                            if (ListDialog.this.listener != null) {
                                ListDialog.this.listener.onSelect((String)ListDialog.this.datas.get(ListDialog.this.currSelectPos), ListDialog.this.currSelectPos);
                            }
                            layer.dismiss();
                        }
                    }
                });
                rv.setAdapter((RecyclerView.Adapter)ListDialog.this.mAdapter);
                ListDialog.this.mAdapter.setNewData(ListDialog.this.datas);
            }
        }).onClickToDismiss(new Layer.OnClickListener(){

            @Override
            public void onClick(Layer layer, View v) {
                if (ListDialog.this.listener != null) {
                    ListDialog.this.listener.onSelect((String)ListDialog.this.datas.get(ListDialog.this.currSelectPos), ListDialog.this.currSelectPos);
                }
            }
        }, R.id.basic_ui_tv_dialog_list_yes).onClickToDismiss(R.id.basic_ui_tv_dialog_list_no).show();
    }

    public static interface OnItemSelectedListener {
        public void onSelect(String var1, int var2);
    }
}

