/*
 * Decompiled with CFR 0.152.
 */
package com.alimaddi.segmentedbutton;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.alimaddi.segmentedbutton.SegmentedButton;

class ButtonActor
extends View {
    private SegmentedButton button = null;
    private int dividerWidth = 0;

    public ButtonActor(Context context) {
        super(context);
    }

    public ButtonActor(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ButtonActor(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setButton(SegmentedButton button) {
        this.button = button;
    }

    public void setDividerWidth(int width) {
        this.dividerWidth = width;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        if (this.button != null) {
            int widthOffset = this.button.isLeftButton() && this.button.isRightButton() ? 0 : (this.button.isLeftButton() || this.button.isRightButton() ? this.dividerWidth / 2 : this.dividerWidth);
            width = ButtonActor.resolveSize((int)(this.button.getMeasuredWidth() - widthOffset), (int)widthMeasureSpec);
            height = ButtonActor.resolveSize((int)this.button.getMeasuredHeight(), (int)heightMeasureSpec);
        } else {
            width = ButtonActor.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
            height = ButtonActor.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        }
        this.setMeasuredDimension(width, height);
    }
}

