/*
 * Decompiled with CFR 0.152.
 */
package com.wynsbin.vciv;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.wynsbin.vciv.AsteriskPasswordTransformationMethod;
import com.wynsbin.vciv.DensityUtils;
import com.wynsbin.vciv.R;
import com.wynsbin.vciv.SoftInputUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerificationCodeInputView
extends RelativeLayout {
    private Context mContext;
    private OnInputListener onInputListener;
    private LinearLayout mLinearLayout;
    private RelativeLayout[] mRelativeLayouts;
    private TextView[] mTextViews;
    private View[] mUnderLineViews;
    private View[] mCursorViews;
    private EditText mEditText;
    private PopupWindow mPopupWindow;
    private ValueAnimator valueAnimator;
    private List<String> mCodes = new ArrayList<String>();
    private int mEtNumber;
    private VCInputType mEtInputType;
    private int mEtWidth;
    private int mEtHeight;
    private int mEtTextColor;
    private float mEtTextSize;
    private int mEtSpacing;
    private int mEtBisectSpacing;
    private boolean isBisect;
    private int mViewWidth;
    private int mEtUnderLineDefaultColor;
    private int mEtUnderLineFocusColor;
    private int mEtUnderLineHeight;
    private boolean mEtUnderLineShow;
    private int mEtCursorWidth;
    private int mEtCursorHeight;
    private int mEtCursorColor;
    private int mEtBackground;
    private int mEtFocusBackground;
    private boolean isFocusBackgroud;

    public VerificationCodeInputView(Context context) {
        super(context);
        this.init(context, null);
    }

    public VerificationCodeInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public VerificationCodeInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VerificationCodeInputView);
        this.mEtNumber = typedArray.getInteger(R.styleable.VerificationCodeInputView_vciv_et_number, 4);
        int inputType = typedArray.getInt(R.styleable.VerificationCodeInputView_vciv_et_inputType, VCInputType.NUMBER.ordinal());
        this.mEtInputType = VCInputType.values()[inputType];
        this.mEtWidth = typedArray.getDimensionPixelSize(R.styleable.VerificationCodeInputView_vciv_et_width, DensityUtils.dp2px(context, 40.0f));
        this.mEtHeight = typedArray.getDimensionPixelSize(R.styleable.VerificationCodeInputView_vciv_et_height, DensityUtils.dp2px(context, 40.0f));
        this.mEtTextColor = typedArray.getColor(R.styleable.VerificationCodeInputView_vciv_et_text_color, -16777216);
        this.mEtTextSize = typedArray.getDimensionPixelSize(R.styleable.VerificationCodeInputView_vciv_et_text_size, DensityUtils.sp2px(context, 14.0f));
        this.mEtBackground = typedArray.getResourceId(R.styleable.VerificationCodeInputView_vciv_et_background, -1);
        if (this.mEtBackground < 0) {
            this.mEtBackground = typedArray.getColor(R.styleable.VerificationCodeInputView_vciv_et_background, -1);
        }
        this.isFocusBackgroud = typedArray.hasValue(R.styleable.VerificationCodeInputView_vciv_et_foucs_background);
        this.mEtFocusBackground = typedArray.getResourceId(R.styleable.VerificationCodeInputView_vciv_et_foucs_background, -1);
        if (this.mEtFocusBackground < 0) {
            this.mEtFocusBackground = typedArray.getColor(R.styleable.VerificationCodeInputView_vciv_et_foucs_background, -1);
        }
        this.isBisect = typedArray.hasValue(R.styleable.VerificationCodeInputView_vciv_et_spacing);
        if (this.isBisect) {
            this.mEtSpacing = typedArray.getDimensionPixelSize(R.styleable.VerificationCodeInputView_vciv_et_spacing, 0);
        }
        this.mEtCursorWidth = typedArray.getDimensionPixelOffset(R.styleable.VerificationCodeInputView_vciv_et_cursor_width, DensityUtils.dp2px(context, 2.0f));
        this.mEtCursorHeight = typedArray.getDimensionPixelOffset(R.styleable.VerificationCodeInputView_vciv_et_cursor_height, DensityUtils.dp2px(context, 30.0f));
        this.mEtCursorColor = typedArray.getColor(R.styleable.VerificationCodeInputView_vciv_et_cursor_color, Color.parseColor((String)"#C3C3C3"));
        this.mEtUnderLineHeight = typedArray.getDimensionPixelOffset(R.styleable.VerificationCodeInputView_vciv_et_underline_height, DensityUtils.dp2px(context, 1.0f));
        this.mEtUnderLineDefaultColor = typedArray.getColor(R.styleable.VerificationCodeInputView_vciv_et_underline_default_color, Color.parseColor((String)"#F0F0F0"));
        this.mEtUnderLineFocusColor = typedArray.getColor(R.styleable.VerificationCodeInputView_vciv_et_underline_focus_color, Color.parseColor((String)"#C3C3C3"));
        this.mEtUnderLineShow = typedArray.getBoolean(R.styleable.VerificationCodeInputView_vciv_et_underline_show, false);
        this.initView();
        typedArray.recycle();
    }

    private void initView() {
        this.mRelativeLayouts = new RelativeLayout[this.mEtNumber];
        this.mTextViews = new TextView[this.mEtNumber];
        this.mUnderLineViews = new View[this.mEtNumber];
        this.mCursorViews = new View[this.mEtNumber];
        this.mLinearLayout = new LinearLayout(this.mContext);
        this.mLinearLayout.setOrientation(0);
        this.mLinearLayout.setGravity(1);
        this.mLinearLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        for (int i = 0; i < this.mEtNumber; ++i) {
            RelativeLayout relativeLayout = new RelativeLayout(this.mContext);
            relativeLayout.setLayoutParams((ViewGroup.LayoutParams)this.getEtLayoutParams(i));
            this.setEtBackground(relativeLayout, this.mEtBackground);
            this.mRelativeLayouts[i] = relativeLayout;
            TextView textView = new TextView(this.mContext);
            this.initTextView(textView);
            relativeLayout.addView((View)textView);
            this.mTextViews[i] = textView;
            View cursorView = new View(this.mContext);
            this.initCursorView(cursorView);
            relativeLayout.addView(cursorView);
            this.mCursorViews[i] = cursorView;
            if (this.mEtUnderLineShow) {
                View underLineView = new View(this.mContext);
                this.initUnderLineView(underLineView);
                relativeLayout.addView(underLineView);
                this.mUnderLineViews[i] = underLineView;
            }
            this.mLinearLayout.addView((View)relativeLayout);
        }
        this.addView((View)this.mLinearLayout);
        this.mEditText = new EditText(this.mContext);
        this.initEdittext(this.mEditText);
        this.addView((View)this.mEditText);
        this.setCursorColor();
    }

    private void initTextView(TextView textView) {
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        textView.setLayoutParams((ViewGroup.LayoutParams)lp);
        textView.setTextAlignment(4);
        textView.setGravity(17);
        textView.setTextColor(this.mEtTextColor);
        textView.setTextSize(0, this.mEtTextSize);
        this.setInputType(textView);
        textView.setPadding(0, 0, 0, 0);
    }

    private void initCursorView(View view) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(this.mEtCursorWidth, this.mEtCursorHeight);
        layoutParams.addRule(13);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void initUnderLineView(View view) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.mEtUnderLineHeight);
        layoutParams.addRule(12);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        view.setBackgroundColor(this.mEtUnderLineDefaultColor);
    }

    private void initEdittext(EditText editText) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(6, this.mLinearLayout.getId());
        layoutParams.addRule(8, this.mLinearLayout.getId());
        editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.setInputType((TextView)editText);
        editText.setBackgroundColor(0);
        editText.setTextColor(0);
        editText.setCursorVisible(false);
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                if (editable != null && editable.length() > 0) {
                    VerificationCodeInputView.this.mEditText.setText((CharSequence)"");
                    VerificationCodeInputView.this.setCode(editable.toString());
                }
            }
        });
        editText.setOnKeyListener((view, keyCode, keyEvent) -> {
            if (keyCode == 67 && keyEvent.getAction() == 0 && this.mCodes.size() > 0) {
                this.mCodes.remove(this.mCodes.size() - 1);
                this.showCode();
                return true;
            }
            return false;
        });
        editText.setOnLongClickListener(v -> {
            this.showPaste();
            return false;
        });
        this.getEtFocus(editText);
    }

    private void initPopupWindow() {
        this.mPopupWindow = new PopupWindow(-2, -2);
        TextView tv = new TextView(this.mContext);
        tv.setText((CharSequence)"\u7c98\u8d34");
        tv.setTextSize(14.0f);
        tv.setTextColor(-16777216);
        tv.setBackgroundResource(R.drawable.vciv_paste_bg);
        tv.setPadding(30, 10, 30, 10);
        tv.setOnClickListener(v -> {
            this.setCode(this.getClipboardString());
            this.mPopupWindow.dismiss();
        });
        this.mPopupWindow.setContentView((View)tv);
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        ColorDrawable dw = new ColorDrawable(0);
        this.mPopupWindow.setBackgroundDrawable((Drawable)dw);
    }

    private void setEtBackground(RelativeLayout rl, int background) {
        if (background > 0) {
            rl.setBackgroundResource(background);
        } else {
            rl.setBackgroundColor(background);
        }
    }

    private String getClipboardString() {
        ClipData.Item itemAt;
        ClipboardManager clipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        if (clipboardManager != null && clipboardManager.hasPrimaryClip() && clipboardManager.getPrimaryClipDescription().hasMimeType("text/plain") && (itemAt = clipboardManager.getPrimaryClip().getItemAt(0)) != null && !TextUtils.isEmpty((CharSequence)itemAt.getText())) {
            return itemAt.getText().toString();
        }
        return null;
    }

    private LinearLayout.LayoutParams getEtLayoutParams(int i) {
        int spacing;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.mEtWidth, this.mEtHeight);
        if (!this.isBisect) {
            spacing = this.mEtBisectSpacing / 2;
        } else {
            spacing = this.mEtSpacing / 2;
            if (this.mEtSpacing > this.mEtBisectSpacing) {
                spacing = this.mEtBisectSpacing / 2;
            }
        }
        if (i == 0) {
            layoutParams.leftMargin = 0;
            layoutParams.rightMargin = spacing;
        } else if (i == this.mEtNumber - 1) {
            layoutParams.leftMargin = spacing;
            layoutParams.rightMargin = 0;
        } else {
            layoutParams.leftMargin = spacing;
            layoutParams.rightMargin = spacing;
        }
        return layoutParams;
    }

    private void setInputType(TextView textView) {
        switch (this.mEtInputType) {
            case NUMBERPASSWORD: {
                textView.setInputType(18);
                textView.setTransformationMethod((TransformationMethod)new AsteriskPasswordTransformationMethod());
                break;
            }
            case TEXT: {
                textView.setInputType(1);
                break;
            }
            case TEXTPASSWORD: {
                textView.setInputType(17);
                textView.setTransformationMethod((TransformationMethod)new AsteriskPasswordTransformationMethod());
                break;
            }
            default: {
                textView.setInputType(2);
            }
        }
    }

    private void showPaste() {
        if (!(this.mEtInputType != VCInputType.NUMBER && this.mEtInputType != VCInputType.NUMBERPASSWORD || this.isNumeric(this.getClipboardString()))) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.getClipboardString())) {
            if (this.mPopupWindow == null) {
                this.initPopupWindow();
            }
            this.mPopupWindow.showAsDropDown((View)this.mTextViews[0], 0, 20);
            SoftInputUtils.hideSoftInput((Activity)this.getContext());
        }
    }

    private boolean isNumeric(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    private void setCode(String code) {
        if (TextUtils.isEmpty((CharSequence)code)) {
            return;
        }
        for (int i = 0; i < code.length(); ++i) {
            if (this.mCodes.size() >= this.mEtNumber) continue;
            this.mCodes.add(String.valueOf(code.charAt(i)));
        }
        this.showCode();
    }

    private void showCode() {
        for (int i = 0; i < this.mEtNumber; ++i) {
            TextView textView = this.mTextViews[i];
            if (this.mCodes.size() > i) {
                textView.setText((CharSequence)this.mCodes.get(i));
                continue;
            }
            textView.setText((CharSequence)"");
        }
        this.setCursorColor();
        this.setCallBack();
    }

    private void setCursorColor() {
        if (this.valueAnimator != null) {
            this.valueAnimator.cancel();
        }
        for (int i = 0; i < this.mEtNumber; ++i) {
            View cursorView = this.mCursorViews[i];
            cursorView.setBackgroundColor(0);
            if (this.mEtUnderLineShow) {
                View underLineView = this.mUnderLineViews[i];
                underLineView.setBackgroundColor(this.mEtUnderLineDefaultColor);
            }
            if (!this.isFocusBackgroud) continue;
            this.setEtBackground(this.mRelativeLayouts[i], this.mEtBackground);
        }
        if (this.mCodes.size() < this.mEtNumber) {
            this.setCursorView(this.mCursorViews[this.mCodes.size()]);
            if (this.mEtUnderLineShow) {
                this.mUnderLineViews[this.mCodes.size()].setBackgroundColor(this.mEtUnderLineFocusColor);
            }
            if (this.isFocusBackgroud) {
                this.setEtBackground(this.mRelativeLayouts[this.mCodes.size()], this.mEtFocusBackground);
            }
        }
    }

    private void setCursorView(View view) {
        this.valueAnimator = ObjectAnimator.ofInt((Object)view, (String)"backgroundColor", (int[])new int[]{this.mEtCursorColor, 17170445});
        this.valueAnimator.setDuration(1500L);
        this.valueAnimator.setRepeatCount(-1);
        this.valueAnimator.setRepeatMode(1);
        this.valueAnimator.setEvaluator((fraction, startValue, endValue) -> fraction <= 0.5f ? startValue : endValue);
        this.valueAnimator.start();
    }

    private void setCallBack() {
        if (this.onInputListener == null) {
            return;
        }
        if (this.mCodes.size() == this.mEtNumber) {
            this.onInputListener.onComplete(this.getCode());
        } else {
            this.onInputListener.onInput();
        }
    }

    private String getCode() {
        StringBuilder sb = new StringBuilder();
        for (String code : this.mCodes) {
            sb.append(code);
        }
        return sb.toString();
    }

    public void clearCode() {
        this.mCodes.clear();
        this.showCode();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mViewWidth = this.getMeasuredWidth();
        this.updateETMargin();
    }

    private void updateETMargin() {
        this.mEtBisectSpacing = (this.mViewWidth - this.mEtNumber * this.mEtWidth) / (this.mEtNumber - 1);
        for (int i = 0; i < this.mEtNumber; ++i) {
            this.mLinearLayout.getChildAt(i).setLayoutParams((ViewGroup.LayoutParams)this.getEtLayoutParams(i));
        }
    }

    private void getEtFocus(EditText editText) {
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        SoftInputUtils.showSoftInput(this.getContext(), (View)editText);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SoftInputUtils.hideSoftInput((Activity)this.getContext());
        if (this.valueAnimator != null) {
            this.valueAnimator.cancel();
        }
    }

    public void setOnInputListener(OnInputListener onInputListener) {
        this.onInputListener = onInputListener;
    }

    public static interface OnInputListener {
        public void onComplete(String var1);

        public void onInput();
    }

    public static enum VCInputType {
        NUMBER,
        NUMBERPASSWORD,
        TEXT,
        TEXTPASSWORD;

    }
}

