/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators;

import android.widget.EditText;
import convalida.validators.AbstractValidator;
import java.math.BigDecimal;

public class NumberLimitValidator
extends AbstractValidator {
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private boolean required;

    public NumberLimitValidator(EditText editText, String errorMessage, boolean autoDismiss, String min, String max, boolean required) {
        super(editText, errorMessage, autoDismiss);
        this.minValue = new BigDecimal(min);
        this.maxValue = new BigDecimal(max);
        this.required = required;
    }

    @Override
    public boolean isValid(String value) {
        if (this.required && value.isEmpty()) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(value);
            return bigDecimal.compareTo(this.minValue) > -1 && bigDecimal.compareTo(this.maxValue) < 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

