/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators;

import android.widget.EditText;
import convalida.validators.util.EditTextUtils;
import convalida.validators.util.ExecuteValidationListener;

public abstract class AbstractValidator {
    protected EditText editText;
    protected String errorMessage;
    private boolean hasError = false;

    public AbstractValidator(EditText editText, String errorMessage, boolean autoDismiss) {
        this.editText = editText;
        this.errorMessage = errorMessage;
        if (autoDismiss) {
            EditTextUtils.addOnTextChangedListener(editText, new ExecuteValidationListener(){

                @Override
                public void execute(String value) {
                    AbstractValidator.this.executeValidation(value);
                }
            });
        }
    }

    public abstract boolean isValid(String var1);

    private void executeValidation(String value) {
        boolean bl = this.hasError = !EditTextUtils.isVisible(this.editText) && !this.isValid(value);
        if (this.hasError) {
            EditTextUtils.setError(this.editText, this.errorMessage);
        } else {
            EditTextUtils.setError(this.editText, null);
        }
    }

    public boolean validate() {
        this.executeValidation(this.editText.getText().toString());
        return !this.hasError;
    }

    public void clear() {
        EditTextUtils.setError(this.editText, null);
    }
}

