/*
 * Decompiled with CFR 0.152.
 */
package convalida.compiler;

import convalida.compiler.Messager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

class Preconditions {
    private Preconditions() {
    }

    static boolean methodHasParams(ExecutableElement method, Class<? extends Annotation> annotationClass) {
        boolean hasParams = false;
        if (method.getParameters().size() > 0) {
            hasParams = true;
            Messager.error(method, "Method annotated with @%s can not have parameters.", annotationClass.getSimpleName());
        }
        return hasParams;
    }

    static boolean hasMoreThanOneMethodsAnnotatedWith(Element parent, Class<? extends Annotation> annotationClass) {
        boolean hasMoreThanOneElement = false;
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : parent.getEnclosedElements()) {
            if (element.getAnnotation(annotationClass) == null) continue;
            elements.add(element);
        }
        if (elements.size() > 1) {
            hasMoreThanOneElement = true;
            Messager.error(parent, "The class %s must have only one element annotated with @%s.", parent.getSimpleName(), annotationClass.getSimpleName());
        }
        return hasMoreThanOneElement;
    }

    static boolean hasNoMethodAnnotatedWith(Element parent, Class<? extends Annotation> annotationClass) {
        boolean hasNoElements = false;
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : parent.getEnclosedElements()) {
            if (element.getAnnotation(annotationClass) == null) continue;
            elements.add(element);
        }
        if (elements.size() == 0) {
            hasNoElements = true;
            Messager.error(parent, "The class %s must have one method annotated with @%s.", parent.getSimpleName(), annotationClass.getSimpleName());
        }
        return hasNoElements;
    }

    static boolean confirmValidationElementsHasError(Class<? extends Annotation> primaryAnnotation, Class<? extends Annotation> confirmAnnotation, Element element) {
        boolean hasError = false;
        String primaryAnnotationClassName = primaryAnnotation.getSimpleName();
        String confirmAnnotationClassName = confirmAnnotation.getSimpleName();
        int elementsAnnotatedWithPrimaryValidation = 0;
        int elementsAnnotatedWithConfirmValidation = 0;
        List<? extends Element> elementsOfParent = element.getEnclosingElement().getEnclosedElements();
        for (int i = 0; i < elementsOfParent.size(); ++i) {
            if (elementsOfParent.get(i).getAnnotation(primaryAnnotation) != null) {
                ++elementsAnnotatedWithPrimaryValidation;
            }
            if (elementsOfParent.get(i).getAnnotation(confirmAnnotation) == null) continue;
            ++elementsAnnotatedWithConfirmValidation;
        }
        if (elementsAnnotatedWithPrimaryValidation == 0 && elementsAnnotatedWithConfirmValidation > 0) {
            hasError = true;
            TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
            Messager.error(element.getEnclosingElement(), "%s must have at least one element annotated with @%s.", enclosingElement.getSimpleName(), primaryAnnotationClassName);
        }
        if (elementsAnnotatedWithConfirmValidation > 1) {
            hasError = true;
            TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
            Messager.error(element.getEnclosingElement(), "%s must have only one element annotated with @%s.", enclosingElement.getSimpleName(), confirmAnnotationClassName);
        }
        return hasError;
    }

    static boolean isInvalid(Class<? extends Annotation> annotationClass, Element element) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        String elementType = element.asType().toString();
        boolean hasError = false;
        if (!element.getKind().equals((Object)ElementKind.FIELD)) {
            Messager.error(element, "@%s must only be applied in fields. (%s.%s)", annotationClass.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (!"android.widget.EditText".equals(elementType)) {
            Messager.error(element, "@%s must only be applied in fields of the type TextInputLaytout or EditText. (%s.%s)", annotationClass.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        return hasError;
    }

    static boolean isInaccessible(Class<? extends Annotation> annotationClass, Element element) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        boolean hasError = false;
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC)) {
            Messager.error(element, "@%s must not be applied in private or static fields. (%s.%s)", annotationClass.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            Messager.error(enclosingElement, "@%s fields may only be contained in classes. (%s.%s)", annotationClass.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            Messager.error(enclosingElement, "@%s fields may not be contained in private classes. (%s.%s)", annotationClass.getSimpleName(), enclosingElement.getQualifiedName(), element.getSimpleName());
            hasError = true;
        }
        return hasError;
    }
}

