/*
 * Decompiled with CFR 0.152.
 */
package net.wedjaa.ansible.vault.crypto.decoders.implementation;

import de.rtner.security.auth.spi.PBKDF2Engine;
import de.rtner.security.auth.spi.PBKDF2Parameters;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class EncryptionKeychain {
    private static final String CHAR_ENCODING = "UTF-8";
    private final String password;
    private final byte[] salt;
    private final int keylen;
    private final int ivlen;
    private final int iterations;
    private final String algo;
    private byte[] encryptionKey;
    private byte[] hmacKey;
    private byte[] iv;

    public EncryptionKeychain(byte[] salt, String password, int keylen, int ivlen, int iterations, String algo) {
        this.password = password;
        this.salt = salt;
        this.keylen = keylen;
        this.ivlen = ivlen;
        this.iterations = iterations;
        this.algo = algo;
    }

    public EncryptionKeychain(int saltLen, String password, int keylen, int ivlen, int iterations, String algo) {
        this.password = password;
        this.salt = this.generateSalt(saltLen);
        this.keylen = keylen;
        this.ivlen = ivlen;
        this.iterations = iterations;
        this.algo = algo;
    }

    private byte[] createRawKey() throws IOException {
        try {
            PBKDF2Parameters params = new PBKDF2Parameters(this.algo, CHAR_ENCODING, this.salt, this.iterations);
            int keylength = this.ivlen + 2 * this.keylen;
            PBKDF2Engine pbkdf2Engine = new PBKDF2Engine(params);
            byte[] keys = pbkdf2Engine.deriveKey(this.password, keylength);
            return keys;
        }
        catch (Exception ex) {
            throw new IOException("Cryptofailure: " + ex.getMessage());
        }
    }

    public void createKeys() throws IOException {
        byte[] rawkeys = this.createRawKey();
        this.encryptionKey = this.getEncryptionKey(rawkeys);
        this.hmacKey = this.getHMACKey(rawkeys);
        this.iv = this.getIV(rawkeys);
    }

    private byte[] getEncryptionKey(byte[] keys) {
        byte[] result = Arrays.copyOfRange(keys, 0, this.keylen);
        return result;
    }

    private byte[] getHMACKey(byte[] keys) {
        byte[] result = Arrays.copyOfRange(keys, this.keylen, this.keylen * 2);
        return result;
    }

    private byte[] getIV(byte[] keys) {
        byte[] result = Arrays.copyOfRange(keys, this.keylen * 2, this.keylen * 2 + this.ivlen);
        return result;
    }

    private byte[] generateSalt(int length) {
        byte[] salt = new byte[length];
        new Random().nextBytes(salt);
        return salt;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public byte[] getHmacKey() {
        return this.hmacKey;
    }

    public byte[] getIv() {
        return this.iv;
    }
}

