/*
 * Decompiled with CFR 0.152.
 */
package net.wedjaa.ansible.vault.crypto.data;

import net.wedjaa.ansible.vault.crypto.decoders.CypherFactory;
import net.wedjaa.ansible.vault.crypto.decoders.inter.CypherInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultInfo {
    Logger logger = LoggerFactory.getLogger(VaultInfo.class);
    public static final String INFO_SEPARATOR = ";";
    public static final int INFO_ELEMENTS = 3;
    public static final int MAGIC_PART = 0;
    public static final int VERSION_PART = 1;
    public static final int CYPHER_PART = 2;
    public static final String VAULT_MAGIC = "$ANSIBLE_VAULT";
    public static final String VAULT_VERSION = "1.1";
    private boolean validVault;
    private String vaultVersion;
    private String vaultCypher;

    public static String vaultInfoForCypher(String vaultCypher) {
        String infoLine = "$ANSIBLE_VAULT;1.1;" + vaultCypher;
        return infoLine;
    }

    public VaultInfo(String infoLine) {
        this.logger.debug("Ansible Vault info: {}", (Object)infoLine);
        String[] infoParts = infoLine.split(INFO_SEPARATOR);
        if (infoParts.length == 3 && infoParts[0].equals(VAULT_MAGIC)) {
            this.validVault = true;
            this.vaultVersion = infoParts[1];
            this.vaultCypher = infoParts[2];
        }
    }

    public boolean isEncryptedVault() {
        return this.validVault;
    }

    public CypherInterface getCypher() {
        return CypherFactory.getCypher(this.vaultCypher);
    }

    public String getVaultVersion() {
        return this.vaultVersion;
    }

    public boolean isValidVault() {
        return this.isEncryptedVault() && this.getCypher() != null;
    }
}

