/*
 * Decompiled with CFR 0.152.
 */
package net.wedjaa.ansible.vault.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wedjaa.ansible.vault.crypto.data.Util;
import net.wedjaa.ansible.vault.crypto.data.VaultInfo;
import net.wedjaa.ansible.vault.crypto.decoders.CypherFactory;
import net.wedjaa.ansible.vault.crypto.decoders.inter.CypherInterface;
import org.apache.commons.io.IOUtils;

public class VaultHandler {
    public static final String DEFAULT_CYPHER = "AES256";
    public static final String CHAR_ENCODING = "UTF-8";

    public static byte[] encrypt(byte[] cleartext, String password, String cypher) throws IOException {
        CypherInterface cypherInstance = CypherFactory.getCypher(cypher);
        byte[] vaultData = cypherInstance.encrypt(cleartext, password);
        String vaultDataString = new String(vaultData);
        String vaultPackage = cypherInstance.infoLine() + "\n" + vaultDataString;
        return vaultPackage.getBytes();
    }

    public static byte[] encrypt(byte[] cleartext, String password) throws IOException {
        return VaultHandler.encrypt(cleartext, password, DEFAULT_CYPHER);
    }

    public static void encrypt(InputStream clearText, OutputStream cipherText, String password, String cypher) throws IOException {
        String clearTextValue = IOUtils.toString(clearText, CHAR_ENCODING);
        cipherText.write(VaultHandler.encrypt(clearTextValue.getBytes(), password, cypher));
    }

    public static void encrypt(InputStream clearText, OutputStream cipherText, String password) throws IOException {
        VaultHandler.encrypt(clearText, cipherText, password, DEFAULT_CYPHER);
    }

    public static void decrypt(InputStream encryptedVault, OutputStream decryptedVault, String password) throws IOException {
        String encryptedValue = IOUtils.toString(encryptedVault, CHAR_ENCODING);
        decryptedVault.write(VaultHandler.decrypt(encryptedValue.getBytes(), password));
    }

    public static byte[] decrypt(byte[] encrypted, String password) throws IOException {
        VaultInfo vaultInfo = Util.getVaultInfo(encrypted);
        if (!vaultInfo.isEncryptedVault()) {
            throw new IOException("File is not an Ansible Encrypted Vault");
        }
        if (!vaultInfo.isValidVault()) {
            throw new IOException("The vault is not a format we can handle - check the cypher.");
        }
        byte[] encryptedData = Util.getVaultData(encrypted);
        return vaultInfo.getCypher().decrypt(encryptedData, password);
    }
}

